/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.HttpAdapterList;
import com.sun.xml.internal.ws.transport.http.server.PortableHttpHandler;
import com.sun.xml.internal.ws.transport.http.server.ServerMgr;
import com.sun.xml.internal.ws.transport.http.server.WSHttpHandler;
import java.util.concurrent.Executor;
import javax.xml.ws.EndpointReference;
import org.w3c.dom.Element;

public final class HttpEndpoint
extends com.sun.xml.internal.ws.api.server.HttpEndpoint {
    private String address;
    private HttpContext httpContext;
    private final HttpAdapter adapter;
    private final Executor executor;

    public HttpEndpoint(Executor executor, HttpAdapter httpAdapter) {
        this.executor = executor;
        this.adapter = httpAdapter;
    }

    @Override
    public void publish(String string) {
        this.address = string;
        this.httpContext = ServerMgr.getInstance().createContext(string);
        this.publish(this.httpContext);
    }

    public void publish(Object object) {
        if (object instanceof javax.xml.ws.spi.http.HttpContext) {
            this.setHandler((javax.xml.ws.spi.http.HttpContext)object);
            return;
        }
        if (object instanceof HttpContext) {
            this.httpContext = (HttpContext)object;
            this.setHandler(this.httpContext);
            return;
        }
        throw new ServerRtException(ServerMessages.NOT_KNOW_HTTP_CONTEXT_TYPE(object.getClass(), HttpContext.class, javax.xml.ws.spi.http.HttpContext.class), new Object[0]);
    }

    HttpAdapterList getAdapterOwner() {
        return this.adapter.owner;
    }

    private String getEPRAddress() {
        if (this.address == null) {
            return this.httpContext.getServer().getAddress().toString();
        }
        return this.address;
    }

    @Override
    public void stop() {
        if (this.httpContext != null) {
            if (this.address == null) {
                this.httpContext.getServer().removeContext(this.httpContext);
            } else {
                ServerMgr.getInstance().removeContext(this.httpContext);
            }
        }
        this.adapter.getEndpoint().dispose();
    }

    private void setHandler(HttpContext httpContext) {
        httpContext.setHandler(new WSHttpHandler(this.adapter, this.executor));
    }

    private void setHandler(javax.xml.ws.spi.http.HttpContext httpContext) {
        httpContext.setHandler(new PortableHttpHandler(this.adapter, this.executor));
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... elementArray) {
        WSEndpointImpl wSEndpointImpl = (WSEndpointImpl)this.adapter.getEndpoint();
        String string = this.getEPRAddress();
        return (T)((EndpointReference)clazz.cast(wSEndpointImpl.getEndpointReference(clazz, string, string + "?wsdl", elementArray)));
    }
}

