/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.NestedPolicy;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;

class NormalizedModelGenerator
extends PolicyModelGenerator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(NormalizedModelGenerator.class);
    private final PolicyModelGenerator.PolicySourceModelCreator sourceModelCreator;

    NormalizedModelGenerator(PolicyModelGenerator.PolicySourceModelCreator policySourceModelCreator) {
        this.sourceModelCreator = policySourceModelCreator;
    }

    @Override
    public PolicySourceModel translate(Policy policy) throws PolicyException {
        LOGGER.entering(policy);
        PolicySourceModel policySourceModel = null;
        if (policy == null) {
            LOGGER.fine(LocalizationMessages.WSP_0047_POLICY_IS_NULL_RETURNING());
        } else {
            policySourceModel = this.sourceModelCreator.create(policy);
            ModelNode modelNode = policySourceModel.getRootNode();
            ModelNode modelNode2 = modelNode.createChildExactlyOneNode();
            for (AssertionSet assertionSet : policy) {
                ModelNode modelNode3 = modelNode2.createChildAllNode();
                for (PolicyAssertion policyAssertion : assertionSet) {
                    AssertionData assertionData = AssertionData.createAssertionData(policyAssertion.getName(), policyAssertion.getValue(), policyAssertion.getAttributes(), policyAssertion.isOptional(), policyAssertion.isIgnorable());
                    ModelNode modelNode4 = modelNode3.createChildAssertionNode(assertionData);
                    if (policyAssertion.hasNestedPolicy()) {
                        this.translate(modelNode4, policyAssertion.getNestedPolicy());
                    }
                    if (!policyAssertion.hasParameters()) continue;
                    this.translate(modelNode4, policyAssertion.getParametersIterator());
                }
            }
        }
        LOGGER.exiting(policySourceModel);
        return policySourceModel;
    }

    @Override
    protected ModelNode translate(ModelNode modelNode, NestedPolicy nestedPolicy) {
        ModelNode modelNode2 = modelNode.createChildPolicyNode();
        ModelNode modelNode3 = modelNode2.createChildExactlyOneNode();
        AssertionSet assertionSet = nestedPolicy.getAssertionSet();
        ModelNode modelNode4 = modelNode3.createChildAllNode();
        this.translate(modelNode4, assertionSet);
        return modelNode2;
    }
}

