/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.ws.addressing.policy.AddressingPolicyMapConfigurator;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.model.CheckedException;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundFault;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLInput;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.api.policy.ModelGenerator;
import com.sun.xml.internal.ws.api.policy.PolicyResolver;
import com.sun.xml.internal.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGenExtnContext;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.encoding.policy.MtomPolicyMapConfigurator;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapExtender;
import com.sun.xml.internal.ws.policy.PolicyMapMutator;
import com.sun.xml.internal.ws.policy.PolicyMapUtil;
import com.sun.xml.internal.ws.policy.PolicyMerger;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.jaxws.PolicyUtil;
import com.sun.xml.internal.ws.policy.jaxws.WSDLBoundFaultContainer;
import com.sun.xml.internal.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelMarshaller;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.XmlToken;
import com.sun.xml.internal.ws.policy.subject.WsdlBindingSubject;
import com.sun.xml.internal.ws.resources.PolicyMessages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class PolicyWSDLGeneratorExtension
extends WSDLGeneratorExtension {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyWSDLGeneratorExtension.class);
    private PolicyMap policyMap;
    private SEIModel seiModel;
    private final Collection<PolicySubject> subjects = new LinkedList<PolicySubject>();
    private final PolicyModelMarshaller marshaller = PolicyModelMarshaller.getXmlMarshaller(true);
    private final PolicyMerger merger = PolicyMerger.getMerger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(WSDLGenExtnContext wSDLGenExtnContext) {
        LOGGER.entering();
        try {
            Object object;
            this.seiModel = wSDLGenExtnContext.getModel();
            PolicyMapConfigurator[] policyMapConfiguratorArray = this.loadConfigurators();
            PolicyMapMutator[] policyMapMutatorArray = new PolicyMapExtender[policyMapConfiguratorArray.length];
            for (int i = 0; i < policyMapConfiguratorArray.length; ++i) {
                policyMapMutatorArray[i] = PolicyMapExtender.createPolicyMapExtender();
            }
            this.policyMap = PolicyResolverFactory.create().resolve(new PolicyResolver.ServerContext(this.policyMap, wSDLGenExtnContext.getContainer(), wSDLGenExtnContext.getEndpointClass(), false, policyMapMutatorArray));
            if (this.policyMap == null) {
                LOGGER.fine(PolicyMessages.WSP_1019_CREATE_EMPTY_POLICY_MAP());
                this.policyMap = PolicyMap.createPolicyMap(Arrays.asList(policyMapMutatorArray));
            }
            WSBinding wSBinding = wSDLGenExtnContext.getBinding();
            try {
                object = new LinkedList<PolicySubject>();
                for (int i = 0; i < policyMapConfiguratorArray.length; ++i) {
                    object.addAll(policyMapConfiguratorArray[i].update(this.policyMap, this.seiModel, wSBinding));
                    policyMapMutatorArray[i].disconnect();
                }
                PolicyMapUtil.insertPolicies(this.policyMap, object, this.seiModel.getServiceQName(), this.seiModel.getPortName());
            }
            catch (PolicyException policyException) {
                throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1017_MAP_UPDATE_FAILED(), policyException));
            }
            object = wSDLGenExtnContext.getRoot();
            object._namespace(NamespaceVersion.v1_2.toString(), NamespaceVersion.v1_2.getDefaultNamespacePrefix());
            object._namespace(NamespaceVersion.v1_5.toString(), NamespaceVersion.v1_5.getDefaultNamespacePrefix());
            object._namespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefinitionsExtension(TypedXmlWriter typedXmlWriter) {
        block11: {
            try {
                LOGGER.entering();
                if (this.policyMap == null) {
                    LOGGER.fine(PolicyMessages.WSP_1009_NOT_MARSHALLING_ANY_POLICIES_POLICY_MAP_IS_NULL());
                    break block11;
                }
                this.subjects.addAll(this.policyMap.getPolicySubjects());
                PolicyModelGenerator policyModelGenerator = ModelGenerator.getGenerator();
                HashSet<String> hashSet = new HashSet<String>();
                for (PolicySubject policySubject : this.subjects) {
                    Policy policy;
                    if (policySubject.getSubject() == null) {
                        LOGGER.fine(PolicyMessages.WSP_1008_NOT_MARSHALLING_WSDL_SUBJ_NULL(policySubject));
                        continue;
                    }
                    try {
                        policy = policySubject.getEffectivePolicy(this.merger);
                    }
                    catch (PolicyException policyException) {
                        throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1011_FAILED_TO_RETRIEVE_EFFECTIVE_POLICY_FOR_SUBJECT(policySubject.toString()), policyException));
                    }
                    if (null == policy.getIdOrName() || hashSet.contains(policy.getIdOrName())) {
                        LOGGER.fine(PolicyMessages.WSP_1016_POLICY_ID_NULL_OR_DUPLICATE(policy));
                        continue;
                    }
                    try {
                        PolicySourceModel policySourceModel = policyModelGenerator.translate(policy);
                        this.marshaller.marshal(policySourceModel, (Object)typedXmlWriter);
                    }
                    catch (PolicyException policyException) {
                        throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1018_FAILED_TO_MARSHALL_POLICY(policy.getIdOrName()), policyException));
                    }
                    hashSet.add(policy.getIdOrName());
                }
            }
            finally {
                LOGGER.exiting();
            }
        }
    }

    @Override
    public void addServiceExtension(TypedXmlWriter typedXmlWriter) {
        LOGGER.entering();
        String string = null == this.seiModel ? null : this.seiModel.getServiceQName().getLocalPart();
        this.selectAndProcessSubject(typedXmlWriter, WSDLService.class, ScopeType.SERVICE, string);
        LOGGER.exiting();
    }

    @Override
    public void addPortExtension(TypedXmlWriter typedXmlWriter) {
        LOGGER.entering();
        String string = null == this.seiModel ? null : this.seiModel.getPortName().getLocalPart();
        this.selectAndProcessSubject(typedXmlWriter, WSDLPort.class, ScopeType.ENDPOINT, string);
        LOGGER.exiting();
    }

    @Override
    public void addPortTypeExtension(TypedXmlWriter typedXmlWriter) {
        LOGGER.entering();
        String string = null == this.seiModel ? null : this.seiModel.getPortTypeName().getLocalPart();
        this.selectAndProcessSubject(typedXmlWriter, WSDLPortType.class, ScopeType.ENDPOINT, string);
        LOGGER.exiting();
    }

    @Override
    public void addBindingExtension(TypedXmlWriter typedXmlWriter) {
        LOGGER.entering();
        QName qName = null == this.seiModel ? null : this.seiModel.getBoundPortTypeName();
        this.selectAndProcessBindingSubject(typedXmlWriter, WSDLBoundPortType.class, ScopeType.ENDPOINT, qName);
        LOGGER.exiting();
    }

    @Override
    public void addOperationExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        this.selectAndProcessSubject(typedXmlWriter, WSDLOperation.class, ScopeType.OPERATION, (String)null);
        LOGGER.exiting();
    }

    @Override
    public void addBindingOperationExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        QName qName = javaMethod == null ? null : new QName(javaMethod.getOwner().getTargetNamespace(), javaMethod.getOperationName());
        this.selectAndProcessBindingSubject(typedXmlWriter, WSDLBoundOperation.class, ScopeType.OPERATION, qName);
        LOGGER.exiting();
    }

    @Override
    public void addInputMessageExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        String string = null == javaMethod ? null : javaMethod.getRequestMessageName();
        this.selectAndProcessSubject(typedXmlWriter, WSDLMessage.class, ScopeType.INPUT_MESSAGE, string);
        LOGGER.exiting();
    }

    @Override
    public void addOutputMessageExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        String string = null == javaMethod ? null : javaMethod.getResponseMessageName();
        this.selectAndProcessSubject(typedXmlWriter, WSDLMessage.class, ScopeType.OUTPUT_MESSAGE, string);
        LOGGER.exiting();
    }

    @Override
    public void addFaultMessageExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod, CheckedException checkedException) {
        LOGGER.entering();
        String string = null == checkedException ? null : checkedException.getMessageName();
        this.selectAndProcessSubject(typedXmlWriter, WSDLMessage.class, ScopeType.FAULT_MESSAGE, string);
        LOGGER.exiting();
    }

    @Override
    public void addOperationInputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        String string = null == javaMethod ? null : javaMethod.getRequestMessageName();
        this.selectAndProcessSubject(typedXmlWriter, WSDLInput.class, ScopeType.INPUT_MESSAGE, string);
        LOGGER.exiting();
    }

    @Override
    public void addOperationOutputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        String string = null == javaMethod ? null : javaMethod.getResponseMessageName();
        this.selectAndProcessSubject(typedXmlWriter, WSDLOutput.class, ScopeType.OUTPUT_MESSAGE, string);
        LOGGER.exiting();
    }

    @Override
    public void addOperationFaultExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod, CheckedException checkedException) {
        LOGGER.entering();
        String string = null == checkedException ? null : checkedException.getMessageName();
        this.selectAndProcessSubject(typedXmlWriter, WSDLFault.class, ScopeType.FAULT_MESSAGE, string);
        LOGGER.exiting();
    }

    @Override
    public void addBindingOperationInputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        QName qName = new QName(javaMethod.getOwner().getTargetNamespace(), javaMethod.getOperationName());
        this.selectAndProcessBindingSubject(typedXmlWriter, WSDLBoundOperation.class, ScopeType.INPUT_MESSAGE, qName);
        LOGGER.exiting();
    }

    @Override
    public void addBindingOperationOutputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        LOGGER.entering();
        QName qName = new QName(javaMethod.getOwner().getTargetNamespace(), javaMethod.getOperationName());
        this.selectAndProcessBindingSubject(typedXmlWriter, WSDLBoundOperation.class, ScopeType.OUTPUT_MESSAGE, qName);
        LOGGER.exiting();
    }

    @Override
    public void addBindingOperationFaultExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod, CheckedException checkedException) {
        LOGGER.entering(typedXmlWriter, javaMethod, checkedException);
        if (this.subjects != null) {
            for (PolicySubject policySubject : this.subjects) {
                Object object;
                String string;
                Object object2;
                if (!this.policyMap.isFaultMessageSubject(policySubject) || (object2 = policySubject.getSubject()) == null) continue;
                String string2 = string = checkedException == null ? null : checkedException.getMessageName();
                if (string == null) {
                    this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
                }
                if (WSDLBoundFaultContainer.class.isInstance(object2)) {
                    object = (WSDLBoundFaultContainer)object2;
                    WSDLBoundFault wSDLBoundFault = ((WSDLBoundFaultContainer)object).getBoundFault();
                    WSDLBoundOperation wSDLBoundOperation = ((WSDLBoundFaultContainer)object).getBoundOperation();
                    if (!string.equals(wSDLBoundFault.getName()) || !wSDLBoundOperation.getName().getLocalPart().equals(javaMethod.getOperationName())) continue;
                    this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
                    continue;
                }
                if (!WsdlBindingSubject.class.isInstance(object2) || ((WsdlBindingSubject)(object = (WsdlBindingSubject)object2)).getMessageType() != WsdlBindingSubject.WsdlMessageType.FAULT || !checkedException.getOwner().getTargetNamespace().equals(((WsdlBindingSubject)object).getName().getNamespaceURI()) || !string.equals(((WsdlBindingSubject)object).getName().getLocalPart())) continue;
                this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
            }
        }
        LOGGER.exiting();
    }

    private void selectAndProcessSubject(TypedXmlWriter typedXmlWriter, Class clazz, ScopeType scopeType, QName qName) {
        LOGGER.entering(new Object[]{typedXmlWriter, clazz, scopeType, qName});
        if (qName == null) {
            this.selectAndProcessSubject(typedXmlWriter, clazz, scopeType, (String)null);
        } else {
            if (this.subjects != null) {
                for (PolicySubject policySubject : this.subjects) {
                    if (!qName.equals(policySubject.getSubject())) continue;
                    this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
                }
            }
            this.selectAndProcessSubject(typedXmlWriter, clazz, scopeType, qName.getLocalPart());
        }
        LOGGER.exiting();
    }

    private void selectAndProcessBindingSubject(TypedXmlWriter typedXmlWriter, Class clazz, ScopeType scopeType, QName qName) {
        LOGGER.entering(new Object[]{typedXmlWriter, clazz, scopeType, qName});
        if (this.subjects != null && qName != null) {
            for (PolicySubject policySubject : this.subjects) {
                WsdlBindingSubject wsdlBindingSubject;
                if (!(policySubject.getSubject() instanceof WsdlBindingSubject) || !qName.equals((wsdlBindingSubject = (WsdlBindingSubject)policySubject.getSubject()).getName())) continue;
                this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
            }
        }
        this.selectAndProcessSubject(typedXmlWriter, clazz, scopeType, qName);
        LOGGER.exiting();
    }

    private void selectAndProcessSubject(TypedXmlWriter typedXmlWriter, Class clazz, ScopeType scopeType, String string) {
        LOGGER.entering(new Object[]{typedXmlWriter, clazz, scopeType, string});
        if (this.subjects != null) {
            for (PolicySubject policySubject : this.subjects) {
                Object object;
                if (!PolicyWSDLGeneratorExtension.isCorrectType(this.policyMap, policySubject, scopeType) || (object = policySubject.getSubject()) == null || !clazz.isInstance(object)) continue;
                if (null == string) {
                    this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
                    continue;
                }
                try {
                    Method method = clazz.getDeclaredMethod("getName", new Class[0]);
                    if (!this.stringEqualsToStringOrQName(string, method.invoke(object, new Object[0]))) continue;
                    this.writePolicyOrReferenceIt(policySubject, typedXmlWriter);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1003_UNABLE_TO_CHECK_ELEMENT_NAME(clazz.getName(), string), noSuchMethodException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1003_UNABLE_TO_CHECK_ELEMENT_NAME(clazz.getName(), string), illegalAccessException));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1003_UNABLE_TO_CHECK_ELEMENT_NAME(clazz.getName(), string), invocationTargetException));
                }
            }
        }
        LOGGER.exiting();
    }

    private static boolean isCorrectType(PolicyMap policyMap, PolicySubject policySubject, ScopeType scopeType) {
        switch (scopeType) {
            case OPERATION: {
                return !policyMap.isInputMessageSubject(policySubject) && !policyMap.isOutputMessageSubject(policySubject) && !policyMap.isFaultMessageSubject(policySubject);
            }
            case INPUT_MESSAGE: {
                return policyMap.isInputMessageSubject(policySubject);
            }
            case OUTPUT_MESSAGE: {
                return policyMap.isOutputMessageSubject(policySubject);
            }
            case FAULT_MESSAGE: {
                return policyMap.isFaultMessageSubject(policySubject);
            }
        }
        return true;
    }

    private boolean stringEqualsToStringOrQName(String string, Object object) {
        return object instanceof QName ? string.equals(((QName)object).getLocalPart()) : string.equals(object);
    }

    private void writePolicyOrReferenceIt(PolicySubject policySubject, TypedXmlWriter typedXmlWriter) {
        Policy policy;
        try {
            policy = policySubject.getEffectivePolicy(this.merger);
        }
        catch (PolicyException policyException) {
            throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1011_FAILED_TO_RETRIEVE_EFFECTIVE_POLICY_FOR_SUBJECT(policySubject.toString()), policyException));
        }
        if (policy != null) {
            if (null == policy.getIdOrName()) {
                PolicyModelGenerator policyModelGenerator = ModelGenerator.getGenerator();
                try {
                    PolicySourceModel policySourceModel = policyModelGenerator.translate(policy);
                    this.marshaller.marshal(policySourceModel, (Object)typedXmlWriter);
                }
                catch (PolicyException policyException) {
                    throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1002_UNABLE_TO_MARSHALL_POLICY_OR_POLICY_REFERENCE(), policyException));
                }
            } else {
                TypedXmlWriter typedXmlWriter2 = typedXmlWriter._element(policy.getNamespaceVersion().asQName(XmlToken.PolicyReference), TypedXmlWriter.class);
                typedXmlWriter2._attribute(XmlToken.Uri.toString(), (Object)('#' + policy.getIdOrName()));
            }
        }
    }

    private PolicyMapConfigurator[] loadConfigurators() {
        LinkedList<PolicyMapConfigurator> linkedList = new LinkedList<PolicyMapConfigurator>();
        linkedList.add(new AddressingPolicyMapConfigurator());
        linkedList.add(new MtomPolicyMapConfigurator());
        PolicyUtil.addServiceProviders(linkedList, PolicyMapConfigurator.class);
        return linkedList.toArray(new PolicyMapConfigurator[linkedList.size()]);
    }

    static enum ScopeType {
        SERVICE,
        ENDPOINT,
        OPERATION,
        INPUT_MESSAGE,
        OUTPUT_MESSAGE,
        FAULT_MESSAGE;

    }
}

