/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionValidator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class AssertionValidationProcessor {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AssertionValidationProcessor.class);
    private final Collection<PolicyAssertionValidator> validators = new LinkedList<PolicyAssertionValidator>();

    private AssertionValidationProcessor() throws PolicyException {
        this(null);
    }

    protected AssertionValidationProcessor(Collection<PolicyAssertionValidator> collection) throws PolicyException {
        for (PolicyAssertionValidator policyAssertionValidator : PolicyUtils.ServiceProvider.load(PolicyAssertionValidator.class)) {
            this.validators.add(policyAssertionValidator);
        }
        if (collection != null) {
            for (PolicyAssertionValidator policyAssertionValidator : collection) {
                this.validators.add(policyAssertionValidator);
            }
        }
        if (this.validators.size() == 0) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0076_NO_SERVICE_PROVIDERS_FOUND(PolicyAssertionValidator.class.getName())));
        }
    }

    public static AssertionValidationProcessor getInstance() throws PolicyException {
        return new AssertionValidationProcessor();
    }

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion policyAssertion) throws PolicyException {
        PolicyAssertionValidator policyAssertionValidator;
        PolicyAssertionValidator.Fitness fitness = PolicyAssertionValidator.Fitness.UNKNOWN;
        Iterator<PolicyAssertionValidator> iterator = this.validators.iterator();
        while (iterator.hasNext() && (fitness = fitness.combine((policyAssertionValidator = iterator.next()).validateClientSide(policyAssertion))) != PolicyAssertionValidator.Fitness.SUPPORTED) {
        }
        return fitness;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion policyAssertion) throws PolicyException {
        PolicyAssertionValidator policyAssertionValidator;
        PolicyAssertionValidator.Fitness fitness = PolicyAssertionValidator.Fitness.UNKNOWN;
        Iterator<PolicyAssertionValidator> iterator = this.validators.iterator();
        while (iterator.hasNext() && (fitness = fitness.combine((policyAssertionValidator = iterator.next()).validateServerSide(policyAssertion))) != PolicyAssertionValidator.Fitness.SUPPORTED) {
        }
        return fitness;
    }
}

