/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.encoding.ContentType;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.StreamSOAPCodec;
import com.sun.xml.internal.ws.message.stream.StreamHeader;
import com.sun.xml.internal.ws.message.stream.StreamHeader12;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

final class StreamSOAP12Codec
extends StreamSOAPCodec {
    public static final String SOAP12_MIME_TYPE = "application/soap+xml";
    public static final String SOAP12_CONTENT_TYPE = "application/soap+xml; charset=utf-8";
    private static final List<String> expectedContentTypes = Collections.singletonList("application/soap+xml");
    public static final ContentTypeImpl defaultContentType = new ContentTypeImpl("application/soap+xml; charset=utf-8");

    StreamSOAP12Codec() {
        super(SOAPVersion.SOAP_12);
    }

    @Override
    public String getMimeType() {
        return SOAP12_MIME_TYPE;
    }

    @Override
    protected final StreamHeader createHeader(XMLStreamReader xMLStreamReader, XMLStreamBuffer xMLStreamBuffer) {
        return new StreamHeader12(xMLStreamReader, xMLStreamBuffer);
    }

    @Override
    protected com.sun.xml.internal.ws.api.pipe.ContentType getContentType(String string) {
        if (string == null) {
            return defaultContentType;
        }
        return new ContentTypeImpl("application/soap+xml; charset=utf-8;action=" + this.fixQuotesAroundSoapAction(string));
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet, AttachmentSet attachmentSet) throws IOException {
        ContentType contentType = new ContentType(string);
        packet.soapAction = this.fixQuotesAroundSoapAction(contentType.getParameter("action"));
        super.decode(inputStream, string, packet, attachmentSet);
    }

    private String fixQuotesAroundSoapAction(String string) {
        if (!(string == null || string.startsWith("\"") && string.endsWith("\""))) {
            String string2 = string;
            if (!string.startsWith("\"")) {
                string2 = "\"" + string2;
            }
            if (!string.endsWith("\"")) {
                string2 = string2 + "\"";
            }
            return string2;
        }
        return string;
    }

    @Override
    protected List<String> getExpectedContentTypes() {
        return expectedContentTypes;
    }
}

