/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.handler.HandlerChainsModel;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.HandlerAnnotationProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPBinding;

abstract class HandlerConfigurator {
    HandlerConfigurator() {
    }

    abstract void configureHandlers(@NotNull WSPortInfo var1, @NotNull BindingImpl var2);

    abstract HandlerResolver getResolver();

    static final class AnnotationConfigurator
    extends HandlerConfigurator {
        private final HandlerChainsModel handlerModel;
        private final Map<WSPortInfo, HandlerAnnotationInfo> chainMap = new HashMap<WSPortInfo, HandlerAnnotationInfo>();
        private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.handler");

        AnnotationConfigurator(WSServiceDelegate wSServiceDelegate) {
            this.handlerModel = HandlerAnnotationProcessor.buildHandlerChainsModel(wSServiceDelegate.getServiceClass());
            assert (this.handlerModel != null);
        }

        @Override
        void configureHandlers(WSPortInfo wSPortInfo, BindingImpl bindingImpl) {
            HandlerAnnotationInfo handlerAnnotationInfo = this.chainMap.get(wSPortInfo);
            if (handlerAnnotationInfo == null) {
                this.logGetChain(wSPortInfo);
                handlerAnnotationInfo = this.handlerModel.getHandlersForPortInfo(wSPortInfo);
                this.chainMap.put(wSPortInfo, handlerAnnotationInfo);
            }
            if (bindingImpl instanceof SOAPBinding) {
                ((SOAPBinding)((Object)bindingImpl)).setRoles(handlerAnnotationInfo.getRoles());
            }
            this.logSetChain(wSPortInfo, handlerAnnotationInfo);
            bindingImpl.setHandlerChain(handlerAnnotationInfo.getHandlers());
        }

        @Override
        HandlerResolver getResolver() {
            return new HandlerResolver(){

                @Override
                public List<Handler> getHandlerChain(PortInfo portInfo) {
                    return new ArrayList<Handler>(AnnotationConfigurator.this.handlerModel.getHandlersForPortInfo(portInfo).getHandlers());
                }
            };
        }

        private void logSetChain(WSPortInfo wSPortInfo, HandlerAnnotationInfo handlerAnnotationInfo) {
            logger.finer("Setting chain of length " + handlerAnnotationInfo.getHandlers().size() + " for port info");
            this.logPortInfo(wSPortInfo, Level.FINER);
        }

        private void logGetChain(WSPortInfo wSPortInfo) {
            logger.fine("No handler chain found for port info:");
            this.logPortInfo(wSPortInfo, Level.FINE);
            logger.fine("Existing handler chains:");
            if (this.chainMap.isEmpty()) {
                logger.fine("none");
            } else {
                for (WSPortInfo wSPortInfo2 : this.chainMap.keySet()) {
                    logger.fine(this.chainMap.get(wSPortInfo2).getHandlers().size() + " handlers for port info ");
                    this.logPortInfo(wSPortInfo2, Level.FINE);
                }
            }
        }

        private void logPortInfo(WSPortInfo wSPortInfo, Level level) {
            logger.log(level, "binding: " + wSPortInfo.getBindingID() + "\nservice: " + wSPortInfo.getServiceName() + "\nport: " + wSPortInfo.getPortName());
        }
    }

    static final class HandlerResolverImpl
    extends HandlerConfigurator {
        @Nullable
        private final HandlerResolver resolver;

        public HandlerResolverImpl(HandlerResolver handlerResolver) {
            this.resolver = handlerResolver;
        }

        @Override
        void configureHandlers(@NotNull WSPortInfo wSPortInfo, @NotNull BindingImpl bindingImpl) {
            if (this.resolver != null) {
                bindingImpl.setHandlerChain(this.resolver.getHandlerChain(wSPortInfo));
            }
        }

        @Override
        HandlerResolver getResolver() {
            return this.resolver;
        }
    }
}

