/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.W3CWsaServerTube;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionWsaServerTube;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.api.server.ServerPipelineHook;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.developer.SchemaValidationFeature;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.ServerLogicalHandlerTube;
import com.sun.xml.internal.ws.handler.ServerMessageHandlerTube;
import com.sun.xml.internal.ws.handler.ServerSOAPHandlerTube;
import com.sun.xml.internal.ws.protocol.soap.ServerMUTube;
import com.sun.xml.internal.ws.server.ServerSchemaValidationTube;
import com.sun.xml.internal.ws.util.pipe.DumpTube;
import java.io.PrintStream;
import javax.xml.ws.soap.SOAPBinding;

public class ServerTubeAssemblerContext {
    private final SEIModel seiModel;
    private final WSDLPort wsdlModel;
    private final WSEndpoint endpoint;
    private final BindingImpl binding;
    private final Tube terminal;
    private final boolean isSynchronous;
    @NotNull
    private Codec codec;

    public ServerTubeAssemblerContext(@Nullable SEIModel sEIModel, @Nullable WSDLPort wSDLPort, @NotNull WSEndpoint wSEndpoint, @NotNull Tube tube, boolean bl) {
        this.seiModel = sEIModel;
        this.wsdlModel = wSDLPort;
        this.endpoint = wSEndpoint;
        this.terminal = tube;
        this.binding = (BindingImpl)wSEndpoint.getBinding();
        this.isSynchronous = bl;
        this.codec = this.binding.createCodec();
    }

    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Nullable
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @NotNull
    public WSEndpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public Tube getTerminalTube() {
        return this.terminal;
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    @NotNull
    public Tube createServerMUTube(@NotNull Tube tube) {
        if (this.binding instanceof SOAPBinding) {
            return new ServerMUTube(this, tube);
        }
        return tube;
    }

    @NotNull
    public Tube createHandlerTube(@NotNull Tube tube) {
        if (!this.binding.getHandlerChain().isEmpty()) {
            HandlerTube handlerTube = new ServerLogicalHandlerTube((WSBinding)this.binding, this.seiModel, this.wsdlModel, tube);
            tube = handlerTube;
            if (this.binding instanceof SOAPBinding) {
                handlerTube = new ServerSOAPHandlerTube((WSBinding)this.binding, tube, handlerTube);
                tube = handlerTube;
                tube = new ServerMessageHandlerTube(this.seiModel, this.binding, tube, handlerTube);
            }
        }
        return tube;
    }

    @NotNull
    public Tube createMonitoringTube(@NotNull Tube tube) {
        ServerPipelineHook serverPipelineHook = this.endpoint.getContainer().getSPI(ServerPipelineHook.class);
        if (serverPipelineHook != null) {
            ServerPipeAssemblerContext serverPipeAssemblerContext = new ServerPipeAssemblerContext(this.seiModel, this.wsdlModel, this.endpoint, this.terminal, this.isSynchronous);
            return PipeAdapter.adapt(serverPipelineHook.createMonitoringPipe(serverPipeAssemblerContext, PipeAdapter.adapt(tube)));
        }
        return tube;
    }

    @NotNull
    public Tube createSecurityTube(@NotNull Tube tube) {
        ServerPipelineHook serverPipelineHook = this.endpoint.getContainer().getSPI(ServerPipelineHook.class);
        if (serverPipelineHook != null) {
            ServerPipeAssemblerContext serverPipeAssemblerContext = new ServerPipeAssemblerContext(this.seiModel, this.wsdlModel, this.endpoint, this.terminal, this.isSynchronous);
            return PipeAdapter.adapt(serverPipelineHook.createSecurityPipe(serverPipeAssemblerContext, PipeAdapter.adapt(tube)));
        }
        return tube;
    }

    public Tube createDumpTube(String string, PrintStream printStream, Tube tube) {
        return new DumpTube(string, printStream, tube);
    }

    public Tube createValidationTube(Tube tube) {
        if (this.binding instanceof SOAPBinding && this.binding.isFeatureEnabled(SchemaValidationFeature.class) && this.wsdlModel != null) {
            return new ServerSchemaValidationTube(this.endpoint, this.binding, this.seiModel, this.wsdlModel, tube);
        }
        return tube;
    }

    public Tube createWsaTube(Tube tube) {
        if (this.binding instanceof SOAPBinding && AddressingVersion.isEnabled(this.binding)) {
            if (AddressingVersion.fromBinding(this.binding) == AddressingVersion.MEMBER) {
                return new MemberSubmissionWsaServerTube(this.endpoint, this.wsdlModel, this.binding, tube);
            }
            return new W3CWsaServerTube(this.endpoint, this.wsdlModel, this.binding, tube);
        }
        return tube;
    }

    @NotNull
    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(@NotNull Codec codec) {
        this.codec = codec;
    }
}

