/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.config.management.policy;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.config.management.policy.ManagementAssertion;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.spi.AssertionCreationException;
import com.sun.xml.internal.ws.resources.ManagementMessages;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class ManagedServiceAssertion
extends ManagementAssertion {
    public static final QName MANAGED_SERVICE_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ManagedService");
    private static final QName COMMUNICATION_SERVER_IMPLEMENTATIONS_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "CommunicationServerImplementations");
    private static final QName COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "CommunicationServerImplementation");
    private static final QName CONFIGURATOR_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ConfiguratorImplementation");
    private static final QName CONFIG_SAVER_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ConfigSaverImplementation");
    private static final QName CONFIG_READER_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ConfigReaderImplementation");
    private static final QName CLASS_NAME_ATTRIBUTE_QNAME = new QName("className");
    private static final QName ENDPOINT_DISPOSE_DELAY_ATTRIBUTE_QNAME = new QName("endpointDisposeDelay");
    private static final Logger LOGGER = Logger.getLogger(ManagedServiceAssertion.class);

    public static ManagedServiceAssertion getAssertion(WSEndpoint wSEndpoint) throws WebServiceException {
        LOGGER.entering(wSEndpoint);
        PolicyMap policyMap = wSEndpoint.getPolicyMap();
        ManagedServiceAssertion managedServiceAssertion = ManagementAssertion.getAssertion(MANAGED_SERVICE_QNAME, policyMap, wSEndpoint.getServiceName(), wSEndpoint.getPortName(), ManagedServiceAssertion.class);
        LOGGER.exiting(managedServiceAssertion);
        return managedServiceAssertion;
    }

    public ManagedServiceAssertion(AssertionData assertionData, Collection<PolicyAssertion> collection) throws AssertionCreationException {
        super(MANAGED_SERVICE_QNAME, assertionData, collection);
    }

    @Override
    public boolean isManagementEnabled() {
        String string = this.getAttributeValue(MANAGEMENT_ATTRIBUTE_QNAME);
        boolean bl = true;
        if (string != null) {
            bl = string.trim().toLowerCase().equals("on") ? true : Boolean.parseBoolean(string);
        }
        return bl;
    }

    public long getEndpointDisposeDelay(long l) throws WebServiceException {
        long l2 = l;
        String string = this.getAttributeValue(ENDPOINT_DISPOSE_DELAY_ATTRIBUTE_QNAME);
        if (string != null) {
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_1008_EXPECTED_INTEGER_DISPOSE_DELAY_VALUE(string), numberFormatException));
            }
        }
        return l2;
    }

    public Collection<ImplementationRecord> getCommunicationServerImplementations() {
        LinkedList<ImplementationRecord> linkedList = new LinkedList<ImplementationRecord>();
        Iterator<PolicyAssertion> iterator = this.getParametersIterator();
        while (iterator.hasNext()) {
            PolicyAssertion policyAssertion = iterator.next();
            if (!COMMUNICATION_SERVER_IMPLEMENTATIONS_PARAMETER_QNAME.equals(policyAssertion.getName())) continue;
            Iterator<PolicyAssertion> iterator2 = policyAssertion.getParametersIterator();
            if (!iterator2.hasNext()) {
                throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_1005_EXPECTED_COMMUNICATION_CHILD()));
            }
            while (iterator2.hasNext()) {
                PolicyAssertion policyAssertion2 = iterator2.next();
                if (COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME.equals(policyAssertion2.getName())) {
                    linkedList.add(this.getImplementation(policyAssertion2));
                    continue;
                }
                throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_1004_EXPECTED_XML_TAG(COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME, policyAssertion2.getName())));
            }
        }
        return linkedList;
    }

    public ImplementationRecord getConfiguratorImplementation() {
        return this.findImplementation(CONFIGURATOR_IMPLEMENTATION_PARAMETER_QNAME);
    }

    public ImplementationRecord getConfigSaverImplementation() {
        return this.findImplementation(CONFIG_SAVER_IMPLEMENTATION_PARAMETER_QNAME);
    }

    public ImplementationRecord getConfigReaderImplementation() {
        return this.findImplementation(CONFIG_READER_IMPLEMENTATION_PARAMETER_QNAME);
    }

    private ImplementationRecord findImplementation(QName qName) {
        Iterator<PolicyAssertion> iterator = this.getParametersIterator();
        while (iterator.hasNext()) {
            PolicyAssertion policyAssertion = iterator.next();
            if (!qName.equals(policyAssertion.getName())) continue;
            return this.getImplementation(policyAssertion);
        }
        return null;
    }

    private ImplementationRecord getImplementation(PolicyAssertion policyAssertion) {
        String string = policyAssertion.getAttributeValue(CLASS_NAME_ATTRIBUTE_QNAME);
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        Iterator<PolicyAssertion> iterator = policyAssertion.getParametersIterator();
        LinkedList<NestedParameters> linkedList = new LinkedList<NestedParameters>();
        while (iterator.hasNext()) {
            Object object;
            PolicyAssertion policyAssertion2 = iterator.next();
            QName qName = policyAssertion2.getName();
            if (policyAssertion2.hasParameters()) {
                object = new HashMap();
                Iterator<PolicyAssertion> iterator2 = policyAssertion2.getParametersIterator();
                while (iterator2.hasNext()) {
                    PolicyAssertion policyAssertion3 = iterator2.next();
                    String string2 = policyAssertion3.getValue();
                    if (string2 != null) {
                        string2 = string2.trim();
                    }
                    object.put(policyAssertion3.getName(), string2);
                }
                linkedList.add(new NestedParameters(qName, (Map)object));
                continue;
            }
            object = policyAssertion2.getValue();
            if (object != null) {
                object = ((String)object).trim();
            }
            hashMap.put(qName, (String)object);
        }
        return new ImplementationRecord(string, hashMap, linkedList);
    }

    public static class ImplementationRecord {
        private final String implementation;
        private final Map<QName, String> parameters;
        private final Collection<NestedParameters> nestedParameters;

        protected ImplementationRecord(String string, Map<QName, String> map, Collection<NestedParameters> collection) {
            this.implementation = string;
            this.parameters = map;
            this.nestedParameters = collection;
        }

        public String getImplementation() {
            return this.implementation;
        }

        public Map<QName, String> getParameters() {
            return this.parameters;
        }

        public Collection<NestedParameters> getNestedParameters() {
            return this.nestedParameters;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ImplementationRecord implementationRecord = (ImplementationRecord)object;
            if (this.implementation == null ? implementationRecord.implementation != null : !this.implementation.equals(implementationRecord.implementation)) {
                return false;
            }
            if (!(this.parameters == implementationRecord.parameters || this.parameters != null && this.parameters.equals(implementationRecord.parameters))) {
                return false;
            }
            return this.nestedParameters == implementationRecord.nestedParameters || this.nestedParameters != null && this.nestedParameters.equals(implementationRecord.nestedParameters);
        }

        public int hashCode() {
            int n = 3;
            n = 53 * n + (this.implementation != null ? this.implementation.hashCode() : 0);
            n = 53 * n + (this.parameters != null ? this.parameters.hashCode() : 0);
            n = 53 * n + (this.nestedParameters != null ? this.nestedParameters.hashCode() : 0);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ImplementationRecord: ");
            stringBuilder.append("implementation = \"").append(this.implementation).append("\", ");
            stringBuilder.append("parameters = \"").append(this.parameters).append("\", ");
            stringBuilder.append("nested parameters = \"").append(this.nestedParameters).append("\"");
            return stringBuilder.toString();
        }
    }

    public static class NestedParameters {
        private final QName name;
        private final Map<QName, String> parameters;

        private NestedParameters(QName qName, Map<QName, String> map) {
            this.name = qName;
            this.parameters = map;
        }

        public QName getName() {
            return this.name;
        }

        public Map<QName, String> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NestedParameters nestedParameters = (NestedParameters)object;
            if (this.name == null ? nestedParameters.name != null : !this.name.equals(nestedParameters.name)) {
                return false;
            }
            return this.parameters == nestedParameters.parameters || this.parameters != null && this.parameters.equals(nestedParameters.parameters);
        }

        public int hashCode() {
            int n = 5;
            n = 59 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 59 * n + (this.parameters != null ? this.parameters.hashCode() : 0);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("NestedParameters: ");
            stringBuilder.append("name = \"").append(this.name).append("\", ");
            stringBuilder.append("parameters = \"").append(this.parameters).append("\"");
            return stringBuilder.toString();
        }
    }
}

