/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.impl;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementFactory;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.HeaderElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.w3c.dom.Element;

public abstract class HeaderImpl
extends ElementImpl
implements SOAPHeader {
    protected static final boolean MUST_UNDERSTAND_ONLY = false;

    protected HeaderImpl(SOAPDocumentImpl sOAPDocumentImpl, NameImpl nameImpl) {
        super(sOAPDocumentImpl, nameImpl);
    }

    protected abstract SOAPHeaderElement createHeaderElement(Name var1) throws SOAPException;

    protected abstract SOAPHeaderElement createHeaderElement(QName var1) throws SOAPException;

    protected abstract NameImpl getNotUnderstoodName();

    protected abstract NameImpl getUpgradeName();

    protected abstract NameImpl getSupportedEnvelopeName();

    @Override
    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        String string;
        SOAPElement sOAPElement = ElementFactory.createNamedElement(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), name.getLocalName(), name.getPrefix(), name.getURI());
        if (sOAPElement == null || !(sOAPElement instanceof SOAPHeaderElement)) {
            sOAPElement = this.createHeaderElement(name);
        }
        if ((string = sOAPElement.getElementQName().getNamespaceURI()) == null || "".equals(string)) {
            log.severe("SAAJ0131.impl.header.elems.ns.qualified");
            throw new SOAPExceptionImpl("HeaderElements must be namespace qualified");
        }
        this.addNode(sOAPElement);
        return (SOAPHeaderElement)sOAPElement;
    }

    @Override
    public SOAPHeaderElement addHeaderElement(QName qName) throws SOAPException {
        String string;
        SOAPElement sOAPElement = ElementFactory.createNamedElement(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        if (sOAPElement == null || !(sOAPElement instanceof SOAPHeaderElement)) {
            sOAPElement = this.createHeaderElement(qName);
        }
        if ((string = sOAPElement.getElementQName().getNamespaceURI()) == null || "".equals(string)) {
            log.severe("SAAJ0131.impl.header.elems.ns.qualified");
            throw new SOAPExceptionImpl("HeaderElements must be namespace qualified");
        }
        this.addNode(sOAPElement);
        return (SOAPHeaderElement)sOAPElement;
    }

    @Override
    protected SOAPElement addElement(Name name) throws SOAPException {
        return this.addHeaderElement(name);
    }

    @Override
    protected SOAPElement addElement(QName qName) throws SOAPException {
        return this.addHeaderElement(qName);
    }

    @Override
    public Iterator examineHeaderElements(String string) {
        return this.getHeaderElementsForActor(string, false, false);
    }

    @Override
    public Iterator extractHeaderElements(String string) {
        return this.getHeaderElementsForActor(string, true, false);
    }

    protected Iterator getHeaderElementsForActor(String string, boolean bl, boolean bl2) {
        if (string == null || string.equals("")) {
            log.severe("SAAJ0132.impl.invalid.value.for.actor.or.role");
            throw new IllegalArgumentException("Invalid value for actor or role");
        }
        return this.getHeaderElements(string, bl, bl2);
    }

    protected Iterator getHeaderElements(String string, boolean bl, boolean bl2) {
        ArrayList<HeaderElementImpl> arrayList = new ArrayList<HeaderElementImpl>();
        Iterator iterator = this.getChildElements();
        Object object = this.iterate(iterator);
        while (object != null) {
            if (!(object instanceof SOAPHeaderElement)) {
                object = this.iterate(iterator);
                continue;
            }
            HeaderElementImpl headerElementImpl = (HeaderElementImpl)object;
            object = this.iterate(iterator);
            boolean bl3 = !bl2 || headerElementImpl.getMustUnderstand();
            boolean bl4 = false;
            if (string == null && bl3) {
                bl4 = true;
            } else {
                String string2 = headerElementImpl.getActorOrRole();
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.equalsIgnoreCase(string) && bl3) {
                    bl4 = true;
                }
            }
            if (!bl4) continue;
            arrayList.add(headerElementImpl);
            if (!bl) continue;
            headerElementImpl.detachNode();
        }
        return arrayList.listIterator();
    }

    private Object iterate(Iterator iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (!(sOAPElement instanceof SOAPEnvelope)) {
            log.severe("SAAJ0133.impl.header.parent.mustbe.envelope");
            throw new SOAPException("Parent of SOAPHeader has to be a SOAPEnvelope");
        }
        super.setParentElement(sOAPElement);
    }

    @Override
    public SOAPElement addChildElement(String string) throws SOAPException {
        SOAPElement sOAPElement = super.addChildElement(string);
        String string2 = sOAPElement.getElementName().getURI();
        if (string2 == null || "".equals(string2)) {
            log.severe("SAAJ0134.impl.header.elems.ns.qualified");
            throw new SOAPExceptionImpl("HeaderElements must be namespace qualified");
        }
        return sOAPElement;
    }

    @Override
    public Iterator examineAllHeaderElements() {
        return this.getHeaderElements(null, false, false);
    }

    @Override
    public Iterator examineMustUnderstandHeaderElements(String string) {
        return this.getHeaderElements(string, false, true);
    }

    @Override
    public Iterator extractAllHeaderElements() {
        return this.getHeaderElements(null, true, false);
    }

    @Override
    public SOAPHeaderElement addUpgradeHeaderElement(Iterator iterator) throws SOAPException {
        if (iterator == null) {
            log.severe("SAAJ0411.ver1_2.no.null.supportedURIs");
            throw new SOAPException("Argument cannot be null; iterator of supportedURIs cannot be null");
        }
        if (!iterator.hasNext()) {
            log.severe("SAAJ0412.ver1_2.no.empty.list.of.supportedURIs");
            throw new SOAPException("List of supported URIs cannot be empty");
        }
        NameImpl nameImpl = this.getUpgradeName();
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.addChildElement(nameImpl);
        NameImpl nameImpl2 = this.getSupportedEnvelopeName();
        int n = 0;
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = sOAPHeaderElement.addChildElement(nameImpl2);
            String string = "ns" + Integer.toString(n);
            sOAPElement.addAttribute(NameImpl.createFromUnqualifiedName("qname"), string + ":Envelope");
            sOAPElement.addNamespaceDeclaration(string, (String)iterator.next());
            ++n;
        }
        return sOAPHeaderElement;
    }

    @Override
    public SOAPHeaderElement addUpgradeHeaderElement(String string) throws SOAPException {
        return this.addUpgradeHeaderElement(new String[]{string});
    }

    @Override
    public SOAPHeaderElement addUpgradeHeaderElement(String[] stringArray) throws SOAPException {
        if (stringArray == null) {
            log.severe("SAAJ0411.ver1_2.no.null.supportedURIs");
            throw new SOAPException("Argument cannot be null; array of supportedURIs cannot be null");
        }
        if (stringArray.length == 0) {
            log.severe("SAAJ0412.ver1_2.no.empty.list.of.supportedURIs");
            throw new SOAPException("List of supported URIs cannot be empty");
        }
        NameImpl nameImpl = this.getUpgradeName();
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.addChildElement(nameImpl);
        NameImpl nameImpl2 = this.getSupportedEnvelopeName();
        for (int i = 0; i < stringArray.length; ++i) {
            SOAPElement sOAPElement = sOAPHeaderElement.addChildElement(nameImpl2);
            String string = "ns" + Integer.toString(i);
            sOAPElement.addAttribute(NameImpl.createFromUnqualifiedName("qname"), string + ":Envelope");
            sOAPElement.addNamespaceDeclaration(string, stringArray[i]);
        }
        return sOAPHeaderElement;
    }

    @Override
    protected SOAPElement convertToSoapElement(Element element) {
        SOAPHeaderElement sOAPHeaderElement;
        if (element instanceof SOAPHeaderElement) {
            return (SOAPElement)element;
        }
        try {
            sOAPHeaderElement = this.createHeaderElement(NameImpl.copyElementName(element));
        }
        catch (SOAPException sOAPException) {
            throw new ClassCastException("Could not convert Element to SOAPHeaderElement: " + sOAPException.getMessage());
        }
        return HeaderImpl.replaceElementWithSOAPElement(element, (ElementImpl)((Object)sOAPHeaderElement));
    }

    @Override
    public SOAPElement setElementQName(QName qName) throws SOAPException {
        log.log(Level.SEVERE, "SAAJ0146.impl.invalid.name.change.requested", new Object[]{this.elementQName.getLocalPart(), qName.getLocalPart()});
        throw new SOAPException("Cannot change name for " + this.elementQName.getLocalPart() + " to " + qName.getLocalPart());
    }
}

