/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.datatype;

import com.sun.org.apache.xerces.internal.jaxp.datatype.DurationImpl;
import java.math.BigDecimal;
import java.math.BigInteger;

class DurationDayTimeImpl
extends DurationImpl {
    public DurationDayTimeImpl(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigDecimal bigDecimal) {
        super(bl, null, null, bigInteger, bigInteger2, bigInteger3, bigDecimal);
        this.convertToCanonicalDayTime();
    }

    public DurationDayTimeImpl(boolean bl, int n, int n2, int n3, int n4) {
        this(bl, DurationDayTimeImpl.wrap(n), DurationDayTimeImpl.wrap(n2), DurationDayTimeImpl.wrap(n3), n4 != Integer.MIN_VALUE ? new BigDecimal(String.valueOf(n4)) : null);
    }

    protected DurationDayTimeImpl(String string) {
        super(string);
        if (this.getYears() > 0 || this.getMonths() > 0) {
            throw new IllegalArgumentException("Trying to create an xdt:dayTimeDuration with an invalid lexical representation of \"" + string + "\", data model requires a format PnDTnHnMnS.");
        }
        this.convertToCanonicalDayTime();
    }

    protected DurationDayTimeImpl(long l) {
        super(l);
        this.convertToCanonicalDayTime();
        this.years = null;
        this.months = null;
    }

    public float getValue() {
        float f = this.seconds == null ? 0.0f : this.seconds.floatValue();
        return (float)(((this.getDays() * 24 + this.getHours()) * 60 + this.getMinutes()) * 60) + f;
    }

    private void convertToCanonicalDayTime() {
        while (this.getSeconds() >= 60) {
            this.seconds = this.seconds.subtract(BigDecimal.valueOf(60L));
            this.minutes = BigInteger.valueOf(this.getMinutes()).add(BigInteger.ONE);
        }
        while (this.getMinutes() >= 60) {
            this.minutes = this.minutes.subtract(BigInteger.valueOf(60L));
            this.hours = BigInteger.valueOf(this.getHours()).add(BigInteger.ONE);
        }
        while (this.getHours() >= 24) {
            this.hours = this.hours.subtract(BigInteger.valueOf(24L));
            this.days = BigInteger.valueOf(this.getDays()).add(BigInteger.ONE);
        }
    }
}

