/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.internal;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpBadSecurityLevelException;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpEngineFactory;
import com.sun.jmx.snmp.SnmpEngineId;
import com.sun.jmx.snmp.SnmpUsmKeyHandler;
import com.sun.jmx.snmp.internal.SnmpAccessControlSubSystem;
import com.sun.jmx.snmp.internal.SnmpLcd;
import com.sun.jmx.snmp.internal.SnmpMsgProcessingSubSystem;
import com.sun.jmx.snmp.internal.SnmpSecuritySubSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class SnmpEngineImpl
implements SnmpEngine,
Serializable {
    private static final long serialVersionUID = -2564301391365614725L;
    public static final int noAuthNoPriv = 0;
    public static final int authNoPriv = 1;
    public static final int authPriv = 3;
    public static final int reportableFlag = 4;
    public static final int authMask = 1;
    public static final int privMask = 2;
    public static final int authPrivMask = 3;
    private SnmpEngineId engineid = null;
    private SnmpEngineFactory factory = null;
    private long startTime = 0L;
    private int boot = 0;
    private boolean checkOid = false;
    private transient SnmpUsmKeyHandler usmKeyHandler = null;
    private transient SnmpLcd lcd = null;
    private transient SnmpSecuritySubSystem securitySub = null;
    private transient SnmpMsgProcessingSubSystem messageSub = null;
    private transient SnmpAccessControlSubSystem accessSub = null;

    @Override
    public synchronized int getEngineTime() {
        long l = System.currentTimeMillis() / 1000L - this.startTime;
        if (l > Integer.MAX_VALUE) {
            this.startTime = System.currentTimeMillis() / 1000L;
            if (this.boot != Integer.MAX_VALUE) {
                ++this.boot;
            }
            this.storeNBBoots(this.boot);
        }
        return (int)(System.currentTimeMillis() / 1000L - this.startTime);
    }

    @Override
    public SnmpEngineId getEngineId() {
        return this.engineid;
    }

    @Override
    public SnmpUsmKeyHandler getUsmKeyHandler() {
        return this.usmKeyHandler;
    }

    public SnmpLcd getLcd() {
        return this.lcd;
    }

    @Override
    public int getEngineBoots() {
        return this.boot;
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd, SnmpEngineId snmpEngineId) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = snmpEngineId != null ? snmpEngineId : SnmpEngineId.createEngineId();
        }
        snmpLcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd,SnmpEngineId)", "LOCAL ENGINE ID: " + this.engineid);
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd, InetAddress inetAddress, int n) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId(inetAddress, n);
        }
        snmpLcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd,InetAddress,int)", "LOCAL ENGINE ID: " + this.engineid + " / " + "LOCAL ENGINE NB BOOTS: " + this.boot + " / " + "LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd, int n) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId(n);
        }
        snmpLcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd,int)", "LOCAL ENGINE ID: " + this.engineid + " / " + "LOCAL ENGINE NB BOOTS: " + this.boot + " / " + "LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId();
        }
        snmpLcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd)", "LOCAL ENGINE ID: " + this.engineid + " / " + "LOCAL ENGINE NB BOOTS: " + this.boot + " / " + "LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public synchronized void activateCheckOid() {
        this.checkOid = true;
    }

    public synchronized void deactivateCheckOid() {
        this.checkOid = false;
    }

    public synchronized boolean isCheckOidActivated() {
        return this.checkOid;
    }

    private void storeNBBoots(int n) {
        if (n < 0 || n == Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
            this.lcd.storeEngineBoots(n);
        } else {
            this.lcd.storeEngineBoots(n + 1);
        }
    }

    private void init(SnmpLcd snmpLcd, SnmpEngineFactory snmpEngineFactory) {
        this.factory = snmpEngineFactory;
        this.lcd = snmpLcd;
        this.boot = snmpLcd.getEngineBoots();
        if (this.boot == -1 || this.boot == 0) {
            this.boot = 1;
        }
        this.storeNBBoots(this.boot);
        this.startTime = System.currentTimeMillis() / 1000L;
    }

    void setUsmKeyHandler(SnmpUsmKeyHandler snmpUsmKeyHandler) {
        this.usmKeyHandler = snmpUsmKeyHandler;
    }

    private void initEngineID() throws UnknownHostException {
        String string = this.lcd.getEngineId();
        if (string != null) {
            this.engineid = SnmpEngineId.createEngineId(string);
        }
    }

    public SnmpMsgProcessingSubSystem getMsgProcessingSubSystem() {
        return this.messageSub;
    }

    public void setMsgProcessingSubSystem(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem) {
        this.messageSub = snmpMsgProcessingSubSystem;
    }

    public SnmpSecuritySubSystem getSecuritySubSystem() {
        return this.securitySub;
    }

    public void setSecuritySubSystem(SnmpSecuritySubSystem snmpSecuritySubSystem) {
        this.securitySub = snmpSecuritySubSystem;
    }

    public void setAccessControlSubSystem(SnmpAccessControlSubSystem snmpAccessControlSubSystem) {
        this.accessSub = snmpAccessControlSubSystem;
    }

    public SnmpAccessControlSubSystem getAccessControlSubSystem() {
        return this.accessSub;
    }

    public static void checkSecurityLevel(byte by) throws SnmpBadSecurityLevelException {
        int n = by & 3;
        if ((n & 2) != 0 && (n & 1) == 0) {
            throw new SnmpBadSecurityLevelException("Security level: noAuthPriv!!!");
        }
    }
}

