/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ReaderThread;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.Work;

public class ReaderThreadImpl
implements ReaderThread,
Work {
    private ORB orb;
    private Connection connection;
    private Selector selector;
    private boolean keepRunning;
    private long enqueueTime;

    public ReaderThreadImpl(ORB oRB, Connection connection, Selector selector) {
        this.orb = oRB;
        this.connection = connection;
        this.selector = selector;
        this.keepRunning = true;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.connection);
        }
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Start ReaderThread: " + this.connection);
            }
            while (this.keepRunning) {
                block12: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: Start ReaderThread cycle: " + this.connection);
                    }
                    if (!this.connection.read()) break block12;
                    return;
                }
                try {
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint(".doWork: End ReaderThread cycle: " + this.connection);
                }
                catch (Throwable throwable) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: exception in read: " + this.connection, throwable);
                    }
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
                    this.getConnection().close();
                }
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
            }
        }
    }

    @Override
    public void setEnqueueTime(long l) {
        this.enqueueTime = l;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public String getName() {
        return "ReaderThread";
    }

    private void dprint(String string) {
        ORBUtility.dprint("ReaderThreadImpl", string);
    }

    protected void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }
}

