/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class SSV3Dialog {
    private static final boolean UNDECORATED = false;
    private static final int MAX_PROMPT_WIDTH = 400;
    private static final int MAX_URL_WIDTH = 280;
    private Object owner;
    private AppInfo ainfo;
    private int messageType;
    private String title;
    private String masthead;
    private String mainText;
    private String location;
    private String prompt;
    private String multiPrompt;
    private String multiText;
    private String runText;
    private String updateText;
    private String cancelText;
    private String alwaysText;
    private URL updateURL;
    private int userAnswer;
    private JDialog dialog;
    private JCheckBox alwaysCheckbox;
    private JCheckBox multiClickCheckBox;
    private JButton runButton;
    private JButton updateButton;
    private JButton cancelButton;
    private static Font ssvSmallFont;
    private static Font ssvSmallBoldFont;
    private static Font ssvFont;
    private static Font ssvBoldFont;
    private static Font ssvBigFont;
    private static Font ssvBigBoldFont;

    public static int showSSV3Dialog(Object object, AppInfo appInfo, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, URL uRL) {
        SSV3Dialog.setSSVFonts();
        SSV3Dialog sSV3Dialog = new SSV3Dialog();
        sSV3Dialog.owner = object;
        sSV3Dialog.ainfo = appInfo;
        sSV3Dialog.title = string;
        sSV3Dialog.messageType = n;
        sSV3Dialog.masthead = string2;
        sSV3Dialog.mainText = string3;
        sSV3Dialog.location = string4;
        sSV3Dialog.prompt = string5;
        sSV3Dialog.multiPrompt = string6;
        sSV3Dialog.multiText = string7;
        sSV3Dialog.runText = string8;
        sSV3Dialog.updateText = string9;
        sSV3Dialog.cancelText = string10;
        sSV3Dialog.alwaysText = string11;
        sSV3Dialog.updateURL = uRL;
        sSV3Dialog.initComponents();
        sSV3Dialog.setVisible(true);
        int n2 = sSV3Dialog.getAnswer();
        return n2;
    }

    protected int getAnswer() {
        return this.userAnswer;
    }

    private SSV3Dialog() {
    }

    private void initComponents() {
        this.setupShadowPane();
        this.addMouseListener();
        JPanel jPanel = this.createContentPane();
        jPanel.add((Component)this.createMastHead(), "North");
        JComponent jComponent = this.createMainContent();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        jPanel.add((Component)jComponent, "Center");
        jPanel.add((Component)this.createOkCancelPanel(), "South");
        this.dialog.add((Component)jPanel, "Center");
        UIFactory.placeWindow(this.dialog);
        this.dialog.pack();
    }

    private void setupShadowPane() {
        this.createDialog();
        JPanel jPanel = DialogTemplate.createShadedContentBorderPanel(false);
        jPanel.setOpaque(false);
        this.dialog.setContentPane(jPanel);
        this.dialog.setResizable(false);
        this.dialog.setModal(true);
        this.dialog.setUndecorated(false);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLayout(new BorderLayout());
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SSV3Dialog.this.cancelAction();
            }
        };
        this.dialog.addWindowListener(windowAdapter);
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 24, 23, 15));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        return jPanel;
    }

    private JComponent createMastHead() {
        Component component = null;
        JLabel jLabel = new JLabel(this.masthead);
        jLabel.setFont(ssvBigBoldFont);
        jLabel.setOpaque(false);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        if (component != null) {
            box.add(component);
        }
        box.add(jLabel);
        return box;
    }

    private JComponent createMainContent() {
        JComponent jComponent = this.createWarningPanel();
        JEditorPane jEditorPane = this.createPrompt();
        Box box = Box.createVerticalBox();
        box.add(jComponent);
        box.add(jEditorPane);
        return box;
    }

    private JEditorPane createPrompt() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new PromptEditorKit());
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(this.html(this.prompt));
        jEditorPane.setPreferredSize(this.getPromptPreferredSize());
        jEditorPane.setEditable(false);
        jEditorPane.setFocusable(false);
        jEditorPane.setOpaque(false);
        return jEditorPane;
    }

    private String html(String string) {
        String string2 = string.replaceAll("(" + this.runText + ")|(" + this.updateText + ")|(" + this.cancelText + ")", "<b>$0</b>");
        return "<html><body>" + string2 + "</body></html>";
    }

    private Dimension getPromptPreferredSize() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setSize(400, Short.MAX_VALUE);
        jEditorPane.setText(this.prompt);
        Dimension dimension = jEditorPane.getPreferredSize();
        int n = 3;
        if (dimension.height > ssvSmallFont.getSize() + 4) {
            n += 3;
        }
        dimension.height += n;
        return dimension;
    }

    private JComponent createWarningPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createShieldIcon(), "West");
        Box box = Box.createVerticalBox();
        box.setOpaque(false);
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.mainText);
        jSmartTextArea.setFont(ssvBoldFont);
        jSmartTextArea.setLineWrap(true);
        jSmartTextArea.setWrapStyleWord(true);
        jSmartTextArea.setOpaque(false);
        jSmartTextArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        box.add(jSmartTextArea);
        box.add(this.createLocationPanel());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    private JComponent createShieldIcon() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        jLabel.setIcon(ResourceManager.getIcon("yellowShield48.image"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 20));
        Box box = Box.createVerticalBox();
        box.add(jLabel);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private JComponent createLocationPanel() {
        Box box = Box.createHorizontalBox();
        box.setOpaque(false);
        JLabel jLabel = new JLabel(this.location);
        jLabel.setOpaque(false);
        jLabel.setFont(ssvSmallBoldFont);
        String string = this.ainfo.getFrom().toExternalForm();
        JLabel jLabel2 = new JLabel(string);
        Dimension dimension = jLabel2.getPreferredSize();
        if (dimension.width > 280) {
            jLabel2.setToolTipText(string);
            URL uRL = this.ainfo.getFrom();
            String string2 = uRL.getHost() + "/";
            String string3 = uRL.getFile();
            int n = uRL.getFile().lastIndexOf("/");
            if (n >= 0) {
                string3 = string3.substring(n);
            }
            string2 = string2 + "..." + string3;
            jLabel2.setText(string2);
        }
        jLabel2.setPreferredSize(new Dimension(280, ssvSmallFont.getSize() + 3));
        jLabel2.putClientProperty("html.disable", Boolean.TRUE);
        jLabel2.setOpaque(false);
        box.add(Box.createRigidArea(new Dimension(16, 1)));
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(6, 1)));
        box.add(jLabel2);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JComponent createCloseIcon() {
        Box box = Box.createHorizontalBox();
        ImageIcon imageIcon = ResourceManager.getIcon("close_box_normal.image");
        JButton jButton = new JButton(imageIcon);
        jButton.setOpaque(false);
        jButton.setEnabled(true);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setPreferredSize(new Dimension(10, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSV3Dialog.this.cancelAction();
            }
        });
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        return box;
    }

    private JComponent createOkCancelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.runButton = this.makeButton(this.runText);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSV3Dialog.this.runAction();
            }
        });
        jPanel.add(this.runButton);
        this.runButton.requestFocusInWindow();
        if (this.updateText != null) {
            this.updateButton = this.makeButton(this.updateText);
            this.updateButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSV3Dialog.this.updateAction();
                }
            });
            jPanel.add(this.updateButton);
        }
        this.cancelButton = this.makeButton(this.cancelText);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSV3Dialog.this.cancelAction();
            }
        };
        this.cancelButton.addActionListener(abstractAction);
        this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.dialog.getRootPane().getActionMap().put("cancel", abstractAction);
        JButton[] jButtonArray = null;
        jButtonArray = this.updateButton == null ? new JButton[]{this.runButton, this.cancelButton} : new JButton[]{this.runButton, this.updateButton, this.cancelButton};
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel.add(this.cancelButton);
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        Box box = Box.createVerticalBox();
        this.createMultiSelection(box);
        box.add(jPanel);
        this.alwaysCheckbox = new JCheckBox();
        this.setupCheckbox(box, this.alwaysText, this.alwaysCheckbox);
        return box;
    }

    private void createMultiSelection(Box box) {
        if (this.multiPrompt != null && this.multiText != null) {
            this.runButton.setEnabled(false);
            JLabel jLabel = new JLabel(this.multiPrompt);
            jLabel.setOpaque(false);
            jLabel.setFont(ssvSmallBoldFont);
            Box box2 = Box.createHorizontalBox();
            box2.add(jLabel);
            box2.add(Box.createHorizontalGlue());
            box2.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            box.add(box2);
            this.multiClickCheckBox = new JCheckBox();
            this.setupCheckbox(box, this.multiText, this.multiClickCheckBox);
            this.multiClickCheckBox.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSV3Dialog.this.runButton.setEnabled(SSV3Dialog.this.multiClickCheckBox.isSelected());
                    if (SSV3Dialog.this.multiClickCheckBox.isSelected()) {
                        SSV3Dialog.this.runButton.requestFocusInWindow();
                    } else if (SSV3Dialog.this.updateButton != null) {
                        SSV3Dialog.this.updateButton.requestFocusInWindow();
                    } else if (SSV3Dialog.this.cancelButton != null) {
                        SSV3Dialog.this.cancelButton.requestFocusInWindow();
                    }
                }
            });
        }
    }

    private void setupCheckbox(Box box, String string, JCheckBox jCheckBox) {
        if (string != null) {
            jCheckBox.setOpaque(false);
            jCheckBox.setText(string);
            Box box2 = Box.createHorizontalBox();
            box2.add(jCheckBox);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
        }
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setOpaque(false);
        return jButton;
    }

    private void runAction() {
        this.userAnswer = this.alwaysCheckbox != null && this.alwaysCheckbox.isSelected() ? 2 : 0;
        this.closeDialog();
    }

    private void updateAction() {
        try {
            Platform.get().showDocument(this.updateURL.toString());
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dialog.dispose();
    }

    private void addMouseListener() {
        final Point point = new Point();
        this.dialog.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                point.x = mouseEvent.getX();
                point.y = mouseEvent.getY();
            }
        });
        this.dialog.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point2 = SSV3Dialog.this.dialog.getLocationOnScreen();
                SSV3Dialog.this.dialog.setLocation(point2.x + mouseEvent.getX() - point.x, point2.y + mouseEvent.getY() - point.y);
            }
        });
    }

    private void cancelAction() {
        this.userAnswer = 1;
        this.closeDialog();
    }

    private static void setSSVFonts() {
        if (ssvFont == null) {
            int n;
            JLabel jLabel = new JLabel();
            int n2 = n = ResourceManager.getUIFont().getSize();
            int n3 = n + 1;
            int n4 = n + 4;
            ssvSmallFont = jLabel.getFont().deriveFont(0, n2);
            ssvSmallBoldFont = jLabel.getFont().deriveFont(1, n2);
            ssvFont = jLabel.getFont().deriveFont(0, n3);
            ssvBoldFont = jLabel.getFont().deriveFont(1, n3);
            ssvBigFont = jLabel.getFont().deriveFont(0, n4);
            ssvBigBoldFont = jLabel.getFont().deriveFont(1, n4);
        }
    }

    private void createDialog() {
        this.dialog = this.owner == null || this.owner instanceof Frame ? new JDialog((Frame)this.owner, this.title, true) : new JDialog((Dialog)this.owner, this.title, true);
    }

    private void setVisible(boolean bl) {
        this.dialog.setVisible(bl);
    }

    private static String displayPropertiesToCSS(String string, Font font) {
        StringBuilder stringBuilder = new StringBuilder(string + " {");
        if (font != null) {
            stringBuilder.append(" font-family: ");
            stringBuilder.append(font.getFamily());
            stringBuilder.append(" ; ");
            stringBuilder.append(" font-size: ");
            stringBuilder.append(font.getSize());
            stringBuilder.append("pt ;");
            if (font.isBold()) {
                stringBuilder.append(" font-weight: 700 ; ");
            }
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private static class PromptEditorKit
    extends HTMLEditorKit {
        private StyleSheet _defaultStyles;

        private PromptEditorKit() {
        }

        public StyleSheet getStyleSheet() {
            if (this._defaultStyles == null) {
                this._defaultStyles = new StyleSheet();
                this._defaultStyles.addStyleSheet(super.getStyleSheet());
                this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                this._defaultStyles.addStyleSheet(this.createStyleSheetFromString(SSV3Dialog.displayPropertiesToCSS("body", ssvSmallFont)));
                this._defaultStyles.addStyleSheet(this.createStyleSheetFromString(SSV3Dialog.displayPropertiesToCSS("b", ssvBoldFont)));
            }
            return this._defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String string) {
            StyleSheet styleSheet = new StyleSheet();
            StringReader stringReader = null;
            try {
                try {
                    stringReader = new StringReader(string);
                    styleSheet.loadRules(stringReader, null);
                }
                catch (IOException iOException) {
                    Trace.printException(iOException);
                    Object var6_5 = null;
                    if (stringReader != null) {
                        stringReader.close();
                    }
                }
                Object var6_4 = null;
                if (stringReader != null) {
                    stringReader.close();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (stringReader != null) {
                    stringReader.close();
                }
                throw throwable;
            }
            return styleSheet;
        }
    }
}

