/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.SerializerTrace;
import com.sun.org.apache.xml.internal.serializer.WriterChain;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

final class SerializerTraceWriter
extends Writer
implements WriterChain {
    private final Writer m_writer;
    private final SerializerTrace m_tracer;
    private int buf_length;
    private byte[] buf;
    private int count;

    private void setBufferSize(int n) {
        this.buf = new byte[n + 3];
        this.buf_length = n;
        this.count = 0;
    }

    public SerializerTraceWriter(Writer writer, SerializerTrace serializerTrace) {
        this.m_writer = writer;
        this.m_tracer = serializerTrace;
        this.setBufferSize(1024);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            char[] cArray = new char[this.count];
            for (int i = 0; i < this.count; ++i) {
                cArray[i] = (char)this.buf[i];
            }
            if (this.m_tracer != null) {
                this.m_tracer.fireGenerateEvent(12, cArray, 0, cArray.length);
            }
            this.count = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        this.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
        this.flushBuffer();
    }

    @Override
    public void write(int n) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(n);
        }
        if (this.count >= this.buf_length) {
            this.flushBuffer();
        }
        if (n < 128) {
            this.buf[this.count++] = (byte)n;
        } else if (n < 2048) {
            this.buf[this.count++] = (byte)(192 + (n >> 6));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (n >> 12));
            this.buf[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.m_writer != null) {
            this.m_writer.write(cArray, n, n2);
        }
        if ((n3 = (n2 << 1) + n2) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * n3);
        }
        if (n3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int n4 = n2 + n;
        for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.buf[this.count++] = (byte)(224 + (c >> 12));
            this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    @Override
    public void write(String string) throws IOException {
        int n;
        int n2;
        if (this.m_writer != null) {
            this.m_writer.write(string);
        }
        if ((n2 = ((n = string.length()) << 1) + n) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * n2);
        }
        if (n2 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.buf[this.count++] = (byte)(224 + (c >> 12));
            this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    @Override
    public Writer getWriter() {
        return this.m_writer;
    }

    @Override
    public OutputStream getOutputStream() {
        OutputStream outputStream = null;
        if (this.m_writer instanceof WriterChain) {
            outputStream = ((WriterChain)((Object)this.m_writer)).getOutputStream();
        }
        return outputStream;
    }
}

