/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AuFileFormat;
import com.sun.media.sound.SunFileWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AuFileWriter
extends SunFileWriter {
    public static final int UNKNOWN_SIZE = -1;
    private static final AudioFileFormat.Type[] auTypes = new AudioFileFormat.Type[]{AudioFileFormat.Type.AU};

    public AuFileWriter() {
        super(auTypes);
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, typeArray, 0, this.types.length);
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (AudioFormat.Encoding.ALAW.equals(encoding) || AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            return typeArray;
        }
        return new AudioFileFormat.Type[0];
    }

    @Override
    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(type, audioInputStream);
        int n = this.writeAuFile(audioInputStream, auFileFormat, outputStream);
        return n;
    }

    @Override
    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(type, audioInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
        int n = this.writeAuFile(audioInputStream, auFileFormat, bufferedOutputStream);
        bufferedOutputStream.close();
        if (auFileFormat.getByteLength() == -1) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            if (randomAccessFile.length() <= Integer.MAX_VALUE) {
                randomAccessFile.skipBytes(8);
                randomAccessFile.writeInt(n - 24);
            }
            randomAccessFile.close();
        }
        return n;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        int n;
        AudioFormat audioFormat = null;
        AuFileFormat auFileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        if (!this.types[0].equals(type)) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (AudioFormat.Encoding.ALAW.equals(encoding2) || AudioFormat.Encoding.ULAW.equals(encoding2)) {
            encoding = encoding2;
            n = audioFormat2.getSampleSizeInBits();
        } else if (audioFormat2.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = audioFormat2.getSampleSizeInBits();
        }
        audioFormat = new AudioFormat(encoding, audioFormat2.getSampleRate(), n, audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), true);
        int n2 = audioInputStream.getFrameLength() != -1L ? (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() + 24 : -1;
        auFileFormat = new AuFileFormat(AudioFileFormat.Type.AU, n2, audioFormat, (int)audioInputStream.getFrameLength());
        return auFileFormat;
    }

    private InputStream getFileStream(AuFileFormat auFileFormat, InputStream inputStream) throws IOException {
        long l;
        AudioFormat audioFormat = auFileFormat.getFormat();
        int n = 779316836;
        int n2 = 24;
        long l2 = auFileFormat.getFrameLength();
        long l3 = l = l2 == -1L ? -1L : l2 * (long)audioFormat.getFrameSize();
        if (l > Integer.MAX_VALUE) {
            l = -1L;
        }
        int n3 = auFileFormat.getAuType();
        int n4 = (int)audioFormat.getSampleRate();
        int n5 = audioFormat.getChannels();
        boolean bl = true;
        byte[] byArray = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        SequenceInputStream sequenceInputStream = null;
        AudioFormat audioFormat2 = null;
        AudioFormat.Encoding encoding = null;
        InputStream inputStream2 = inputStream;
        inputStream2 = inputStream;
        if (inputStream instanceof AudioInputStream && (AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding = (audioFormat2 = ((AudioInputStream)inputStream).getFormat()).getEncoding()) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) && bl != audioFormat2.isBigEndian())) {
            inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), bl), (AudioInputStream)inputStream);
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (bl) {
            dataOutputStream.writeInt(779316836);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt((int)l);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n5);
        } else {
            dataOutputStream.writeInt(1684960046);
            dataOutputStream.writeInt(this.big2little(n2));
            dataOutputStream.writeInt(this.big2little((int)l));
            dataOutputStream.writeInt(this.big2little(n3));
            dataOutputStream.writeInt(this.big2little(n4));
            dataOutputStream.writeInt(this.big2little(n5));
        }
        dataOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        sequenceInputStream = new SequenceInputStream(byteArrayInputStream, new SunFileWriter.NoCloseInputStream(this, inputStream2));
        return sequenceInputStream;
    }

    private int writeAuFile(InputStream inputStream, AuFileFormat auFileFormat, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        InputStream inputStream2 = this.getFileStream(auFileFormat, inputStream);
        byte[] byArray = new byte[4096];
        int n3 = auFileFormat.getByteLength();
        while ((n = inputStream2.read(byArray)) >= 0) {
            if (n3 > 0) {
                if (n < n3) {
                    outputStream.write(byArray, 0, n);
                    n2 += n;
                    n3 -= n;
                    continue;
                }
                outputStream.write(byArray, 0, n3);
                n2 += n3;
                n3 = 0;
                break;
            }
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }
}

