/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSStyleSheetImpl;
import com.sun.webpane.webkit.dom.DocumentImpl;
import com.sun.webpane.webkit.dom.DocumentTypeImpl;
import com.sun.webpane.webkit.dom.HTMLDocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html.HTMLDocument;

public class DOMImplementationImpl
implements DOMImplementation {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    DOMImplementationImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static DOMImplementation create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new DOMImplementationImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(DOMImplementation arg) {
        return arg == null ? 0L : ((DOMImplementationImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof DOMImplementationImpl && this.peer == ((DOMImplementationImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static DOMImplementation getImpl(long peer, long contextPeer, long rootPeer) {
        return DOMImplementationImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        return DOMImplementationImpl.hasFeatureImpl(this.getPeer(), feature, version);
    }

    static native boolean hasFeatureImpl(long var0, String var2, String var3);

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        return DocumentTypeImpl.getImpl(DOMImplementationImpl.createDocumentTypeImpl(this.getPeer(), qualifiedName, publicId, systemId), this.contextPeer, this.rootPeer);
    }

    static native long createDocumentTypeImpl(long var0, String var2, String var3, String var4);

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        return DocumentImpl.getImpl(DOMImplementationImpl.createDocumentImpl(this.getPeer(), namespaceURI, qualifiedName, DocumentTypeImpl.getPeer(doctype)), this.contextPeer, this.rootPeer);
    }

    static native long createDocumentImpl(long var0, String var2, String var3, long var4);

    public CSSStyleSheet createCSSStyleSheet(String title, String media) throws DOMException {
        return CSSStyleSheetImpl.getImpl(DOMImplementationImpl.createCSSStyleSheetImpl(this.getPeer(), title, media), this.contextPeer, this.rootPeer);
    }

    static native long createCSSStyleSheetImpl(long var0, String var2, String var3);

    public HTMLDocument createHTMLDocument(String title) {
        return HTMLDocumentImpl.getImpl(DOMImplementationImpl.createHTMLDocumentImpl(this.getPeer(), title), this.contextPeer, this.rootPeer);
    }

    static native long createHTMLDocumentImpl(long var0, String var2);

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            DOMImplementationImpl.dispose(this.peer);
        }
    }
}

