/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedCopyOption;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutionException;
import sun.nio.fs.Cancellable;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsAclFileAttributeView;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributeViews;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsSecurity;

class WindowsFileCopy {
    private WindowsFileCopy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copy(final WindowsPath windowsPath, final WindowsPath windowsPath2, CopyOption ... copyOptionArray) throws IOException {
        boolean bl2;
        block52: {
            Object object;
            boolean bl4 = false;
            boolean bl3 = false;
            bl2 = true;
            boolean bl = false;
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    bl4 = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                    bl2 = false;
                    continue;
                }
                if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                    bl3 = true;
                    continue;
                }
                if (copyOption != ExtendedCopyOption.INTERRUPTIBLE) {
                    if (copyOption != null) throw new UnsupportedOperationException("Unsupported copy option");
                    throw new NullPointerException();
                }
                bl = true;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                windowsPath.checkRead();
                windowsPath2.checkWrite();
            }
            WindowsFileAttributes windowsFileAttributes2 = null;
            WindowsFileAttributes windowsFileAttributes = null;
            long l = 0L;
            try {
                l = windowsPath.openForReadAttributeAccess(bl2);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            try {
                try {
                    windowsFileAttributes2 = WindowsFileAttributes.readAttributes(l);
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath);
                }
                long l2 = 0L;
                try {
                    block48: {
                        l2 = windowsPath2.openForReadAttributeAccess(false);
                        windowsFileAttributes = WindowsFileAttributes.readAttributes(l2);
                        if (!WindowsFileAttributes.isSameFile(windowsFileAttributes2, windowsFileAttributes)) break block48;
                        WindowsNativeDispatcher.CloseHandle(l2);
                        return;
                    }
                    try {
                        if (!bl4) {
                            throw new FileAlreadyExistsException(windowsPath2.getPathForExceptionMessage());
                        }
                    }
                    finally {
                        WindowsNativeDispatcher.CloseHandle(l2);
                    }
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
            finally {
                WindowsNativeDispatcher.CloseHandle(l);
            }
            if (securityManager != null && windowsFileAttributes2.isSymbolicLink()) {
                securityManager.checkPermission(new LinkPermission("symbolic"));
            }
            final String string = WindowsFileCopy.asWin32Path(windowsPath);
            final String string2 = WindowsFileCopy.asWin32Path(windowsPath2);
            if (windowsFileAttributes != null) {
                try {
                    if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                        WindowsNativeDispatcher.RemoveDirectory(string2);
                    } else {
                        WindowsNativeDispatcher.DeleteFile(string2);
                    }
                }
                catch (WindowsException windowsException) {
                    if (windowsFileAttributes.isDirectory()) {
                        if (windowsException.lastError() == 145) throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                        if (windowsException.lastError() == 183) {
                            throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                        }
                    }
                    windowsException.rethrowAsIOException(windowsPath2);
                }
            }
            if (!windowsFileAttributes2.isDirectory() && !windowsFileAttributes2.isDirectoryLink()) {
                int n;
                int n2 = n = windowsPath.getFileSystem().supportsLinks() && !bl2 ? 2048 : 0;
                if (bl) {
                    Cancellable cancellable = new Cancellable(){

                        @Override
                        public int cancelValue() {
                            return 1;
                        }

                        @Override
                        public void implRun() throws IOException {
                            try {
                                WindowsNativeDispatcher.CopyFileEx(string, string2, n, this.addressToPollForCancel());
                            }
                            catch (WindowsException windowsException) {
                                windowsException.rethrowAsIOException(windowsPath, windowsPath2);
                            }
                        }
                    };
                    try {
                        Cancellable.runInterruptibly(cancellable);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        if (!(throwable instanceof IOException)) throw new IOException(throwable);
                        throw (IOException)throwable;
                    }
                }
                try {
                    WindowsNativeDispatcher.CopyFileEx(string, string2, n, 0L);
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath, windowsPath2);
                }
                if (!bl3) return;
                try {
                    WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, bl2);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            try {
                if (windowsFileAttributes2.isDirectory()) {
                    WindowsNativeDispatcher.CreateDirectory(string2, 0L);
                } else {
                    object = WindowsLinkSupport.readLink(windowsPath);
                    int n = 1;
                    WindowsNativeDispatcher.CreateSymbolicLink(string2, WindowsFileCopy.addPrefixIfNeeded((String)object), n);
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            if (!bl3) return;
            object = WindowsFileAttributeViews.createDosView(windowsPath2, false);
            try {
                ((WindowsFileAttributeViews.Dos)object).setAttributes(windowsFileAttributes2);
            }
            catch (IOException iOException) {
                if (!windowsFileAttributes2.isDirectory()) break block52;
                try {
                    WindowsNativeDispatcher.RemoveDirectory(string2);
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
        }
        try {
            WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, bl2);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void move(WindowsPath windowsPath, WindowsPath windowsPath2, CopyOption ... copyOptionArray) throws IOException {
        void var8_15;
        boolean bl = false;
        boolean bl2 = false;
        for (CopyOption windowsException : copyOptionArray) {
            if (windowsException == StandardCopyOption.ATOMIC_MOVE) {
                bl = true;
                continue;
            }
            if (windowsException == StandardCopyOption.REPLACE_EXISTING) {
                bl2 = true;
                continue;
            }
            if (windowsException == LinkOption.NOFOLLOW_LINKS) continue;
            if (windowsException != null) throw new UnsupportedOperationException("Unsupported copy option");
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            windowsPath.checkWrite();
            windowsPath2.checkWrite();
        }
        String string2 = WindowsFileCopy.asWin32Path(windowsPath);
        String string = WindowsFileCopy.asWin32Path(windowsPath2);
        if (bl) {
            try {
                WindowsNativeDispatcher.MoveFileEx(string2, string, 1);
                return;
            }
            catch (WindowsException windowsException) {
                if (windowsException.lastError() == 17) {
                    throw new AtomicMoveNotSupportedException(windowsPath.getPathForExceptionMessage(), windowsPath2.getPathForExceptionMessage(), windowsException.errorString());
                }
                windowsException.rethrowAsIOException(windowsPath, windowsPath2);
            }
            return;
        }
        Object var8_13 = null;
        WindowsFileAttributes windowsFileAttributes = null;
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(false);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        try {
            try {
                WindowsFileAttributes windowsFileAttributes2 = WindowsFileAttributes.readAttributes(l);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            long iOException = 0L;
            try {
                block55: {
                    iOException = windowsPath2.openForReadAttributeAccess(false);
                    windowsFileAttributes = WindowsFileAttributes.readAttributes(iOException);
                    if (!WindowsFileAttributes.isSameFile((WindowsFileAttributes)var8_15, windowsFileAttributes)) break block55;
                    WindowsNativeDispatcher.CloseHandle(iOException);
                    return;
                }
                try {
                    if (!bl2) {
                        throw new FileAlreadyExistsException(windowsPath2.getPathForExceptionMessage());
                    }
                }
                finally {
                    WindowsNativeDispatcher.CloseHandle(iOException);
                }
            }
            catch (WindowsException windowsException) {
                // empty catch block
            }
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(l);
        }
        if (windowsFileAttributes != null) {
            try {
                if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                    WindowsNativeDispatcher.RemoveDirectory(string);
                } else {
                    WindowsNativeDispatcher.DeleteFile(string);
                }
            }
            catch (WindowsException object4) {
                if (windowsFileAttributes.isDirectory()) {
                    if (object4.lastError() == 145) throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                    if (object4.lastError() == 183) {
                        throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                    }
                }
                object4.rethrowAsIOException(windowsPath2);
            }
        }
        try {
            WindowsNativeDispatcher.MoveFileEx(string2, string, 0);
            return;
        }
        catch (WindowsException windowsException3) {
            Object object;
            if (windowsException3.lastError() != 17) {
                windowsException3.rethrowAsIOException(windowsPath, windowsPath2);
            }
            if (!var8_15.isDirectory() && !var8_15.isDirectoryLink()) {
                try {
                    WindowsNativeDispatcher.MoveFileEx(string2, string, 2);
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath, windowsPath2);
                }
                try {
                    WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, false);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            assert (var8_15.isDirectory() || var8_15.isDirectoryLink());
            try {
                if (var8_15.isDirectory()) {
                    WindowsNativeDispatcher.CreateDirectory(string, 0L);
                } else {
                    object = WindowsLinkSupport.readLink(windowsPath);
                    WindowsNativeDispatcher.CreateSymbolicLink(string, WindowsFileCopy.addPrefixIfNeeded((String)object), 1);
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            object = WindowsFileAttributeViews.createDosView(windowsPath2, false);
            try {
                ((WindowsFileAttributeViews.Dos)object).setAttributes((WindowsFileAttributes)var8_15);
            }
            catch (IOException iOException) {
                try {
                    WindowsNativeDispatcher.RemoveDirectory(string);
                    throw iOException;
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
                throw iOException;
            }
            try {
                WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                WindowsNativeDispatcher.RemoveDirectory(string2);
                return;
            }
            catch (WindowsException windowsException) {
                try {
                    WindowsNativeDispatcher.RemoveDirectory(string);
                }
                catch (WindowsException windowsException2) {
                    // empty catch block
                }
                if (windowsException.lastError() == 145) throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                if (windowsException.lastError() == 183) {
                    throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                }
                windowsException.rethrowAsIOException(windowsPath);
            }
            return;
        }
    }

    private static String asWin32Path(WindowsPath windowsPath) throws IOException {
        try {
            return windowsPath.getPathForWin32Calls();
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySecurityAttributes(WindowsPath windowsPath, WindowsPath windowsPath2, boolean bl) throws IOException {
        String string = WindowsLinkSupport.getFinalPath(windowsPath, bl);
        WindowsSecurity.Privilege privilege = WindowsSecurity.enablePrivilege("SeRestorePrivilege");
        try {
            int n = 7;
            NativeBuffer nativeBuffer = WindowsAclFileAttributeView.getFileSecurity(string, n);
            try {
                try {
                    WindowsNativeDispatcher.SetFileSecurity(windowsPath2.getPathForWin32Calls(), n, nativeBuffer.address());
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath2);
                }
            }
            finally {
                nativeBuffer.release();
            }
        }
        finally {
            privilege.drop();
        }
    }

    private static String addPrefixIfNeeded(String string) {
        if (string.length() > 248) {
            string = string.startsWith("\\\\") ? "\\\\?\\UNC" + string.substring(1, string.length()) : "\\\\?\\" + string;
        }
        return string;
    }
}

