/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.windows.EHTMLReadMode;
import sun.awt.windows.HTMLCodec;
import sun.awt.windows.WToolkitThreadBlockedHandler;

public class WDataTransferer
extends DataTransferer {
    private static final String[] predefinedClipboardNames = new String[]{"", "TEXT", "BITMAP", "METAFILEPICT", "SYLK", "DIF", "TIFF", "OEM TEXT", "DIB", "PALETTE", "PENDATA", "RIFF", "WAVE", "UNICODE TEXT", "ENHMETAFILE", "HDROP", "LOCALE", "DIBV5"};
    private static final Map predefinedClipboardNameMap;
    public static final int CF_TEXT = 1;
    public static final int CF_METAFILEPICT = 3;
    public static final int CF_DIB = 8;
    public static final int CF_ENHMETAFILE = 14;
    public static final int CF_HDROP = 15;
    public static final int CF_LOCALE = 16;
    public static final long CF_HTML;
    public static final long CFSTR_INETURL;
    public static final long CF_PNG;
    public static final long CF_JFIF;
    public static final long CF_FILEGROUPDESCRIPTORW;
    public static final long CF_FILEGROUPDESCRIPTORA;
    private static final Long L_CF_LOCALE;
    private static final DirectColorModel directColorModel;
    private static final int[] bandmasks;
    private static WDataTransferer transferer;
    private final ToolkitThreadBlockedHandler handler = new WToolkitThreadBlockedHandler();
    private static final byte[] UNICODE_NULL_TERMINATOR;

    private WDataTransferer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WDataTransferer getInstanceImpl() {
        if (transferer != null) return transferer;
        Class<WDataTransferer> clazz = WDataTransferer.class;
        synchronized (WDataTransferer.class) {
            if (transferer != null) return transferer;
            transferer = new WDataTransferer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transferer;
        }
    }

    @Override
    public SortedMap getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        SortedMap sortedMap = super.getFormatsForFlavors(dataFlavorArray, flavorTable);
        sortedMap.remove(L_CF_LOCALE);
        return sortedMap;
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    @Override
    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        byte[] byArray = super.translateTransferable(transferable, dataFlavor, l);
        if (l == CF_HTML) {
            byArray = HTMLCodec.convertToHTMLFormat(byArray);
        }
        return byArray;
    }

    @Override
    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (l == CF_HTML && dataFlavor.isFlavorTextType()) {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(byArray);
                byArray = null;
            }
            inputStream = new HTMLCodec(inputStream, EHTMLReadMode.HTML_READ_ALL);
        }
        if (l == CF_FILEGROUPDESCRIPTORA || l == CF_FILEGROUPDESCRIPTORW) {
            if (null != inputStream) {
                inputStream.close();
            }
            if (byArray == null || !DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            String string = new String(byArray, 0, byArray.length, "UTF-16LE");
            String[] stringArray = string.split("\u0000");
            if (0 == stringArray.length) {
                return null;
            }
            File[] fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(stringArray[i]);
                fileArray[i].deleteOnExit();
            }
            return Arrays.asList(fileArray);
        }
        if (l == CFSTR_INETURL && URL.class.equals(dataFlavor.getRepresentationClass())) {
            if (byArray == null) {
                byArray = WDataTransferer.inputStreamToByteArray(inputStream);
                inputStream = null;
            }
            String string = WDataTransferer.getDefaultTextCharset();
            if (transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(byArray, string));
        }
        return super.translateBytesOrStream(inputStream, byArray, dataFlavor, l, transferable);
    }

    @Override
    public boolean isLocaleDependentTextFormat(long l) {
        return l == 1L || l == CFSTR_INETURL;
    }

    @Override
    public boolean isFileFormat(long l) {
        return l == 15L || l == CF_FILEGROUPDESCRIPTORA || l == CF_FILEGROUPDESCRIPTORW;
    }

    @Override
    protected Long getFormatForNativeAsLong(String string) {
        Long l = (Long)predefinedClipboardNameMap.get(string);
        if (l == null) {
            l = WDataTransferer.registerClipboardFormat(string);
        }
        return l;
    }

    @Override
    protected String getNativeForFormat(long l) {
        return l < (long)predefinedClipboardNames.length ? predefinedClipboardNames[(int)l] : WDataTransferer.getClipboardFormatName(l);
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    private static native long registerClipboardFormat(String var0);

    private static native String getClipboardFormatName(long var0);

    @Override
    public boolean isImageFormat(long l) {
        return l == 8L || l == 14L || l == 3L || l == CF_PNG || l == CF_JFIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] imageToPlatformBytes(Image image, long l) throws IOException {
        String string = null;
        if (l == CF_PNG) {
            string = "image/png";
        } else if (l == CF_JFIF) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.imageToStandardBytes(image, string);
        }
        int n = 0;
        int n2 = 0;
        if (image instanceof ToolkitImage) {
            ImageRepresentation imageRepresentation = ((ToolkitImage)image).getImageRep();
            imageRepresentation.reconstruct(32);
            n = imageRepresentation.getWidth();
            n2 = imageRepresentation.getHeight();
        } else {
            n = image.getWidth(null);
            n2 = image.getHeight(null);
        }
        int n3 = n * 3 % 4;
        int n4 = n3 > 0 ? 4 - n3 : 0;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[]{8, 8, 8};
        int[] nArray2 = new int[]{2, 1, 0};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n * 3 + n4, 3, nArray2, null);
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(image, affineTransform, null);
        }
        finally {
            graphics2D.dispose();
        }
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        return this.imageDataToPlatformImageBytes(byArray, n, n2, l);
    }

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> arrayList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (arrayList.isEmpty()) {
            byteArrayOutputStream.write(UNICODE_NULL_TERMINATOR);
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = arrayList.get(i).getBytes(this.getDefaultUnicodeEncoding());
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                byteArrayOutputStream.write(UNICODE_NULL_TERMINATOR);
            }
        }
        byteArrayOutputStream.write(UNICODE_NULL_TERMINATOR);
        return byteArrayOutputStream;
    }

    private native byte[] imageDataToPlatformImageBytes(byte[] var1, int var2, int var3, long var4);

    @Override
    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l) throws IOException {
        int[] nArray;
        String string = null;
        if (l == CF_PNG) {
            string = "image/png";
        } else if (l == CF_JFIF) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.standardImageBytesOrStreamToImage(inputStream, byArray, string);
        }
        if (byArray == null) {
            byArray = WDataTransferer.inputStreamToByteArray(inputStream);
        }
        if ((nArray = this.platformImageBytesToImageData(byArray, l)) == null) {
            throw new IOException("data translation failed");
        }
        int n = nArray.length - 2;
        int n2 = nArray[n];
        int n3 = nArray[n + 1];
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n2, n3, n2, bandmasks, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    private native int[] platformImageBytesToImageData(byte[] var1, long var2) throws IOException;

    @Override
    protected native String[] dragQueryFile(byte[] var1);

    static {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(predefinedClipboardNames.length, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            hashMap.put(predefinedClipboardNames[i], Long.valueOf(i));
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        CF_HTML = WDataTransferer.registerClipboardFormat("HTML Format");
        CFSTR_INETURL = WDataTransferer.registerClipboardFormat("UniformResourceLocator");
        CF_PNG = WDataTransferer.registerClipboardFormat("PNG");
        CF_JFIF = WDataTransferer.registerClipboardFormat("JFIF");
        CF_FILEGROUPDESCRIPTORW = WDataTransferer.registerClipboardFormat("FileGroupDescriptorW");
        CF_FILEGROUPDESCRIPTORA = WDataTransferer.registerClipboardFormat("FileGroupDescriptor");
        L_CF_LOCALE = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[16]);
        directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        bandmasks = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
        UNICODE_NULL_TERMINATOR = new byte[]{0, 0};
    }
}

