/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.CharInfo;
import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.ToStream;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public final class ToXMLStream
extends ToStream {
    boolean m_cdataTagOpen = false;
    private static CharInfo m_xmlcharInfo = CharInfo.getCharInfo("com.sun.org.apache.xml.internal.serializer.XMLEntities", "xml");

    public ToXMLStream() {
        this.m_charInfo = m_xmlcharInfo;
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
    }

    public void CopyFrom(ToXMLStream toXMLStream) {
        this.m_writer = toXMLStream.m_writer;
        String string = toXMLStream.getEncoding();
        this.setEncoding(string);
        this.setOmitXMLDeclaration(toXMLStream.getOmitXMLDeclaration());
        this.m_ispreserve = toXMLStream.m_ispreserve;
        this.m_preserves = toXMLStream.m_preserves;
        this.m_isprevtext = toXMLStream.m_isprevtext;
        this.m_doIndent = toXMLStream.m_doIndent;
        this.setIndentAmount(toXMLStream.getIndentAmount());
        this.m_startNewLine = toXMLStream.m_startNewLine;
        this.m_needToOutputDocTypeDecl = toXMLStream.m_needToOutputDocTypeDecl;
        this.setDoctypeSystem(toXMLStream.getDoctypeSystem());
        this.setDoctypePublic(toXMLStream.getDoctypePublic());
        this.setStandalone(toXMLStream.getStandalone());
        this.setMediaType(toXMLStream.getMediaType());
        this.m_maxCharacter = toXMLStream.m_maxCharacter;
        this.m_encodingInfo = toXMLStream.m_encodingInfo;
        this.m_spaceBeforeClose = toXMLStream.m_spaceBeforeClose;
        this.m_cdataStartCalled = toXMLStream.m_cdataStartCalled;
    }

    @Override
    public void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            if (this.m_inEntityRef) {
                return;
            }
            this.m_needToOutputDocTypeDecl = true;
            this.m_startNewLine = false;
            if (!this.getOmitXMLDeclaration()) {
                String string = Encodings.getMimeEncoding(this.getEncoding());
                String string2 = this.getVersion();
                if (string2 == null) {
                    string2 = "1.0";
                }
                String string3 = this.m_standaloneWasSpecified ? " standalone=\"" + this.getStandalone() + "\"" : "";
                try {
                    Writer writer = this.m_writer;
                    writer.write("<?xml version=\"");
                    writer.write(string2);
                    writer.write("\" encoding=\"");
                    writer.write(string);
                    writer.write(34);
                    writer.write(string3);
                    writer.write("?>");
                    if (this.m_doIndent && (this.m_standaloneWasSpecified || this.getDoctypePublic() != null || this.getDoctypeSystem() != null || this.m_isStandalone)) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    }
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.flushPending();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int n;
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                if ((n = string2.indexOf("?>")) >= 0) {
                    if (n > 0) {
                        writer.write(string2.substring(0, n));
                    }
                    writer.write("? >");
                    if (n + 2 < string2.length()) {
                        writer.write(string2.substring(n + 2));
                    }
                } else {
                    writer.write(string2);
                }
                writer.write(63);
                writer.write(62);
                if (this.m_elemContext.m_currentElemDepth <= 0 && this.m_isStandalone) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    @Override
    public void entityReference(String string) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    @Override
    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            try {
                String string3 = this.patchName(string);
                Writer writer = this.m_writer;
                if ((n & 1) > 0 && ToXMLStream.m_xmlcharInfo.onlyQuotAmpLtGt) {
                    writer.write(32);
                    writer.write(string3);
                    writer.write("=\"");
                    writer.write(string2);
                    writer.write(34);
                } else {
                    writer.write(32);
                    writer.write(string3);
                    writer.write("=\"");
                    this.writeAttrString(writer, string2, this.getEncoding());
                    writer.write(34);
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            String string6;
            boolean bl2 = this.addAttributeAlways(string, string2, string3, string4, string5, bl);
            if (bl2 && !bl && !string3.startsWith("xmlns") && (string6 = this.ensureAttributesNamespaceIsDeclared(string, string2, string3)) != null && string3 != null && !string3.startsWith(string6)) {
                string3 = string6 + ":" + string2;
            }
            this.addAttributeAlways(string, string2, string3, string4, string5, bl);
        } else {
            String string7 = Utils.messages.createMessage("ER_ILLEGAL_ATTRIBUTE_POSITION", new Object[]{string2});
            try {
                Transformer transformer = super.getTransformer();
                ErrorListener errorListener = transformer.getErrorListener();
                if (null != errorListener && this.m_sourceLocator != null) {
                    errorListener.warning(new TransformerException(string7, this.m_sourceLocator));
                } else {
                    System.out.println(string7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    @Override
    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToXMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    protected boolean pushNamespace(String string, String string2) {
        try {
            if (this.m_prefixMap.pushNamespace(string, string2, this.m_elemContext.m_currentElemDepth)) {
                this.startPrefixMapping(string, string2);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean reset() {
        boolean bl = false;
        if (super.reset()) {
            this.resetToXMLStream();
            bl = true;
        }
        return bl;
    }

    private void resetToXMLStream() {
        this.m_cdataTagOpen = false;
    }

    private String getXMLVersion() {
        String string = this.getVersion();
        if (string == null || string.equals("1.0")) {
            string = "1.0";
        } else if (string.equals("1.1")) {
            string = "1.1";
        } else {
            String string2 = Utils.messages.createMessage("ER_XML_VERSION_NOT_SUPPORTED", new Object[]{string});
            try {
                Transformer transformer = super.getTransformer();
                ErrorListener errorListener = transformer.getErrorListener();
                if (null != errorListener && this.m_sourceLocator != null) {
                    errorListener.warning(new TransformerException(string2, this.m_sourceLocator));
                } else {
                    System.out.println(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = "1.0";
        }
        return string;
    }
}

