/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.PerfLogger;
import java.io.IOException;
import java.io.Serializable;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

final class CertValidator {
    CertValidator() {
    }

    public static boolean validate(CodeSource codeSource, AppInfo appInfo, Certificate[] certificateArray, int n, CertStore certStore, CertStore certStore2, CertStore certStore3, CertStore certStore4, CertStore certStore5, CertStore certStore6) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        PerfLogger.setTime("Security: Start CertValdator class");
        HashMap hashMap = new HashMap();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        hashMap = CertValidator.getCertMap(certStore, certStore2);
        Date date = new Date();
        certificateArray = CertValidator.canonicalize(certificateArray, date, hashMap);
        n = 0;
        while (n4 < certificateArray.length) {
            Object object;
            boolean bl4;
            Serializable serializable;
            int n5 = n3;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            for (n5 = n3; n5 < certificateArray.length; ++n5) {
                X509Certificate x509Certificate;
                block36: {
                    x509Certificate = null;
                    serializable = null;
                    if (certificateArray[n5] instanceof X509Certificate) {
                        x509Certificate = (X509Certificate)certificateArray[n5];
                    }
                    serializable = n5 + 1 < certificateArray.length && certificateArray[n5 + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n5 + 1] : x509Certificate;
                    try {
                        x509Certificate.checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block36;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                if (!(certStore.contains(x509Certificate) || n5 + 1 == certificateArray.length || !CertUtils.isIssuerOf(x509Certificate, (X509Certificate)serializable) || certStore2 != null && certStore2.contains(x509Certificate))) {
                    CertUtils.checkUsageForCodeSigning(x509Certificate, n5 - n3);
                }
                if (!CertUtils.isIssuerOf(x509Certificate, (X509Certificate)serializable)) break;
                try {
                    x509Certificate.verify(((Certificate)serializable).getPublicKey());
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    Trace.msgSecurityPrintln("trustdecider.check.signature");
                    string = ResourceManager.getMessage("trustdecider.check.signature");
                    throw new CertificateException(string);
                }
            }
            int n6 = n4 = n5 < certificateArray.length ? n5 + 1 : n5;
            if (!SecuritySettings.isAskGrantShowSet()) {
                string = ResourceManager.getMessage("trustdecider.user.cannot.grant.any");
                throw new CertificateException(string);
            }
            boolean bl5 = bl4 = certStore.verify(certificateArray[n4 - 1]) || certStore2 != null && certStore2.verify(certificateArray[n4 - 1]);
            if (!bl4) {
                if (!SecuritySettings.isAskGrantSelfSignedSet()) {
                    string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                    throw new CertificateException(string);
                }
                bl = true;
            }
            if (certificateExpiredException != null) {
                bl2 = true;
                n2 = -1;
            }
            if (certificateNotYetValidException != null) {
                bl2 = true;
                n2 = 1;
            }
            serializable = null;
            try {
                CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
                Timestamp timestamp = codeSignerArray[n].getTimestamp();
                if (timestamp != null) {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                    serializable = timestamp.getTimestamp();
                    object = timestamp.getSignerCertPath();
                    if (bl2) {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                        Date date2 = ((X509Certificate)certificateArray[n4 - 1]).getNotAfter();
                        Date date3 = ((X509Certificate)certificateArray[n4 - 1]).getNotBefore();
                        if (((Date)serializable).before(date2) && ((Date)serializable).after(date3)) {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                            boolean bl6 = CertValidator.checkTSAPath((CertPath)object, date, certStore2, certStore, hashMap);
                            if (bl6) {
                                bl2 = false;
                                n2 = 0;
                            } else {
                                serializable = null;
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                        }
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
                    }
                } else {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
            }
            boolean bl7 = false;
            if (certStore6.contains(certificateArray[n3])) {
                bl7 = certStore6.contains(certificateArray[n3], true) ? true : bl2;
            }
            if (!bl7) {
                if (!(!certStore5.contains(certificateArray[n3]) || bl2 && certStore5.contains(certificateArray[n3], true))) {
                    return true;
                }
                if (!(!certStore4.contains(certificateArray[n3]) || bl2 && certStore4.contains(certificateArray[n3], true))) {
                    return true;
                }
                if (certStore3 != null && certStore3.contains(certificateArray[n3])) {
                    return true;
                }
                int n7 = X509Util.showSecurityDialog(certificateArray, codeSource.getLocation(), n3, n4, bl, n2, (Date)serializable, appInfo);
                if (n7 == 0) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                    certStore4.add(certificateArray[n3], !bl2);
                    certStore4.save();
                    bl3 = true;
                } else if (n7 == 2) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                    object = DeploySigningCertStore.getUserCertStore();
                    object.load(true);
                    if (object.add(certificateArray[n3], !bl2)) {
                        object.save();
                    }
                    bl3 = true;
                } else {
                    Trace.msgSecurityPrintln("trustdecider.user.deny");
                    certStore6.add(certificateArray[n3], !bl2);
                    certStore6.save();
                }
                PerfLogger.setTime("Security: End CertValdator class");
                if (bl3) {
                    return true;
                }
            }
            n3 = n4;
            ++n;
        }
        return false;
    }

    private static boolean checkTSAPath(CertPath certPath, Date date, CertStore certStore, CertStore certStore2, HashMap hashMap) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        try {
            int n;
            List<? extends Certificate> list = certPath.getCertificates();
            Object[] objectArray = list.toArray();
            int n2 = objectArray.length;
            Certificate[] certificateArray = new Certificate[n2];
            for (n = 0; n < n2; ++n) {
                certificateArray[n] = (Certificate)objectArray[n];
            }
            Certificate certificate = (certificateArray = CertValidator.canonicalize(certificateArray, date, hashMap))[(n = certificateArray.length) - 1];
            if (certStore2.verify(certificate) || certStore != null && certStore.verify(certificate)) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.inca");
                for (int i = 0; i < n - 1; ++i) {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
                    X509Certificate x509Certificate2 = (X509Certificate)certificateArray[i + 1];
                    try {
                        CertUtils.checkUsageForCodeSigning(x509Certificate, i, true);
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        continue;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        Trace.msgSecurityPrintln("trustdecider.check.signature");
                        return false;
                    }
                }
                return true;
            }
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notinca");
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static synchronized HashMap getCertMap(CertStore certStore, CertStore certStore2) throws KeyStoreException {
        Certificate certificate;
        Iterator iterator;
        HashMap hashMap = new HashMap();
        if (certStore != null) {
            iterator = certStore.getCertificates().iterator();
            while (iterator.hasNext()) {
                certificate = (Certificate)iterator.next();
                if (!(certificate instanceof X509Certificate)) continue;
                hashMap = CertValidator.addTrustedCert((X509Certificate)certificate, hashMap);
            }
        }
        if (certStore2 != null) {
            iterator = certStore2.getCertificates().iterator();
            while (iterator.hasNext()) {
                certificate = (Certificate)iterator.next();
                if (!(certificate instanceof X509Certificate)) continue;
                hashMap = CertValidator.addTrustedCert((X509Certificate)certificate, hashMap);
            }
        }
        return hashMap;
    }

    private static HashMap addTrustedCert(X509Certificate x509Certificate, HashMap hashMap) {
        Principal principal = X509Util.getSubjectPrincipal(x509Certificate);
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)hashMap.get(principal);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            hashMap.put(principal, arrayList);
        }
        arrayList.add(x509Certificate);
        return hashMap;
    }

    private static Certificate[] canonicalize(Certificate[] certificateArray, Date date, HashMap hashMap) throws CertificateException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(certificateArray.length);
        boolean bl = false;
        if (certificateArray.length == 0) {
            return certificateArray;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)certificateArray[i];
            X509Certificate x509Certificate3 = CertValidator.getTrustedCertificate(x509Certificate2, date, hashMap);
            if (x509Certificate3 != null) {
                Trace.msgSecurityPrintln("trustdecider.check.canonicalize.updatecert");
                x509Certificate2 = x509Certificate3;
                bl = true;
            }
            arrayList.add(x509Certificate2);
            Principal principal = X509Util.getSubjectPrincipal(certificateArray[i]);
            Principal principal2 = X509Util.getIssuerPrincipal(certificateArray[i]);
            Principal principal3 = null;
            if (i < certificateArray.length - 1) {
                principal3 = X509Util.getSubjectPrincipal(certificateArray[i + 1]);
            }
            if (principal2.equals(principal) || principal2.equals(principal3) || (x509Certificate = CertValidator.getTrustedIssuerCertificate((X509Certificate)certificateArray[i], date, hashMap)) == null) continue;
            Trace.msgSecurityPrintln("trustdecider.check.canonicalize.missing");
            bl = true;
            arrayList.add(x509Certificate);
        }
        if (bl) {
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return certificateArray;
    }

    private static X509Certificate getTrustedCertificate(X509Certificate x509Certificate, Date date, HashMap hashMap) {
        Principal principal = X509Util.getSubjectPrincipal(x509Certificate);
        List list = (List)hashMap.get(principal);
        if (list == null) {
            return null;
        }
        Principal principal2 = X509Util.getIssuerPrincipal(x509Certificate);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate) || !X509Util.getIssuerPrincipal(x509Certificate2).equals(principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedcert.find");
            return x509Certificate2;
        }
        return null;
    }

    private static X509Certificate getTrustedIssuerCertificate(X509Certificate x509Certificate, Date date, HashMap hashMap) {
        Principal principal = X509Util.getIssuerPrincipal(x509Certificate);
        List list = (List)hashMap.get(principal);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedissuercert.find");
            return x509Certificate2;
        }
        return null;
    }

    public static boolean isSigner(Certificate certificate, Certificate certificate2) {
        try {
            certificate.verify(certificate2.getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

