/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.FontUnits;
import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EffectConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.css.parser.CSSLexer;
import com.sun.javafx.css.parser.DeriveColorConverter;
import com.sun.javafx.css.parser.LadderConverter;
import com.sun.javafx.css.parser.StopConverter;
import com.sun.javafx.css.parser.Token;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.layout.region.BackgroundImage;
import com.sun.javafx.scene.layout.region.BorderImage;
import com.sun.javafx.scene.layout.region.BorderStyle;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.Repeat;
import com.sun.javafx.scene.layout.region.StrokeBorder;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class CSSParser {
    static boolean EXIT_ON_ERROR = false;
    private String stylesheetAsText;
    private URL sourceOfStylesheet;
    private Styleable sourceOfInlineStyle;
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final ParsedValue<Size, Size> ZERO_PERCENT;
    private static final ParsedValue<Size, Size> FIFTY_PERCENT;
    private static final ParsedValue<Size, Size> ONE_HUNDRED_PERCENT;
    private static final ParsedValue<ParsedValue<?, Size>[], Double[]> DASHED;
    private static final ParsedValue<ParsedValue<?, Size>[], Double[]> DOTTED;
    private static final ParsedValue<ParsedValue<?, Size>[], Double[]> SOLID;
    private static final ParsedValue<ParsedValue<?, Size>[], Double[]> NONE;
    Token currentToken = null;

    public static CSSParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private CSSParser() {
    }

    private void setInputSource(URL uRL) {
        this.setInputSource(uRL, null);
    }

    private void setInputSource(URL uRL, String string) {
        this.stylesheetAsText = string;
        this.sourceOfStylesheet = uRL;
        this.sourceOfInlineStyle = null;
    }

    private void setInputSource(String string) {
        this.stylesheetAsText = string;
        this.sourceOfStylesheet = null;
        this.sourceOfInlineStyle = null;
    }

    private void setInputSource(Styleable styleable) {
        this.stylesheetAsText = styleable != null ? styleable.getStyle() : null;
        this.sourceOfStylesheet = null;
        this.sourceOfInlineStyle = styleable;
    }

    public Stylesheet parse(String string) {
        Stylesheet stylesheet = new Stylesheet();
        if (string != null && !string.trim().isEmpty()) {
            this.setInputSource(string);
            CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
            this.parse(stylesheet, charArrayReader);
        }
        return stylesheet;
    }

    public Stylesheet parse(String string, String string2) throws IOException {
        URL uRL = new URL(string);
        Stylesheet stylesheet = new Stylesheet(uRL);
        if (string2 != null && !string2.trim().isEmpty()) {
            this.setInputSource(uRL, string2);
            CharArrayReader charArrayReader = new CharArrayReader(string2.toCharArray());
            this.parse(stylesheet, charArrayReader);
        }
        return stylesheet;
    }

    public Stylesheet parse(URL uRL) throws IOException {
        Stylesheet stylesheet = new Stylesheet(uRL);
        if (uRL != null) {
            this.setInputSource(uRL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            this.parse(stylesheet, bufferedReader);
        }
        return stylesheet;
    }

    private void parse(Stylesheet stylesheet, Reader reader) {
        CSSLexer cSSLexer = CSSLexer.getInstance();
        cSSLexer.setReader(reader);
        try {
            this.parse(stylesheet, cSSLexer);
            reader.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    public Stylesheet parseInlineStyle(Styleable styleable) {
        String string;
        Stylesheet stylesheet = new Stylesheet();
        String string2 = string = styleable != null ? styleable.getStyle() : null;
        if (string != null && !string.trim().isEmpty()) {
            this.setInputSource(styleable);
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
            CSSLexer cSSLexer = CSSLexer.getInstance();
            cSSLexer.setReader(charArrayReader);
            try {
                this.currentToken = this.nextToken(cSSLexer);
                List<Declaration> list = this.declarations(cSSLexer);
                if (list != null && !list.isEmpty()) {
                    Selector selector = Selector.getUniversalSelector();
                    Rule rule = new Rule(Collections.singletonList(selector), list);
                    arrayList.add(rule);
                }
                ((Reader)charArrayReader).close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                this.reportException(exception);
            }
            stylesheet.getRules().addAll(arrayList);
        }
        this.setInputSource((Styleable)null);
        return stylesheet;
    }

    public ParsedValue parseExpr(String string, String string2) {
        ParsedValue parsedValue = null;
        try {
            this.setInputSource(null, string + ": " + string2);
            char[] cArray = new char[string2.length() + 1];
            System.arraycopy(string2.toCharArray(), 0, cArray, 0, string2.length());
            cArray[cArray.length - 1] = 59;
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            CSSLexer cSSLexer = CSSLexer.getInstance();
            cSSLexer.setReader(charArrayReader);
            this.currentToken = this.nextToken(cSSLexer);
            Term term = this.expr(cSSLexer);
            parsedValue = this.valueFor(string, term);
            ((Reader)charArrayReader).close();
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
            if (LOGGER.isLoggable(900)) {
                LOGGER.warning("\"" + string + ": " + string2 + "\" " + parseException.toString());
            }
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
        return parsedValue;
    }

    private CssError createError(String string) {
        CssError cssError = null;
        cssError = this.sourceOfStylesheet != null ? new CssError.StylesheetParsingError(this.sourceOfStylesheet, string) : (this.sourceOfInlineStyle != null ? new CssError.InlineStyleParsingError(this.sourceOfInlineStyle, string) : new CssError.StringParsingError(this.stylesheetAsText, string));
        return cssError;
    }

    private void reportError(CssError cssError) {
        ObservableList<CssError> observableList = null;
        observableList = StyleManager.getInstance().getErrors();
        if (observableList != null) {
            observableList.add(cssError);
        }
    }

    private void error(Term term, String string) throws ParseException {
        Token token = term != null ? term.token : null;
        ParseException parseException = new ParseException(string, token, this);
        this.reportError(this.createError(parseException.toString()));
        throw parseException;
    }

    private void reportException(Exception exception) {
        StackTraceElement[] stackTraceElementArray;
        if (LOGGER.isLoggable(900) && (stackTraceElementArray = exception.getStackTrace()).length > 0) {
            StringBuilder stringBuilder = new StringBuilder("Please report ");
            stringBuilder.append(exception.getClass().getName()).append(" at:");
            int n = 0;
            while (n < stackTraceElementArray.length && this.getClass().getName().equals(stackTraceElementArray[n].getClassName())) {
                stringBuilder.append("\n\t").append(stackTraceElementArray[n++].toString());
            }
            LOGGER.warning(stringBuilder.toString());
        }
    }

    private String formatDeprecatedMessage(Term term, String string) {
        StringBuilder stringBuilder = new StringBuilder("Using deprecated syntax for ");
        stringBuilder.append(string);
        if (this.sourceOfStylesheet != null) {
            stringBuilder.append(" at ").append(this.sourceOfStylesheet).append("[").append(term.token.getLine()).append(',').append(term.token.getOffset()).append("]");
        }
        stringBuilder.append(". Refer to the CSS Reference Guide.");
        return stringBuilder.toString();
    }

    private ParsedValue<Color, Color> colorValueOfString(String string) {
        if (string.startsWith("#") || string.startsWith("0x")) {
            double d = 1.0;
            String string2 = string;
            int n = string.startsWith("#") ? 1 : 2;
            int n2 = string2.length();
            if (n2 - n == 4) {
                d = (float)Integer.parseInt(string2.substring(n2 - 1), 16) / 15.0f;
                string2 = string2.substring(0, n2 - 1);
            } else if (n2 - n == 8) {
                d = (float)Integer.parseInt(string2.substring(n2 - 2), 16) / 255.0f;
                string2 = string2.substring(0, n2 - 2);
            }
            return new ParsedValue<Color, Color>(Color.web(string2, d), null);
        }
        try {
            return new ParsedValue<Color, Color>(Color.web(string), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private String stripQuotes(String string) {
        return Utils.stripQuotes(string);
    }

    private double clamp(double d, double d2, double d3) {
        if (d2 < d) {
            return d;
        }
        if (d3 < d2) {
            return d3;
        }
        return d2;
    }

    private boolean isSize(Token token) {
        int n = token.getType();
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return token.getType() == 11;
    }

    private Size size(Token token) throws ParseException {
        SizeUnits sizeUnits = SizeUnits.PX;
        int n = 2;
        String string = token.getText().trim();
        int n2 = string.length();
        int n3 = token.getType();
        switch (n3) {
            case 13: {
                sizeUnits = SizeUnits.PX;
                n = 0;
                break;
            }
            case 22: {
                sizeUnits = SizeUnits.PERCENT;
                n = 1;
                break;
            }
            case 15: {
                sizeUnits = SizeUnits.EM;
                break;
            }
            case 16: {
                sizeUnits = SizeUnits.EX;
                break;
            }
            case 21: {
                sizeUnits = SizeUnits.PX;
                break;
            }
            case 14: {
                sizeUnits = SizeUnits.CM;
                break;
            }
            case 18: {
                sizeUnits = SizeUnits.MM;
                break;
            }
            case 17: {
                sizeUnits = SizeUnits.IN;
                break;
            }
            case 20: {
                sizeUnits = SizeUnits.PT;
                break;
            }
            case 19: {
                sizeUnits = SizeUnits.PC;
                break;
            }
            case 23: {
                sizeUnits = SizeUnits.DEG;
                n = 3;
                break;
            }
            case 24: {
                sizeUnits = SizeUnits.GRAD;
                n = 4;
                break;
            }
            case 25: {
                sizeUnits = SizeUnits.RAD;
                n = 3;
                break;
            }
            case 26: {
                sizeUnits = SizeUnits.TURN;
                n = 5;
                break;
            }
            default: {
                if (LOGGER.isLoggable(300)) {
                    LOGGER.finest("Expected '<number>'");
                }
                ParseException parseException = new ParseException("Expected '<number>'", token, this);
                this.reportError(this.createError(parseException.toString()));
                throw parseException;
            }
        }
        return new Size(Double.parseDouble(string.substring(0, n2 - n)), sizeUnits);
    }

    private int numberOfTerms(Term term) {
        if (term == null) {
            return 0;
        }
        int n = 0;
        Term term2 = term;
        do {
            ++n;
        } while ((term2 = term2.nextInSeries) != null);
        return n;
    }

    private int numberOfLayers(Term term) {
        if (term == null) {
            return 0;
        }
        int n = 0;
        Term term2 = term;
        do {
            ++n;
            while (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
            }
        } while ((term2 = term2.nextLayer) != null);
        return n;
    }

    private int numberOfArgs(Term term) {
        if (term == null) {
            return 0;
        }
        int n = 0;
        Term term2 = term.firstArg;
        while (term2 != null) {
            ++n;
            term2 = term2.nextArg;
        }
        return n;
    }

    private Term nextLayer(Term term) {
        if (term == null) {
            return null;
        }
        Term term2 = term;
        while (term2.nextInSeries != null) {
            term2 = term2.nextInSeries;
        }
        return term2.nextLayer;
    }

    ParsedValue valueFor(String string, Term term) throws ParseException {
        String string2 = string.toLowerCase();
        this.properties.put(string2, string2);
        if (term == null || term.token == null) {
            this.error(term, "Expected value for property '" + string2 + "'");
        }
        if (term.token.getType() == 11) {
            if ("inherit".equalsIgnoreCase(term.token.getText())) {
                return new ParsedValue("inherit", null);
            }
            if ("null".equalsIgnoreCase(term.token.getText())) {
                return new ParsedValue("null", null);
            }
        }
        if ("-fx-background-color".equals(string)) {
            return this.parsePaintLayers(term);
        }
        if ("-fx-background-image".equals(string2)) {
            return this.parseURILayers(term);
        }
        if ("-fx-background-insets".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-background-position".equals(string2)) {
            return this.parseBackgroundPositionLayers(term);
        }
        if ("-fx-background-radius".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-background-repeat".equals(string2)) {
            return this.parseBackgroundRepeatStyleLayers(term);
        }
        if ("-fx-background-size".equals(string2)) {
            return this.parseBackgroundSizeLayers(term);
        }
        if ("-fx-border-color".equals(string2)) {
            return this.parseBorderPaintLayers(term);
        }
        if ("-fx-border-insets".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-border-radius".equals(string2)) {
            return this.parseMarginsLayers(term);
        }
        if ("-fx-border-style".equals(string2)) {
            return this.parseBorderStyleLayers(term);
        }
        if ("-fx-border-width".equals(string2)) {
            return this.parseMarginsLayers(term);
        }
        if ("-fx-border-image-insets".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-border-image-repeat".equals(string2)) {
            return this.parseBorderImageRepeatStyleLayers(term);
        }
        if ("-fx-border-image-slice".equals(string2)) {
            return this.parseBorderImageSliceLayers(term);
        }
        if ("-fx-border-image-source".equals(string2)) {
            return this.parseURILayers(term);
        }
        if ("-fx-border-image-width".equals(string2)) {
            return this.parseMarginsLayers(term);
        }
        if ("-fx-padding".equals(string2)) {
            ParsedValue<?, Size>[] parsedValueArray = this.parseSizeSeries(term);
            return new ParsedValue<ParsedValue<?, Size>[], Insets>(parsedValueArray, InsetsConverter.getInstance());
        }
        if ("-fx-label-padding".equals(string2)) {
            ParsedValue<?, Size>[] parsedValueArray = this.parseSizeSeries(term);
            return new ParsedValue<ParsedValue<?, Size>[], Insets>(parsedValueArray, InsetsConverter.getInstance());
        }
        if (string2.endsWith("font-family")) {
            return this.parseFontFamily(term);
        }
        if (string2.endsWith("font-size")) {
            ParsedValue<ParsedValue<?, Size>, Double> parsedValue = this.parseFontSize(term);
            if (parsedValue == null) {
                this.error(term, "Expected '<font-size>'");
            }
            return parsedValue;
        }
        if (string2.endsWith("font-style")) {
            ParsedValue<FontUnits.Style, FontPosture> parsedValue = this.parseFontStyle(term);
            if (parsedValue == null) {
                this.error(term, "Expected '<font-style>'");
            }
            return parsedValue;
        }
        if (string2.endsWith("font-weight")) {
            ParsedValue<FontUnits.Weight, FontWeight> parsedValue = this.parseFontWeight(term);
            if (parsedValue == null) {
                this.error(term, "Expected '<font-style>'");
            }
            return parsedValue;
        }
        if (string2.endsWith("font")) {
            return this.parseFont(term);
        }
        if ("-fx-stroke-dash-array".equals(string2)) {
            Term term2 = term;
            int n = this.numberOfTerms(term2);
            ParsedValue[] parsedValueArray = new ParsedValue[n];
            int n2 = 0;
            while (term2 != null) {
                parsedValueArray[n2++] = this.parseSize(term2);
                term2 = term2.nextInSeries;
            }
            return new ParsedValue<ParsedValue<?, Size>[], Double[]>(parsedValueArray, SizeConverter.SequenceConverter.getInstance());
        }
        if ("-fx-stroke-line-join".equals(string2)) {
            ParsedValue[] parsedValueArray = this.parseStrokeLineJoin(term);
            if (parsedValueArray == null) {
                this.error(term, "Expected 'miter', 'bevel' or 'round'");
            }
            return parsedValueArray[0];
        }
        if ("-fx-stroke-line-cap".equals(string2)) {
            ParsedValue<String, StrokeLineCap> parsedValue = this.parseStrokeLineCap(term);
            if (parsedValue == null) {
                this.error(term, "Expected 'square', 'butt' or 'round'");
            }
            return parsedValue;
        }
        if ("-fx-stroke-type".equals(string2)) {
            ParsedValue<String, StrokeType> parsedValue = this.parseStrokeType(term);
            if (parsedValue == null) {
                this.error(term, "Expected 'centered', 'inside' or 'outside'");
            }
            return parsedValue;
        }
        if ("-fx-font-smoothing-type".equals(string2)) {
            String string3 = null;
            int n = -1;
            Token token = term.token;
            if (term.token == null || (n = term.token.getType()) != 10 && n != 11 || (string3 = term.token.getText()) == null || string3.isEmpty()) {
                this.error(term, "Expected STRING or IDENT");
            }
            return new ParsedValue(this.stripQuotes(string3), null, false);
        }
        return this.parse(term);
    }

    private ParsedValue parse(Term term) throws ParseException {
        if (term.token == null) {
            this.error(term, "Parse error");
        }
        Token token = term.token;
        ParsedValue<Object, Object> parsedValue = null;
        int n = token.getType();
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                ParsedValue parsedValue2 = new ParsedValue(this.size(token), null);
                parsedValue = new ParsedValue(parsedValue2, SizeConverter.getInstance());
                break;
            }
            case 10: 
            case 11: {
                boolean bl;
                boolean bl2 = n == 11;
                String string = this.stripQuotes(token.getText());
                String string2 = string.toLowerCase();
                if ("ladder".equals(string2)) {
                    parsedValue = this.ladder(term);
                    break;
                }
                if ("linear".equals(string2)) {
                    parsedValue = this.linearGradient(term);
                    break;
                }
                if ("radial".equals(string2)) {
                    parsedValue = this.radialGradient(term);
                    break;
                }
                if ("true".equals(string2)) {
                    parsedValue = new ParsedValue<String, Boolean>("true", BooleanConverter.getInstance());
                    break;
                }
                if ("false".equals(string2)) {
                    parsedValue = new ParsedValue<String, Boolean>("false", BooleanConverter.getInstance());
                    break;
                }
                boolean bl3 = bl = bl2 && this.properties.containsKey(string);
                if (!bl && (parsedValue = this.colorValueOfString(string)) != null) break;
                parsedValue = new ParsedValue(string, null, bl2 || bl);
                break;
            }
            case 37: {
                String string = token.getText();
                try {
                    parsedValue = new ParsedValue(Color.web(string), null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.error(term, illegalArgumentException.getMessage());
                }
                break;
            }
            case 12: {
                return this.parseFunction(term);
            }
            default: {
                String string = "Unknown token type: '" + n + "'";
                this.error(term, string);
            }
        }
        return parsedValue;
    }

    private ParsedValue<?, Size> parseSize(Term term) throws ParseException {
        if (term.token == null || !this.isSize(term.token)) {
            this.error(term, "Expected '<size>'");
        }
        ParsedValue parsedValue = null;
        if (term.token.getType() != 11) {
            Size size = this.size(term.token);
            parsedValue = new ParsedValue(size, null);
        } else {
            String string = term.token.getText();
            parsedValue = new ParsedValue(string, null, true);
        }
        return parsedValue;
    }

    private ParsedValue<?, Color> parseColor(Term term) throws ParseException {
        ParsedValue parsedValue = null;
        if (term.token != null && (term.token.getType() == 11 || term.token.getType() == 37 || term.token.getType() == 12)) {
            parsedValue = this.parse(term);
        } else {
            this.error(term, "Expected '<color>'");
        }
        return parsedValue;
    }

    private ParsedValue rgb(Term term) throws ParseException {
        int n;
        Token token;
        Token token2;
        Token token3;
        Token token4;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"rgb".regionMatches(true, 0, string, 0, 3)) {
            this.error(term, "Expected 'rgb' or 'rgba'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>' or '<percentage>'");
        }
        if ((token4 = term2.token) == null || token4.getType() != 13 && token4.getType() != 22) {
            this.error(term2, "Expected '<number>' or '<percentage>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>' or '<percentage>'");
        }
        if ((token3 = term2.token) == null || token3.getType() != 13 && token3.getType() != 22) {
            this.error(term2, "Expected '<number>' or '<percentage>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>' or '<percentage>'");
        }
        if ((token2 = term2.token) == null || token2.getType() != 13 && token2.getType() != 22) {
            this.error(term2, "Expected '<number>' or '<percentage>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 != null) {
            token = term2.token;
            if (token == null || token.getType() != 13) {
                this.error(term2, "Expected '<number>'");
            }
        } else {
            token = null;
        }
        if ((n = token4.getType()) != token3.getType() || n != token2.getType() || n != 13 && n != 22) {
            this.error(term, "Argument type mistmatch");
        }
        String string3 = token4.getText();
        String string4 = token3.getText();
        String string5 = token2.getText();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n == 13) {
            d = this.clamp(0.0, Double.parseDouble(string3) / 255.0, 1.0);
            d2 = this.clamp(0.0, Double.parseDouble(string4) / 255.0, 1.0);
            d3 = this.clamp(0.0, Double.parseDouble(string5) / 255.0, 1.0);
        } else {
            d = this.clamp(0.0, Double.parseDouble(string3.substring(0, string3.length() - 1)) / 100.0, 1.0);
            d2 = this.clamp(0.0, Double.parseDouble(string4.substring(0, string4.length() - 1)) / 100.0, 1.0);
            d3 = this.clamp(0.0, Double.parseDouble(string5.substring(0, string5.length() - 1)) / 100.0, 1.0);
        }
        String string6 = token != null ? token.getText() : null;
        double d4 = string6 != null ? this.clamp(0.0, Double.parseDouble(string6), 1.0) : 1.0;
        return new ParsedValue(Color.color(d, d2, d3, d4), null);
    }

    private ParsedValue hsb(Term term) throws ParseException {
        Token token;
        Token token2;
        Token token3;
        Token token4;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"hsb".regionMatches(true, 0, string, 0, 3)) {
            this.error(term, "Expected 'hsb' or 'hsba'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>'");
        }
        if ((token4 = term2.token) == null || token4.getType() != 13) {
            this.error(term2, "Expected '<number>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<percent>'");
        }
        if ((token3 = term2.token) == null || token3.getType() != 22) {
            this.error(term2, "Expected '<percent>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<percent>'");
        }
        if ((token2 = term2.token) == null || token2.getType() != 22) {
            this.error(term2, "Expected '<percent>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 != null) {
            token = term2.token;
            if (token == null || token.getType() != 13) {
                this.error(term2, "Expected '<number>'");
            }
        } else {
            token = null;
        }
        Size size = this.size(token4);
        Size size2 = this.size(token3);
        Size size3 = this.size(token2);
        double d = size.pixels();
        double d2 = this.clamp(0.0, size2.pixels(), 1.0);
        double d3 = this.clamp(0.0, size3.pixels(), 1.0);
        Size size4 = token != null ? this.size(token) : null;
        double d4 = size4 != null ? this.clamp(0.0, size4.pixels(), 1.0) : 1.0;
        return new ParsedValue(Color.hsb(d, d2, d3, d4), null);
    }

    private ParsedValue<ParsedValue[], Color> derive(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"derive".regionMatches(true, 0, string, 0, 6)) {
            this.error(term, "Expected 'derive'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<color>'");
        }
        ParsedValue<?, Color> parsedValue = this.parseColor(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<percent'");
        }
        ParsedValue<?, Size> parsedValue2 = this.parseSize(term2);
        ParsedValue[] parsedValueArray = new ParsedValue[]{parsedValue, parsedValue2};
        return new ParsedValue<ParsedValue[], Color>(parsedValueArray, DeriveColorConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Color> ladder(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"ladder".regionMatches(true, 0, string, 0, 6)) {
            this.error(term, "Expected 'ladder'");
        }
        if (LOGGER.isLoggable(900)) {
            LOGGER.warning(this.formatDeprecatedMessage(term, "ladder"));
        }
        Term term2 = term;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term, "Expected '<color>'");
        }
        ParsedValue parsedValue = this.parse(term2);
        Term term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'stops'");
        }
        if (term2.token == null || term2.token.getType() != 11 || !"stops".equalsIgnoreCase(term2.token.getText())) {
            this.error(term2, "Expected 'stops'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <color>)'");
        }
        int n = 0;
        Term term4 = term2;
        do {
            ++n;
        } while ((term4 = term4.nextInSeries) != null && term4.token != null && term4.token.getType() == 34);
        ParsedValue[] parsedValueArray = new ParsedValue[n + 1];
        parsedValueArray[0] = parsedValue;
        int n2 = 1;
        do {
            ParsedValue<ParsedValue[], Stop> parsedValue2;
            if ((parsedValue2 = this.stop(term2)) != null) {
                parsedValueArray[n2++] = parsedValue2;
            }
            term3 = term2;
        } while ((term2 = term2.nextInSeries) != null && term2.token.getType() == 34);
        if (term2 != null) {
            term.nextInSeries = term2;
        } else {
            term.nextInSeries = null;
            term.nextLayer = term3.nextLayer;
        }
        return new ParsedValue<ParsedValue[], Color>(parsedValueArray, LadderConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Color> parseLadder(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"ladder".regionMatches(true, 0, string, 0, 6)) {
            this.error(term, "Expected 'ladder'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<color>'");
        }
        ParsedValue parsedValue = this.parse(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color-stop>[, <color-stop>]+'");
        }
        ParsedValue<ParsedValue[], Stop>[] parsedValueArray = this.parseColorStops(term2);
        ParsedValue[] parsedValueArray2 = new ParsedValue[parsedValueArray.length + 1];
        parsedValueArray2[0] = parsedValue;
        System.arraycopy(parsedValueArray, 0, parsedValueArray2, 1, parsedValueArray.length);
        return new ParsedValue<ParsedValue[], Color>(parsedValueArray2, LadderConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Stop> stop(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"(".equals(string)) {
            this.error(term, "Expected '('");
        }
        Term term2 = null;
        term2 = term.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue = this.parseSize(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color>'");
        }
        ParsedValue<?, Color> parsedValue2 = this.parseColor(term2);
        ParsedValue[] parsedValueArray = new ParsedValue[]{parsedValue, parsedValue2};
        return new ParsedValue<ParsedValue[], Stop>(parsedValueArray, StopConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Stop>[] parseColorStops(Term term) throws ParseException {
        int n = 1;
        Term term2 = term;
        while (term2 != null) {
            if (term2.nextArg != null) {
                ++n;
                term2 = term2.nextArg;
                continue;
            }
            if (term2.nextInSeries == null) break;
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            this.error(term, "Expected '<color-stop>'");
        }
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        Object[] objectArray = new Size[n];
        Arrays.fill(objectArray, null);
        Term term3 = term;
        Term term4 = term;
        Object var8_8 = null;
        for (int i = 0; i < n; ++i) {
            parsedValueArray[i] = this.parseColor(term3);
            term4 = term3;
            Term term5 = term3.nextInSeries;
            if (term5 != null) {
                if (this.isSize(term5.token)) {
                    objectArray[i] = this.size(term5.token);
                    if (var8_8 != null && var8_8 != ((Size)objectArray[i]).getUnits()) {
                        this.error(term5, "Parser unable to handle mixed '<percent>' and '<length>'");
                    }
                } else {
                    this.error(term4, "Expected '<percent>' or '<length>'");
                }
                term4 = term5;
                term3 = term5.nextArg;
                continue;
            }
            term4 = term3;
            term3 = term3.nextArg;
        }
        if (objectArray[0] == null) {
            objectArray[0] = new Size(0.0, SizeUnits.PERCENT);
        }
        if (objectArray[n - 1] == null) {
            objectArray[n - 1] = new Size(100.0, SizeUnits.PERCENT);
        }
        Object object = null;
        for (int i = 1; i < n; ++i) {
            Object object2;
            Object object3 = objectArray[i - 1];
            if (object3 == null) continue;
            if (object == null || ((Size)object).getValue() < ((Size)object3).getValue()) {
                object = object3;
            }
            if ((object2 = objectArray[i]) == null || !(((Size)object2).getValue() < ((Size)object).getValue())) continue;
            objectArray[i] = object;
        }
        Object object4 = null;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Object object5 = objectArray[i];
            if (object5 == null) {
                if (n2 != -1) continue;
                n2 = i;
                continue;
            }
            if (n2 > -1) {
                int n3 = i - n2;
                double d = ((Size)object4).getValue();
                double d2 = (((Size)object5).getValue() - d) / (double)(n3 + 1);
                while (n2 < i) {
                    objectArray[n2++] = new Size(d += d2, ((Size)object5).getUnits());
                }
                n2 = -1;
                object4 = object5;
                continue;
            }
            object4 = object5;
        }
        ParsedValue[] parsedValueArray2 = new ParsedValue[n];
        for (int i = 0; i < n; ++i) {
            parsedValueArray2[i] = new ParsedValue<ParsedValue[], Stop>(new ParsedValue[]{new ParsedValue(objectArray[i], null), parsedValueArray[i]}, StopConverter.getInstance());
        }
        return parsedValueArray2;
    }

    private ParsedValue[] point(Term term) throws ParseException {
        String string;
        if (term.token == null || term.token.getType() != 34) {
            this.error(term, "Expected '(<number>, <number>)'");
        }
        if ((string = term.token.getText()) == null || !"(".equalsIgnoreCase(string)) {
            this.error(term, "Expected '('");
        }
        Term term2 = null;
        term2 = term.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue = this.parseSize(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue2 = this.parseSize(term2);
        return new ParsedValue[]{parsedValue, parsedValue2};
    }

    private ParsedValue parseFunction(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null) {
            this.error(term, "Expected function name");
        } else {
            if ("rgb".regionMatches(true, 0, string, 0, 3)) {
                return this.rgb(term);
            }
            if ("hsb".regionMatches(true, 0, string, 0, 3)) {
                return this.hsb(term);
            }
            if ("derive".regionMatches(true, 0, string, 0, 6)) {
                return this.derive(term);
            }
            if ("innershadow".regionMatches(true, 0, string, 0, 11)) {
                return this.innershadow(term);
            }
            if ("dropshadow".regionMatches(true, 0, string, 0, 10)) {
                return this.dropshadow(term);
            }
            if ("linear-gradient".regionMatches(true, 0, string, 0, 15)) {
                return this.parseLinearGradient(term);
            }
            if ("radial-gradient".regionMatches(true, 0, string, 0, 15)) {
                return this.parseRadialGradient(term);
            }
            if ("ladder".regionMatches(true, 0, string, 0, 6)) {
                return this.parseLadder(term);
            }
            if ("url".regionMatches(true, 0, string, 0, 3)) {
                return this.parseURI(term);
            }
            this.error(term, "Unexpected function '" + string + "'");
        }
        return null;
    }

    private ParsedValue<BlurType, BlurType> blurType(Term term) throws ParseException {
        if (term == null) {
            return null;
        }
        if (term.token == null || term.token.getType() != 11 || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        String string = term.token.getText().toLowerCase();
        BlurType blurType = BlurType.THREE_PASS_BOX;
        if ("gaussian".equals(string)) {
            blurType = BlurType.GAUSSIAN;
        } else if ("one-pass-box".equals(string)) {
            blurType = BlurType.ONE_PASS_BOX;
        } else if ("two-pass-box".equals(string)) {
            blurType = BlurType.TWO_PASS_BOX;
        } else if ("three-pass-box".equals(string)) {
            blurType = BlurType.THREE_PASS_BOX;
        } else {
            this.error(term, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        return new ParsedValue<BlurType, BlurType>(blurType, null);
    }

    private ParsedValue innershadow(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"innershadow".regionMatches(true, 0, string, 0, 11)) {
            this.error(term, "Expected 'innershadow'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term, "Expected '<blur-type>'");
        }
        ParsedValue<BlurType, BlurType> parsedValue = this.blurType(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color>'");
        }
        ParsedValue<?, Color> parsedValue2 = this.parseColor(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue3 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue4 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue5 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue6 = this.parseSize(term2);
        ParsedValue[] parsedValueArray = new ParsedValue[]{parsedValue, parsedValue2, parsedValue3, parsedValue4, parsedValue5, parsedValue6};
        return new ParsedValue<ParsedValue[], Effect>(parsedValueArray, EffectConverter.InnerShadowConverter.getInstance());
    }

    private ParsedValue dropshadow(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"dropshadow".regionMatches(true, 0, string, 0, 10)) {
            this.error(term, "Expected 'dropshadow'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term, "Expected '<blur-type>'");
        }
        ParsedValue<BlurType, BlurType> parsedValue = this.blurType(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color>'");
        }
        ParsedValue<?, Color> parsedValue2 = this.parseColor(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue3 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue4 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue5 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        ParsedValue<?, Size> parsedValue6 = this.parseSize(term2);
        ParsedValue[] parsedValueArray = new ParsedValue[]{parsedValue, parsedValue2, parsedValue3, parsedValue4, parsedValue5, parsedValue6};
        return new ParsedValue<ParsedValue[], Effect>(parsedValueArray, EffectConverter.DropShadowConverter.getInstance());
    }

    private ParsedValue<CycleMethod, CycleMethod> cycleMethod(Term term) {
        CycleMethod cycleMethod = null;
        if (term != null && term.token.getType() == 11) {
            String string = term.token.getText().toLowerCase();
            if ("repeat".equals(string)) {
                cycleMethod = CycleMethod.REPEAT;
            } else if ("reflect".equals(string)) {
                cycleMethod = CycleMethod.REFLECT;
            } else if ("no-cycle".equals(string)) {
                cycleMethod = CycleMethod.NO_CYCLE;
            }
        }
        if (cycleMethod != null) {
            return new ParsedValue(cycleMethod, null);
        }
        return null;
    }

    private ParsedValue<ParsedValue[], Paint> linearGradient(Term term) throws ParseException {
        ParsedValue<Object, Object> parsedValue;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"linear".equalsIgnoreCase(string)) {
            this.error(term, "Expected 'linear'");
        }
        if (LOGGER.isLoggable(900)) {
            LOGGER.warning(this.formatDeprecatedMessage(term, "linear gradient"));
        }
        Term term2 = term;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term, "Expected '(<number>, <number>)'");
        }
        ParsedValue[] parsedValueArray = this.point(term2);
        Term term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'to'");
        }
        if (term2.token == null || term2.token.getType() != 11 || !"to".equalsIgnoreCase(term2.token.getText())) {
            this.error(term, "Expected 'to'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <number>)'");
        }
        ParsedValue[] parsedValueArray2 = this.point(term2);
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'stops'");
        }
        if (term2.token == null || term2.token.getType() != 11 || !"stops".equalsIgnoreCase(term2.token.getText())) {
            this.error(term2, "Expected 'stops'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <number>)'");
        }
        int n = 0;
        Term term4 = term2;
        do {
            ++n;
        } while ((term4 = term4.nextInSeries) != null && term4.token != null && term4.token.getType() == 34);
        ParsedValue[] parsedValueArray3 = new ParsedValue[n];
        int n2 = 0;
        do {
            if ((parsedValue = this.stop(term2)) != null) {
                parsedValueArray3[n2++] = parsedValue;
            }
            term3 = term2;
        } while ((term2 = term2.nextInSeries) != null && term2.token.getType() == 34);
        parsedValue = this.cycleMethod(term2);
        if (parsedValue == null) {
            parsedValue = new ParsedValue(CycleMethod.NO_CYCLE, null);
            if (term2 != null) {
                term.nextInSeries = term2;
            } else {
                term.nextInSeries = null;
                term.nextLayer = term3.nextLayer;
            }
        } else {
            term.nextInSeries = term2.nextInSeries;
            term.nextLayer = term2.nextLayer;
        }
        ParsedValue[] parsedValueArray4 = new ParsedValue[5 + parsedValueArray3.length];
        int n3 = 0;
        parsedValueArray4[n3++] = parsedValueArray != null ? parsedValueArray[0] : null;
        parsedValueArray4[n3++] = parsedValueArray != null ? parsedValueArray[1] : null;
        parsedValueArray4[n3++] = parsedValueArray2 != null ? parsedValueArray2[0] : null;
        parsedValueArray4[n3++] = parsedValueArray2 != null ? parsedValueArray2[1] : null;
        parsedValueArray4[n3++] = parsedValue;
        for (int i = 0; i < parsedValueArray3.length; ++i) {
            parsedValueArray4[n3++] = parsedValueArray3[i];
        }
        return new ParsedValue<ParsedValue[], Paint>(parsedValueArray4, PaintConverter.LinearGradientConverter.getInstance());
    }

    private ParsedValue parseLinearGradient(Term term) throws ParseException {
        int n;
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"linear-gradient".regionMatches(true, 0, string, 0, 15)) {
            this.error(term, "Expected 'linear-gradient'");
        }
        if ((term2 = term.firstArg) == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term, "Expected 'from <point> to <point>' or 'to <side-or-corner>' or '<cycle-method>' or '<color-stop>'");
        }
        Term term3 = term2;
        ParsedValue[] parsedValueArray = null;
        ParsedValue[] parsedValueArray2 = null;
        if ("from".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            ParsedValue<?, Size> parsedValue = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            ParsedValue<?, Size> parsedValue2 = this.parseSize(term2);
            parsedValueArray = new ParsedValue[]{parsedValue, parsedValue2};
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected 'to'");
            }
            if (term2.token == null || term2.token.getType() != 11 || !"to".equalsIgnoreCase(term2.token.getText())) {
                this.error(term3, "Expected 'to'");
            }
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            parsedValue = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            parsedValue2 = this.parseSize(term2);
            parsedValueArray2 = new ParsedValue[]{parsedValue, parsedValue2};
            term3 = term2;
            term2 = term2.nextArg;
        } else if ("to".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || term2.token == null | term2.token.getType() != 11 || term2.token.getText().isEmpty()) {
                this.error(term3, "Expected '<side-or-corner>'");
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = 0;
            String string3 = term2.token.getText().toLowerCase();
            if ("top".equals(string3)) {
                n3 = 100;
                n = 0;
            } else if ("bottom".equals(string3)) {
                n3 = 0;
                n = 100;
            } else if ("right".equals(string3)) {
                n2 = 0;
                n4 = 100;
            } else if ("left".equals(string3)) {
                n2 = 100;
                n4 = 0;
            } else {
                this.error(term2, "Invalid '<side-or-corner>'");
            }
            term3 = term2;
            if (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
                if (term2.token != null && term2.token.getType() == 11 && !term2.token.getText().isEmpty()) {
                    String string4 = term2.token.getText().toLowerCase();
                    if ("right".equals(string4) && n2 == 0 && n4 == 0) {
                        n2 = 0;
                        n4 = 100;
                    } else if ("left".equals(string4) && n2 == 0 && n4 == 0) {
                        n2 = 100;
                        n4 = 0;
                    } else if ("top".equals(string4) && n3 == 0 && n == 0) {
                        n3 = 100;
                        n = 0;
                    } else if ("bottom".equals(string4) && n3 == 0 && n == 0) {
                        n3 = 0;
                        n = 100;
                    } else {
                        this.error(term2, "Invalid '<side-or-corner>'");
                    }
                } else {
                    this.error(term3, "Expected '<side-or-corner>'");
                }
            }
            parsedValueArray = new ParsedValue[]{new ParsedValue(new Size(n2, SizeUnits.PERCENT), null), new ParsedValue(new Size(n3, SizeUnits.PERCENT), null)};
            parsedValueArray2 = new ParsedValue[]{new ParsedValue(new Size(n4, SizeUnits.PERCENT), null), new ParsedValue(new Size(n, SizeUnits.PERCENT), null)};
            term3 = term2;
            term2 = term2.nextArg;
        }
        if (parsedValueArray == null && parsedValueArray2 == null) {
            parsedValueArray = new ParsedValue[]{new ParsedValue(new Size(0.0, SizeUnits.PERCENT), null), new ParsedValue(new Size(0.0, SizeUnits.PERCENT), null)};
            parsedValueArray2 = new ParsedValue[]{new ParsedValue(new Size(0.0, SizeUnits.PERCENT), null), new ParsedValue(new Size(100.0, SizeUnits.PERCENT), null)};
        }
        if (term2 == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term3, "Expected '<cycle-method>' or '<color-stop>'");
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(term2.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        } else if ("repeat".equalsIgnoreCase(term2.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        }
        if (term2 == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term3, "Expected '<color-stop>'");
        }
        ParsedValue<ParsedValue[], Stop>[] parsedValueArray3 = this.parseColorStops(term2);
        ParsedValue[] parsedValueArray4 = new ParsedValue[5 + parsedValueArray3.length];
        n = 0;
        parsedValueArray4[n++] = parsedValueArray != null ? parsedValueArray[0] : null;
        parsedValueArray4[n++] = parsedValueArray != null ? parsedValueArray[1] : null;
        parsedValueArray4[n++] = parsedValueArray2 != null ? parsedValueArray2[0] : null;
        parsedValueArray4[n++] = parsedValueArray2 != null ? parsedValueArray2[1] : null;
        parsedValueArray4[n++] = new ParsedValue(cycleMethod, null);
        for (int i = 0; i < parsedValueArray3.length; ++i) {
            parsedValueArray4[n++] = parsedValueArray3[i];
        }
        return new ParsedValue<ParsedValue[], Paint>(parsedValueArray4, PaintConverter.LinearGradientConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Paint> radialGradient(Term term) throws ParseException {
        ParsedValue<Object, Object> parsedValue;
        Object object;
        ParsedValue[] parsedValueArray;
        Object object2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"radial".equalsIgnoreCase(string)) {
            this.error(term, "Expected 'radial'");
        }
        if (LOGGER.isLoggable(900)) {
            LOGGER.warning(this.formatDeprecatedMessage(term, "radial gradient"));
        }
        Term term2 = term;
        Term term3 = term;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        if (term2.token == null) {
            this.error(term2, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        ParsedValue<?, Size> parsedValue2 = null;
        if (term2.token.getType() == 11 && "focus-angle".equals(object2 = term2.token.getText().toLowerCase())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<number>'");
            }
            if (term2.token == null) {
                this.error(term3, "Expected '<number>'");
            }
            parsedValue2 = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
            if (term2.token == null) {
                this.error(term2, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
        }
        object2 = null;
        if (term2.token.getType() == 11 && "focus-distance".equals(parsedValueArray = term2.token.getText().toLowerCase())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<number>'");
            }
            if (term2.token == null) {
                this.error(term3, "Expected '<number>'");
            }
            object2 = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected  'center (<number>,<number>)' or '<size>'");
            }
            if (term2.token == null) {
                this.error(term2, "Expected  'center (<number>,<number>)' or '<size>'");
            }
        }
        parsedValueArray = null;
        if (term2.token.getType() == 11 && "center".equals(object = term2.token.getText().toLowerCase())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '(<number>,<number>)'");
            }
            if (term2.token == null || term2.token.getType() != 34) {
                this.error(term2, "Expected '(<number>,<number>)'");
            }
            parsedValueArray = this.point(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<size>'");
            }
            if (term2.token == null) {
                this.error(term2, "Expected '<size>'");
            }
        }
        object = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'stops' keyword");
        }
        if (term2.token == null || term2.token.getType() != 11) {
            this.error(term2, "Expected 'stops' keyword");
        }
        if (!"stops".equalsIgnoreCase(term2.token.getText())) {
            this.error(term2, "Expected 'stops'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <number>)'");
        }
        int n = 0;
        Term term4 = term2;
        do {
            ++n;
        } while ((term4 = term4.nextInSeries) != null && term4.token != null && term4.token.getType() == 34);
        ParsedValue[] parsedValueArray2 = new ParsedValue[n];
        int n2 = 0;
        do {
            if ((parsedValue = this.stop(term2)) != null) {
                parsedValueArray2[n2++] = parsedValue;
            }
            term3 = term2;
        } while ((term2 = term2.nextInSeries) != null && term2.token.getType() == 34);
        parsedValue = this.cycleMethod(term2);
        if (parsedValue == null) {
            parsedValue = new ParsedValue(CycleMethod.NO_CYCLE, null);
            if (term2 != null) {
                term.nextInSeries = term2;
            } else {
                term.nextInSeries = null;
                term.nextLayer = term3.nextLayer;
            }
        } else {
            term.nextInSeries = term2.nextInSeries;
            term.nextLayer = term2.nextLayer;
        }
        ParsedValue[] parsedValueArray3 = new ParsedValue[6 + parsedValueArray2.length];
        int n3 = 0;
        parsedValueArray3[n3++] = parsedValue2;
        parsedValueArray3[n3++] = object2;
        parsedValueArray3[n3++] = parsedValueArray != null ? parsedValueArray[0] : null;
        parsedValueArray3[n3++] = parsedValueArray != null ? parsedValueArray[1] : null;
        parsedValueArray3[n3++] = object;
        parsedValueArray3[n3++] = parsedValue;
        for (int i = 0; i < parsedValueArray2.length; ++i) {
            parsedValueArray3[n3++] = parsedValueArray2[i];
        }
        return new ParsedValue<ParsedValue[], Paint>(parsedValueArray3, PaintConverter.RadialGradientConverter.getInstance());
    }

    private ParsedValue parseRadialGradient(Term term) throws ParseException {
        ParsedValue<ParsedValue[], Stop>[] parsedValueArray;
        Object object;
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"radial-gradient".regionMatches(true, 0, string, 0, 15)) {
            this.error(term, "Expected 'radial-gradient'");
        }
        if ((term2 = term.firstArg) == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term, "Expected 'focus-angle <angle>' or 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
        }
        Term term3 = term2;
        ParsedValue parsedValue = null;
        ParsedValue parsedValue2 = null;
        ParsedValue[] parsedValueArray2 = null;
        ParsedValue<?, Size> parsedValue3 = null;
        if ("focus-angle".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || !this.isSize(term2.token)) {
                this.error(term3, "Expected '<angle>'");
            }
            object = this.size(term2.token);
            switch (object.getUnits()) {
                case DEG: 
                case RAD: 
                case GRAD: 
                case TURN: 
                case PX: {
                    break;
                }
                default: {
                    this.error(term2, "Expected [deg | rad | grad | turn ]");
                }
            }
            parsedValue = new ParsedValue(object, null);
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
            }
        }
        if ("focus-distance".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || !this.isSize(term2.token)) {
                this.error(term3, "Expected '<percentage>'");
            }
            object = this.size(term2.token);
            switch (object.getUnits()) {
                case PERCENT: {
                    break;
                }
                default: {
                    this.error(term2, "Expected '%'");
                }
            }
            parsedValue2 = new ParsedValue((Size)object, null);
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'center <center>' or 'radius <length>'");
            }
        }
        if ("center".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            object = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            parsedValueArray = this.parseSize(term2);
            parsedValueArray2 = new ParsedValue[]{object, parsedValueArray};
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        if ("radius".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || !this.isSize(term2.token)) {
                this.error(term3, "Expected '[<length> | <percentage>]'");
            }
            parsedValue3 = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        object = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(term2.token.getText())) {
            object = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        } else if ("repeat".equalsIgnoreCase(term2.token.getText())) {
            object = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        }
        if (term2 == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term3, "Expected '<color-stop>'");
        }
        parsedValueArray = this.parseColorStops(term2);
        ParsedValue[] parsedValueArray3 = new ParsedValue[6 + parsedValueArray.length];
        int n = 0;
        parsedValueArray3[n++] = parsedValue;
        parsedValueArray3[n++] = parsedValue2;
        parsedValueArray3[n++] = parsedValueArray2 != null ? parsedValueArray2[0] : null;
        parsedValueArray3[n++] = parsedValueArray2 != null ? parsedValueArray2[1] : null;
        parsedValueArray3[n++] = parsedValue3;
        parsedValueArray3[n++] = new ParsedValue((Size)object, null);
        for (int i = 0; i < parsedValueArray.length; ++i) {
            parsedValueArray3[n++] = parsedValueArray[i];
        }
        return new ParsedValue<ParsedValue[], Paint>(parsedValueArray3, PaintConverter.RadialGradientConverter.getInstance());
    }

    private ParsedValue<ParsedValue<?, Paint>[], Paint[]> parsePaintLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        Term term2 = term;
        int n2 = 0;
        do {
            if (term2.token == null || term2.token.getText() == null || term2.token.getText().isEmpty()) {
                this.error(term2, "Expected '<paint>'");
            }
            parsedValueArray[n2++] = this.parse(term2);
        } while ((term2 = this.nextLayer(term2)) != null);
        return new ParsedValue<ParsedValue<?, Paint>[], Paint[]>(parsedValueArray, PaintConverter.SequenceConverter.getInstance());
    }

    private ParsedValue<?, Size>[] parseSizeSeries(Term term) throws ParseException {
        Term term2 = term;
        ParsedValue[] parsedValueArray = new ParsedValue[4];
        int n = 0;
        while (n < 4 && term2 != null) {
            parsedValueArray[n++] = this.parseSize(term2);
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            parsedValueArray[1] = parsedValueArray[0];
        }
        if (n < 3) {
            parsedValueArray[2] = parsedValueArray[0];
        }
        if (n < 4) {
            parsedValueArray[3] = parsedValueArray[1];
        }
        return parsedValueArray;
    }

    private ParsedValue<ParsedValue<ParsedValue<?, Size>[], Insets>[], Insets[]> parseInsetsLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Term term2 = term;
        int n2 = 0;
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        while (term2 != null) {
            ParsedValue<?, Size>[] parsedValueArray2 = this.parseSizeSeries(term2);
            parsedValueArray[n2++] = new ParsedValue<ParsedValue<?, Size>[], Insets>(parsedValueArray2, InsetsConverter.getInstance());
            while (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
            }
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue<?, Size>[], Insets>[], Insets[]>(parsedValueArray, InsetsConverter.SequenceConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue<?, Size>[], Margins>[], Margins[]> parseMarginsLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Term term2 = term;
        int n2 = 0;
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        while (term2 != null) {
            ParsedValue<?, Size>[] parsedValueArray2 = this.parseSizeSeries(term2);
            parsedValueArray[n2++] = new ParsedValue<ParsedValue<?, Size>[], Margins>(parsedValueArray2, Margins.Converter.getInstance());
            while (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
            }
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue<?, Size>[], Margins>[], Margins[]>(parsedValueArray, Margins.SequenceConverter.getInstance());
    }

    private ParsedValue<ParsedValue<?, Size>[], BackgroundImage.BackgroundPosition> parseBackgroundPosition(Term term) throws ParseException {
        ParsedValue[] parsedValueArray;
        Object object;
        if (term.token == null || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected '<bg-position>'");
        }
        Term term2 = term;
        Token token = term.token;
        Term term3 = term2.nextInSeries;
        Token token2 = term3 != null ? term3.token : null;
        Term term4 = term3 != null ? term3.nextInSeries : null;
        Token token3 = term4 != null ? term4.token : null;
        Term term5 = term4 != null ? term4.nextInSeries : null;
        Token token4 = term5 != null ? term5.token : null;
        Object object2 = ZERO_PERCENT;
        ParsedValue[] parsedValueArray2 = object = ZERO_PERCENT;
        Object object3 = object;
        if (token2 != null && token3 != null) {
            String string;
            if (token2.getType() == 11) {
                if (token4 != null) {
                    this.error(term3, "Unexpected value in '<bg-position>'");
                }
                token4 = token3;
                term5 = term4;
                token3 = token2;
                term4 = term3;
                token2 = null;
                term3 = null;
            }
            if (token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
                this.error(term2, "Expected 'center', 'left' or 'right'");
            }
            parsedValueArray = null;
            if (token2 != null && this.isSize(token2)) {
                parsedValueArray = this.parseSize(term3);
            } else {
                this.error(term3, "Expected '<size>'");
            }
            if (token3.getType() != 11 || token3.getText() == null || token3.getText().isEmpty()) {
                this.error(term4, "Expected 'center', 'left' or 'right'");
            }
            ParsedValue<?, Size> parsedValue = null;
            if (token4 != null) {
                if (this.isSize(token4)) {
                    parsedValue = this.parseSize(term5);
                } else {
                    this.error(term5, "Expected '<size>'");
                }
            }
            if ("center".equals(string = token.getText().toLowerCase())) {
                object2 = FIFTY_PERCENT;
                if (parsedValueArray != null) {
                    this.error(term3, "Unexpected '<size>'");
                }
            } else if ("left".equals(string)) {
                object2 = parsedValueArray != null ? parsedValueArray : ZERO_PERCENT;
            } else if ("right".equals(string)) {
                if (parsedValueArray != null) {
                    parsedValueArray2 = parsedValueArray;
                } else {
                    object2 = ONE_HUNDRED_PERCENT;
                }
            } else {
                this.error(term2, "Expected 'center', 'left' or 'right'");
            }
            if ("center".equals(string = token3.getText().toLowerCase())) {
                object3 = FIFTY_PERCENT;
                if (parsedValue != null) {
                    this.error(term5, "Unexpected '<size>'");
                }
            } else if ("top".equals(string)) {
                object3 = parsedValue != null ? parsedValue : ZERO_PERCENT;
            } else if ("bottom".equals(string)) {
                if (parsedValue != null) {
                    object = parsedValue;
                } else {
                    object3 = ONE_HUNDRED_PERCENT;
                }
            } else {
                this.error(term4, "Expected 'center', 'left' or 'right'");
            }
        } else if (token2 != null) {
            if (token.getType() == 11) {
                ParsedValue[] parsedValueArray3 = parsedValueArray = token.getText() != null ? token.getText().toLowerCase() : null;
                if ("center".equals(parsedValueArray)) {
                    object2 = FIFTY_PERCENT;
                } else if ("left".equals(parsedValueArray)) {
                    object2 = ZERO_PERCENT;
                } else if ("right".equals(parsedValueArray)) {
                    object2 = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term2, "Expected 'center', 'left' or 'right'");
                }
            } else if (this.isSize(token)) {
                object2 = this.parseSize(term2);
            } else {
                this.error(term2, "Expected '<size>', 'center', 'left' or 'right'");
            }
            if (token2.getType() == 11) {
                ParsedValue[] parsedValueArray4 = parsedValueArray = token2.getText() != null ? token2.getText().toLowerCase() : null;
                if ("center".equals(parsedValueArray)) {
                    object3 = FIFTY_PERCENT;
                } else if ("top".equals(parsedValueArray)) {
                    object3 = ZERO_PERCENT;
                } else if ("bottom".equals(parsedValueArray)) {
                    object3 = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term3, "Expected 'center', 'left' or 'right'");
                }
            } else if (this.isSize(token2)) {
                object3 = this.parseSize(term3);
            } else {
                this.error(term3, "Expected '<size>', 'center', 'left' or 'right'");
            }
        } else if (token.getType() == 11) {
            ParsedValue[] parsedValueArray5 = parsedValueArray = token.getText() != null ? token.getText().toLowerCase() : null;
            if ("center".equals(parsedValueArray)) {
                object2 = FIFTY_PERCENT;
                object3 = FIFTY_PERCENT;
            } else if ("left".equals(parsedValueArray)) {
                object2 = ZERO_PERCENT;
                object3 = FIFTY_PERCENT;
            } else if ("right".equals(parsedValueArray)) {
                object2 = ONE_HUNDRED_PERCENT;
                object3 = FIFTY_PERCENT;
            } else if ("top".equals(parsedValueArray)) {
                object3 = ZERO_PERCENT;
                object2 = FIFTY_PERCENT;
            } else if ("bottom".equals(parsedValueArray)) {
                object3 = ONE_HUNDRED_PERCENT;
                object2 = FIFTY_PERCENT;
            } else {
                this.error(term2, "Expected 'center', 'left' or 'right'");
            }
        } else if (this.isSize(token)) {
            object2 = this.parseSize(term2);
            object3 = FIFTY_PERCENT;
        } else {
            this.error(term2, "Expected '<size>', 'center', 'left' or 'right'");
        }
        parsedValueArray = new ParsedValue[]{object3, parsedValueArray2, object, object2};
        return new ParsedValue<ParsedValue<?, Size>[], BackgroundImage.BackgroundPosition>(parsedValueArray, BackgroundImage.BackgroundPositionConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue<?, Size>[], BackgroundImage.BackgroundPosition>[], BackgroundImage.BackgroundPosition[]> parseBackgroundPositionLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseBackgroundPosition(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue<?, Size>[], BackgroundImage.BackgroundPosition>[], BackgroundImage.BackgroundPosition[]>(parsedValueArray, BackgroundImage.LayeredBackgroundPositionConverter.getInstance());
    }

    private ParsedValue<Repeat, Repeat>[] parseRepeatStyle(Term term) throws ParseException {
        String string;
        Repeat repeat;
        Repeat repeat2 = repeat = Repeat.NO_REPEAT;
        Term term2 = term;
        if (term2.token == null || term2.token.getType() != 11 || term2.token.getText() == null || term2.token.getText().isEmpty()) {
            this.error(term2, "Expected '<repeat-style>'");
        }
        if ("repeat-x".equals(string = term2.token.getText().toLowerCase())) {
            repeat2 = Repeat.REPEAT;
            repeat = Repeat.NO_REPEAT;
        } else if ("repeat-y".equals(string)) {
            repeat2 = Repeat.NO_REPEAT;
            repeat = Repeat.REPEAT;
        } else if ("repeat".equals(string)) {
            repeat2 = Repeat.REPEAT;
            repeat = Repeat.REPEAT;
        } else if ("space".equals(string)) {
            repeat2 = Repeat.SPACE;
            repeat = Repeat.SPACE;
        } else if ("round".equals(string)) {
            repeat2 = Repeat.ROUND;
            repeat = Repeat.ROUND;
        } else if ("no-repeat".equals(string)) {
            repeat2 = Repeat.NO_REPEAT;
            repeat = Repeat.NO_REPEAT;
        } else if ("stretch".equals(string)) {
            repeat2 = Repeat.NO_REPEAT;
            repeat = Repeat.NO_REPEAT;
        } else {
            this.error(term2, "Expected  '<repeat-style>' " + string);
        }
        term2 = term2.nextInSeries;
        if (term2 != null && term2.token != null && term2.token.getType() == 11 && term2.token.getText() != null && !term2.token.getText().isEmpty()) {
            string = term2.token.getText().toLowerCase();
            if ("repeat-x".equals(string)) {
                this.error(term2, "Unexpected 'repeat-x'");
            } else if ("repeat-y".equals(string)) {
                this.error(term2, "Unexpected 'repeat-y'");
            } else if ("repeat".equals(string)) {
                repeat = Repeat.REPEAT;
            } else if ("space".equals(string)) {
                repeat = Repeat.SPACE;
            } else if ("round".equals(string)) {
                repeat = Repeat.ROUND;
            } else if ("no-repeat".equals(string)) {
                repeat = Repeat.NO_REPEAT;
            } else if ("stretch".equals(string)) {
                repeat = Repeat.NO_REPEAT;
            } else {
                this.error(term2, "Expected  '<repeat-style>'");
            }
        }
        return new ParsedValue[]{new ParsedValue(repeat2, null), new ParsedValue(repeat, null)};
    }

    private ParsedValue<ParsedValue<Repeat, Repeat>[][], BorderImage.BorderImageRepeat[]> parseBorderImageRepeatStyleLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[][] parsedValueArrayArray = new ParsedValue[n][];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArrayArray[n2++] = this.parseRepeatStyle(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<Repeat, Repeat>[][], BorderImage.BorderImageRepeat[]>(parsedValueArrayArray, BorderImage.RepeatConverter.getInstance());
    }

    private ParsedValue<ParsedValue<Repeat, Repeat>[][], BackgroundImage.BackgroundRepeat[]> parseBackgroundRepeatStyleLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[][] parsedValueArrayArray = new ParsedValue[n][];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArrayArray[n2++] = this.parseRepeatStyle(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<Repeat, Repeat>[][], BackgroundImage.BackgroundRepeat[]>(parsedValueArrayArray, BackgroundImage.BackgroundRepeatConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], BackgroundImage.BackgroundSize> parseBackgroundSize(Term term) throws ParseException {
        ParsedValue[] parsedValueArray;
        ParsedValue<Size, Size> parsedValue = ZERO_PERCENT;
        ParsedValue<Size, Size> parsedValue2 = ZERO_PERCENT;
        boolean bl = false;
        boolean bl2 = false;
        Term term2 = term;
        if (term2.token == null) {
            this.error(term2, "Expected '<bg-size>'");
        }
        if (term2.token.getType() == 11) {
            ParsedValue[] parsedValueArray2 = parsedValueArray = term2.token.getText() != null ? term2.token.getText().toLowerCase() : null;
            if ("auto".equals(parsedValueArray)) {
                parsedValue2 = ZERO_PERCENT;
                parsedValue = ZERO_PERCENT;
            } else if ("cover".equals(parsedValueArray)) {
                bl = true;
            } else if ("contain".equals(parsedValueArray)) {
                bl2 = true;
            } else if ("stretch".equals(parsedValueArray)) {
                parsedValue2 = ONE_HUNDRED_PERCENT;
                parsedValue = ONE_HUNDRED_PERCENT;
            } else {
                this.error(term2, "Expected 'auto', 'cover', 'contain', or  'stretch'");
            }
        } else if (this.isSize(term2.token)) {
            parsedValue2 = this.parseSize(term2);
            parsedValue = ZERO_PERCENT;
        } else {
            this.error(term2, "Expected '<bg-size>'");
        }
        term2 = term2.nextInSeries;
        if (term2 != null) {
            if (bl || bl2) {
                this.error(term2, "Unexpected '<bg-size>'");
            }
            if (term2.token.getType() == 11) {
                ParsedValue[] parsedValueArray3 = parsedValueArray = term2.token.getText() != null ? term2.token.getText().toLowerCase() : null;
                if ("auto".equals(parsedValueArray)) {
                    parsedValue = ZERO_PERCENT;
                } else if ("cover".equals(parsedValueArray)) {
                    this.error(term2, "Unexpected 'cover'");
                } else if ("contain".equals(parsedValueArray)) {
                    this.error(term2, "Unexpected 'contain'");
                } else if ("stretch".equals(parsedValueArray)) {
                    parsedValue = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term2, "Expected 'auto' or 'stretch'");
                }
            } else if (this.isSize(term2.token)) {
                parsedValue = this.parseSize(term2);
            } else {
                this.error(term2, "Expected '<bg-size>'");
            }
        }
        parsedValueArray = new ParsedValue[]{parsedValue2, parsedValue, new ParsedValue<String, Boolean>(bl ? "true" : "false", BooleanConverter.getInstance()), new ParsedValue<String, Boolean>(bl2 ? "true" : "false", BooleanConverter.getInstance())};
        return new ParsedValue<ParsedValue[], BackgroundImage.BackgroundSize>(parsedValueArray, BackgroundImage.BackgroundSizeConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue[], BackgroundImage.BackgroundSize>[], BackgroundImage.BackgroundSize[]> parseBackgroundSizeLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseBackgroundSize(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue[], BackgroundImage.BackgroundSize>[], BackgroundImage.BackgroundSize[]>(parsedValueArray, BackgroundImage.LayeredBackgroundSizeConverter.getInstance());
    }

    private ParsedValue<ParsedValue<?, Paint>[], Paint[]> parseBorderPaint(Term term) throws ParseException {
        Term term2 = term;
        ParsedValue[] parsedValueArray = new ParsedValue[4];
        int n = 0;
        while (term2 != null) {
            if (term2.token == null) {
                this.error(term2, "Expected '<paint>'");
            }
            parsedValueArray[n++] = this.parse(term2);
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            parsedValueArray[1] = parsedValueArray[0];
        }
        if (n < 3) {
            parsedValueArray[2] = parsedValueArray[0];
        }
        if (n < 4) {
            parsedValueArray[3] = parsedValueArray[1];
        }
        return new ParsedValue<ParsedValue<?, Paint>[], Paint[]>(parsedValueArray, StrokeBorder.BorderPaintConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]> parseBorderPaintLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseBorderPaint(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]>(parsedValueArray, StrokeBorder.LayeredBorderPaintConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]> parseBorderStyleSeries(Term term) throws ParseException {
        Term term2 = term;
        ParsedValue[] parsedValueArray = new ParsedValue[4];
        int n = 0;
        while (term2 != null) {
            parsedValueArray[n++] = this.parseBorderStyle(term2);
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            parsedValueArray[1] = parsedValueArray[0];
        }
        if (n < 3) {
            parsedValueArray[2] = parsedValueArray[0];
        }
        if (n < 4) {
            parsedValueArray[3] = parsedValueArray[1];
        }
        return new ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]>(parsedValueArray, StrokeBorder.BorderStyleSequenceConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]>[], BorderStyle[][]> parseBorderStyleLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseBorderStyleSeries(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]>[], BorderStyle[][]>(parsedValueArray, StrokeBorder.LayeredBorderStyleConverter.getInstance());
    }

    private String getKeyword(Term term) {
        if (term != null && term.token != null && term.token.getType() == 11 && term.token.getText() != null && !term.token.getText().isEmpty()) {
            return term.token.getText().toLowerCase();
        }
        return null;
    }

    private ParsedValue<ParsedValue[], BorderStyle> parseBorderStyle(Term term) throws ParseException {
        ParsedValue[] parsedValueArray;
        ParsedValue<ParsedValue<?, Size>[], Double[]> parsedValue = null;
        ParsedValue parsedValue2 = null;
        ParsedValue<String, StrokeType> parsedValue3 = null;
        ParsedValue parsedValue4 = null;
        ParsedValue parsedValue5 = null;
        ParsedValue<String, StrokeLineCap> parsedValue6 = null;
        Term term2 = term;
        parsedValue = this.dashStyle(term2);
        Term term3 = term2;
        term2 = term2.nextInSeries;
        String string = this.getKeyword(term2);
        if ("phase".equals(string)) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || term2.token == null || !this.isSize(term2.token)) {
                this.error(term2, "Expected '<size>'");
            }
            parsedValueArray = this.parseSize(term2);
            parsedValue2 = new ParsedValue((ParsedValue<?, Size>)parsedValueArray, SizeConverter.getInstance());
            term3 = term2;
            term2 = term2.nextInSeries;
        }
        if ((parsedValue3 = this.parseStrokeType(term2)) != null) {
            term3 = term2;
            term2 = term2.nextInSeries;
        }
        if ("line-join".equals(string = this.getKeyword(term2))) {
            term3 = term2;
            term2 = term2.nextInSeries;
            parsedValueArray = this.parseStrokeLineJoin(term2);
            if (parsedValueArray != null) {
                parsedValue4 = parsedValueArray[0];
                parsedValue5 = parsedValueArray[1];
            } else {
                this.error(term2, "Expected 'miter <size>?', 'bevel' or 'round'");
            }
            term3 = term2;
            term2 = term2.nextInSeries;
            string = this.getKeyword(term2);
        }
        if ("line-cap".equals(string)) {
            term3 = term2;
            term2 = term2.nextInSeries;
            parsedValue6 = this.parseStrokeLineCap(term2);
            if (parsedValue6 == null) {
                this.error(term2, "Expected 'square', 'butt' or 'round'");
            }
            term3 = term2;
            term2 = term2.nextInSeries;
        }
        if (term2 != null) {
            term.nextInSeries = term2;
        } else {
            term.nextInSeries = null;
            term.nextLayer = term3.nextLayer;
        }
        parsedValueArray = new ParsedValue[]{parsedValue, parsedValue2, parsedValue3, parsedValue4, parsedValue5, parsedValue6};
        return new ParsedValue<ParsedValue[], BorderStyle>(parsedValueArray, StrokeBorder.BorderStyleConverter.getInstance());
    }

    private ParsedValue<ParsedValue<?, Size>[], Double[]> dashStyle(Term term) throws ParseException {
        if (term.token == null) {
            this.error(term, "Expected '<dash-style>'");
        }
        int n = term.token.getType();
        ParsedValue<ParsedValue<?, Size>[], Double[]> parsedValue = null;
        if (n == 11) {
            parsedValue = this.borderStyle(term);
        } else if (n == 12) {
            parsedValue = this.segments(term);
        } else {
            this.error(term, "Expected '<dash-style>'");
        }
        return parsedValue;
    }

    private ParsedValue<ParsedValue<?, Size>[], Double[]> borderStyle(Term term) throws ParseException {
        String string;
        if (term.token == null || term.token.getType() != 11 || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected '<border-style>'");
        }
        if ("none".equals(string = term.token.getText().toLowerCase())) {
            return NONE;
        }
        if ("hidden".equals(string)) {
            return NONE;
        }
        if ("dotted".equals(string)) {
            return DOTTED;
        }
        if ("dashed".equals(string)) {
            return DASHED;
        }
        if ("solid".equals(string)) {
            return SOLID;
        }
        if ("double".equals(string)) {
            this.error(term, "Unsupported <border-style> 'double'");
        } else if ("groove".equals(string)) {
            this.error(term, "Unsupported <border-style> 'groove'");
        } else if ("ridge".equals(string)) {
            this.error(term, "Unsupported <border-style> 'ridge'");
        } else if ("inset".equals(string)) {
            this.error(term, "Unsupported <border-style> 'inset'");
        } else if ("outset".equals(string)) {
            this.error(term, "Unsupported <border-style> 'outset'");
        } else {
            this.error(term, "Unsupported <border-style> '" + string + "'");
        }
        return SOLID;
    }

    private ParsedValue<ParsedValue<?, Size>[], Double[]> segments(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"segments".regionMatches(true, 0, string, 0, 8)) {
            this.error(term, "Expected 'segments'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term2, "Expected '<size>'");
        }
        int n = this.numberOfArgs(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        int n2 = 0;
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseSize(term2);
            term2 = term2.nextArg;
        }
        return new ParsedValue<ParsedValue<?, Size>[], Double[]>(parsedValueArray, SizeConverter.SequenceConverter.getInstance());
    }

    private ParsedValue<String, StrokeType> parseStrokeType(Term term) throws ParseException {
        String string = this.getKeyword(term);
        if ("centered".equals(string) || "inside".equals(string) || "outside".equals(string)) {
            return new ParsedValue<String, StrokeType>(string, new EnumConverter(StrokeType.class));
        }
        return null;
    }

    private ParsedValue[] parseStrokeLineJoin(Term term) throws ParseException {
        String string = this.getKeyword(term);
        if ("miter".equals(string) || "bevel".equals(string) || "round".equals(string)) {
            Term term2;
            ParsedValue parsedValue = new ParsedValue(string, new EnumConverter(StrokeLineJoin.class));
            ParsedValue parsedValue2 = null;
            if ("miter".equals(string) && (term2 = term.nextInSeries) != null && term2.token != null && this.isSize(term2.token)) {
                term.nextInSeries = term2.nextInSeries;
                ParsedValue<?, Size> parsedValue3 = this.parseSize(term2);
                parsedValue2 = new ParsedValue(parsedValue3, SizeConverter.getInstance());
            }
            return new ParsedValue[]{parsedValue, parsedValue2};
        }
        return null;
    }

    private ParsedValue<String, StrokeLineCap> parseStrokeLineCap(Term term) throws ParseException {
        String string = this.getKeyword(term);
        if ("square".equals(string) || "butt".equals(string) || "round".equals(string)) {
            return new ParsedValue<String, StrokeLineCap>(string, new EnumConverter(StrokeLineCap.class));
        }
        return null;
    }

    private ParsedValue<ParsedValue[], BorderImage.BorderImageSlice> parseBorderImageSlice(Term term) throws ParseException {
        Term term2 = term;
        if (term2.token == null || !this.isSize(term2.token)) {
            this.error(term2, "Expected '<size>'");
        }
        ParsedValue[] parsedValueArray = new ParsedValue[4];
        Boolean bl = Boolean.FALSE;
        int n = 0;
        while (n < 4 && term2 != null) {
            parsedValueArray[n++] = this.parseSize(term2);
            term2 = term2.nextInSeries;
            if (term2 == null || term2.token == null || term2.token.getType() != 11 || !"fill".equalsIgnoreCase(term2.token.getText())) continue;
            bl = Boolean.TRUE;
            break;
        }
        if (n < 2) {
            parsedValueArray[1] = parsedValueArray[0];
        }
        if (n < 3) {
            parsedValueArray[2] = parsedValueArray[0];
        }
        if (n < 4) {
            parsedValueArray[3] = parsedValueArray[1];
        }
        ParsedValue[] parsedValueArray2 = new ParsedValue[]{new ParsedValue<ParsedValue<?, Size>[], Insets>(parsedValueArray, InsetsConverter.getInstance()), new ParsedValue(bl, null)};
        return new ParsedValue<ParsedValue[], BorderImage.BorderImageSlice>(parsedValueArray2, BorderImage.SliceConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue[], BorderImage.BorderImageSlice>[], BorderImage.BorderImageSlice[]> parseBorderImageSliceLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseBorderImageSlice(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue[], BorderImage.BorderImageSlice>[], BorderImage.BorderImageSlice[]>(parsedValueArray, BorderImage.SliceSequenceConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], String> parseURI(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"url".regionMatches(true, 0, string, 0, 3)) {
            this.error(term, "Expected 'url'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term, "Expected 'url(\"<uri-string>\")'");
        }
        if (term2.token == null || term2.token.getType() != 10 || term2.token.getText() == null || term2.token.getText().isEmpty()) {
            this.error(term2, "Excpected 'url(\"<uri-string>\")'");
        }
        String string3 = term2.token.getText();
        ParsedValue[] parsedValueArray = new ParsedValue[]{new ParsedValue<String, String>(string3, StringConverter.getInstance()), new ParsedValue(this.sourceOfStylesheet, null)};
        return new ParsedValue<ParsedValue[], String>(parsedValueArray, URLConverter.getInstance());
    }

    private ParsedValue<ParsedValue<ParsedValue[], String>[], String[]> parseURILayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Term term2 = term;
        int n2 = 0;
        ParsedValue[] parsedValueArray = new ParsedValue[n];
        while (term2 != null) {
            parsedValueArray[n2++] = this.parseURI(term2);
            term2 = this.nextLayer(term2);
        }
        return new ParsedValue<ParsedValue<ParsedValue[], String>[], String[]>(parsedValueArray, URLConverter.SequenceConverter.getInstance());
    }

    private ParsedValue<ParsedValue<?, Size>, Double> parseFontSize(Term term) throws ParseException {
        Object object;
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || !this.isSize(token)) {
            this.error(term, "Expected '<font-size>'");
        }
        Size size = null;
        if (token.getType() == 11) {
            object = token.getText().toLowerCase();
            double d = -1.0;
            if ("inherit".equals(object)) {
                d = 100.0;
            } else if ("xx-small".equals(object)) {
                d = 60.0;
            } else if ("x-small".equals(object)) {
                d = 75.0;
            } else if ("small".equals(object)) {
                d = 80.0;
            } else if ("medium".equals(object)) {
                d = 100.0;
            } else if ("large".equals(object)) {
                d = 120.0;
            } else if ("x-large".equals(object)) {
                d = 150.0;
            } else if ("xx-large".equals(object)) {
                d = 200.0;
            } else if ("smaller".equals(object)) {
                d = 80.0;
            } else if ("larger".equals(object)) {
                d = 120.0;
            }
            if (d > -1.0) {
                size = new Size(d, SizeUnits.PERCENT);
            }
        }
        if (size == null) {
            size = this.size(token);
        }
        object = new ParsedValue(size, null);
        return new ParsedValue(object, FontConverter.SizeConverter.getInstance());
    }

    private ParsedValue<FontUnits.Style, FontPosture> parseFontStyle(Term term) throws ParseException {
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
            this.error(term, "Expected '<font-style>'");
        }
        String string = token.getText().toLowerCase();
        FontUnits.Style style = null;
        if ("normal".equals(string)) {
            style = FontUnits.Style.NORMAL;
        } else if ("italic".equals(string)) {
            style = FontUnits.Style.ITALIC;
        } else if ("oblique".equals(string)) {
            style = FontUnits.Style.OBLIQUE;
        } else if ("inherit".equals(string)) {
            style = FontUnits.Style.OBLIQUE;
        } else {
            return null;
        }
        return new ParsedValue<FontUnits.Style, FontPosture>(style, FontConverter.StyleConverter.getInstance());
    }

    private ParsedValue<FontUnits.Weight, FontWeight> parseFontWeight(Term term) throws ParseException {
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
            this.error(term, "Expected '<font-weight>'");
        }
        String string = token.getText().toLowerCase();
        FontUnits.Weight weight = null;
        if ("inherit".equals(string)) {
            weight = FontUnits.Weight.INHERIT;
        } else if ("normal".equals(string)) {
            weight = FontUnits.Weight.NORMAL;
        } else if ("bold".equals(string)) {
            weight = FontUnits.Weight.BOLD;
        } else if ("bolder".equals(string)) {
            weight = FontUnits.Weight.BOLDER;
        } else if ("lighter".equals(string)) {
            weight = FontUnits.Weight.LIGHTER;
        } else if ("100".equals(string)) {
            weight = FontUnits.Weight.SCALE_100;
        } else if ("200".equals(string)) {
            weight = FontUnits.Weight.SCALE_200;
        } else if ("300".equals(string)) {
            weight = FontUnits.Weight.SCALE_300;
        } else if ("400".equals(string)) {
            weight = FontUnits.Weight.SCALE_400;
        } else if ("500".equals(string)) {
            weight = FontUnits.Weight.SCALE_500;
        } else if ("600".equals(string)) {
            weight = FontUnits.Weight.SCALE_600;
        } else if ("700".equals(string)) {
            weight = FontUnits.Weight.SCALE_700;
        } else if ("800".equals(string)) {
            weight = FontUnits.Weight.SCALE_800;
        } else {
            return null;
        }
        return new ParsedValue<FontUnits.Weight, FontWeight>(weight, FontConverter.WeightConverter.getInstance());
    }

    private ParsedValue<String, String> parseFontFamily(Term term) throws ParseException {
        String string;
        if (term == null) {
            return null;
        }
        Token token = term.token;
        String string2 = null;
        if (token == null || token.getType() != 11 && token.getType() != 10 || (string2 = token.getText()) == null || string2.isEmpty()) {
            this.error(term, "Expected '<font-family>'");
        }
        if ("inherit".equals(string = this.stripQuotes(string2.toLowerCase()))) {
            return new ParsedValue<String, String>("inherit", StringConverter.getInstance());
        }
        if ("serif".equals(string) || "sans-serif".equals(string) || "cursive".equals(string) || "fantasy".equals(string) || "monospace".equals(string)) {
            return new ParsedValue<String, String>(string, StringConverter.getInstance());
        }
        return new ParsedValue<String, String>(token.getText(), StringConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Font> parseFont(Term term) throws ParseException {
        ParsedValue<ParsedValue<?, Size>, Double> parsedValue;
        Term term2;
        Object object;
        Object object2 = term.nextInSeries;
        term.nextInSeries = null;
        while (object2 != null) {
            object = ((Term)object2).nextInSeries;
            ((Term)object2).nextInSeries = term;
            term = object2;
            object2 = object;
        }
        object = term.token;
        int n = ((Token)object).getType();
        if (n != 11 && n != 10) {
            this.error(term, "Expected '<font-family>'");
        }
        ParsedValue<String, String> parsedValue2 = this.parseFontFamily(term);
        Term term3 = term;
        term3 = term3.nextInSeries;
        if (term3 == null) {
            this.error(term, "Expected '<size>'");
        }
        if (term3.token == null || !this.isSize(term3.token)) {
            this.error(term3, "Expected '<size>'");
        }
        if ((term2 = term3.nextInSeries) != null && term2.token != null && term2.token.getType() == 32) {
            term = term2;
            term3 = term2.nextInSeries;
            if (term3 == null) {
                this.error(term, "Expected '<size>'");
            }
            if (term3.token == null || !this.isSize(term3.token)) {
                this.error(term3, "Expected '<size>'");
            }
            object = term3.token;
        }
        if ((parsedValue = this.parseFontSize(term3)) == null) {
            this.error(term, "Expected '<size>'");
        }
        ParsedValue<FontUnits.Style, FontPosture> parsedValue3 = null;
        ParsedValue<FontUnits.Weight, FontWeight> parsedValue4 = null;
        String string = null;
        while ((term3 = term3.nextInSeries) != null) {
            if (term3.token == null || term3.token.getType() != 11 || term3.token.getText() == null || term3.token.getText().isEmpty()) {
                this.error(term3, "Expected '<font-weight>', '<font-style>' or '<font-variant>'");
            }
            if (parsedValue3 == null && (parsedValue3 = this.parseFontStyle(term3)) != null) continue;
            if (string == null && "small-caps".equalsIgnoreCase(term3.token.getText())) {
                string = term3.token.getText();
                continue;
            }
            if (parsedValue4 != null || (parsedValue4 = this.parseFontWeight(term3)) == null) continue;
        }
        ParsedValue[] parsedValueArray = new ParsedValue[]{parsedValue2, parsedValue, parsedValue4, parsedValue3};
        return new ParsedValue<ParsedValue[], Font>(parsedValueArray, FontConverter.getInstance());
    }

    private Token nextToken(CSSLexer cSSLexer) {
        Token token = null;
        while ((token = cSSLexer.nextToken()) != null && token.getType() == 40 || token.getType() == 41) {
        }
        if (LOGGER.isLoggable(300)) {
            LOGGER.finest(token.toString());
        }
        return token;
    }

    private void parse(Stylesheet stylesheet, CSSLexer cSSLexer) {
        this.currentToken = this.nextToken(cSSLexer);
        while (this.currentToken != null && this.currentToken.getType() != -1) {
            List<Selector> list = this.selectors(cSSLexer);
            if (list == null) {
                return;
            }
            if (this.currentToken == null || this.currentToken.getType() != 28) {
                int n = this.currentToken != null ? this.currentToken.getLine() : -1;
                int n2 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                String string = MessageFormat.format("Expected LBRACE at [{0,number,#},{1,number,#}]", n, n2);
                CssError cssError = this.createError(string);
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning(cssError.toString());
                }
                this.reportError(cssError);
                this.currentToken = null;
                return;
            }
            this.currentToken = this.nextToken(cSSLexer);
            List<Declaration> list2 = this.declarations(cSSLexer);
            if (list2 == null) {
                return;
            }
            if (this.currentToken != null && this.currentToken.getType() != 29) {
                int n = this.currentToken != null ? this.currentToken.getLine() : -1;
                int n3 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                String string = MessageFormat.format("Expected RBRACE at [{0,number,#},{1,number,#}]", n, n3);
                CssError cssError = this.createError(string);
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning(cssError.toString());
                }
                this.reportError(cssError);
                this.currentToken = null;
                return;
            }
            stylesheet.getRules().add(new Rule(list, list2));
            this.currentToken = this.nextToken(cSSLexer);
        }
        this.currentToken = null;
    }

    private List<Selector> selectors(CSSLexer cSSLexer) {
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        while (true) {
            Selector selector;
            if ((selector = this.selector(cSSLexer)) == null) {
                while (this.currentToken != null && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(cSSLexer);
                }
                this.currentToken = this.nextToken(cSSLexer);
                if (this.currentToken != null && this.currentToken.getType() != -1) continue;
                this.currentToken = null;
                return null;
            }
            arrayList.add(selector);
            if (this.currentToken == null || this.currentToken.getType() != 36) break;
            this.currentToken = this.nextToken(cSSLexer);
        }
        return arrayList;
    }

    private Selector selector(CSSLexer cSSLexer) {
        Combinator combinator;
        ArrayList<Combinator> arrayList = null;
        ArrayList<SimpleSelector> arrayList2 = null;
        SimpleSelector simpleSelector = this.simpleSelector(cSSLexer);
        if (simpleSelector == null) {
            return null;
        }
        while ((combinator = this.combinator(cSSLexer)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<Combinator>();
            }
            arrayList.add(combinator);
            SimpleSelector simpleSelector2 = this.simpleSelector(cSSLexer);
            if (simpleSelector2 == null) {
                return null;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<SimpleSelector>();
                arrayList2.add(simpleSelector);
            }
            arrayList2.add(simpleSelector2);
        }
        if (this.currentToken != null && this.currentToken.getType() == 41) {
            this.currentToken = this.nextToken(cSSLexer);
        }
        if (arrayList2 == null) {
            return simpleSelector;
        }
        return new CompoundSelector(arrayList2, arrayList);
    }

    private SimpleSelector simpleSelector(CSSLexer cSSLexer) {
        String string = "*";
        String string2 = "";
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        while (true) {
            int n = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (n) {
                case 11: 
                case 33: {
                    string = this.currentToken.getText();
                    break;
                }
                case 38: {
                    this.currentToken = this.nextToken(cSSLexer);
                    if (this.currentToken != null && this.currentToken.getType() == 11) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(this.currentToken.getText());
                        break;
                    }
                    this.currentToken = Token.INVALID_TOKEN;
                    return null;
                }
                case 37: {
                    string2 = this.currentToken.getText().substring(1);
                    break;
                }
                case 31: {
                    this.currentToken = this.nextToken(cSSLexer);
                    if (this.currentToken != null && this.currentToken.getType() == 11) {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<String>();
                        }
                        arrayList2.add(this.currentToken.getText());
                        break;
                    }
                    this.currentToken = Token.INVALID_TOKEN;
                    return null;
                }
                case -1: 
                case 27: 
                case 28: 
                case 36: 
                case 40: 
                case 41: {
                    return new SimpleSelector(string, arrayList, arrayList2, string2);
                }
                default: {
                    return null;
                }
            }
            this.currentToken = cSSLexer.nextToken();
            if (!LOGGER.isLoggable(300)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private Combinator combinator(CSSLexer cSSLexer) {
        Combinator combinator = null;
        while (true) {
            int n = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (n) {
                case 40: {
                    if (combinator != null || !" ".equals(this.currentToken.getText())) break;
                    combinator = Combinator.DESCENDANT;
                    break;
                }
                case 27: {
                    combinator = Combinator.CHILD;
                    break;
                }
                case 11: 
                case 31: 
                case 33: 
                case 37: 
                case 38: {
                    return combinator;
                }
                default: {
                    return null;
                }
            }
            this.currentToken = cSSLexer.nextToken();
            if (!LOGGER.isLoggable(300)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private List<Declaration> declarations(CSSLexer cSSLexer) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        do {
            Declaration declaration;
            if ((declaration = this.declaration(cSSLexer)) != null) {
                arrayList.add(declaration);
            } else {
                while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(cSSLexer);
                }
                if (this.currentToken == null && this.currentToken.getType() != 30) {
                    return arrayList;
                }
            }
            while (this.currentToken != null && this.currentToken.getType() == 30) {
                this.currentToken = this.nextToken(cSSLexer);
            }
        } while (this.currentToken != null && this.currentToken.getType() == 11);
        return arrayList;
    }

    private Declaration declaration(CSSLexer cSSLexer) {
        boolean bl;
        int n;
        int n2 = n = this.currentToken != null ? this.currentToken.getType() : 0;
        if (this.currentToken == null || this.currentToken.getType() != 11) {
            return null;
        }
        String string = this.currentToken.getText();
        this.currentToken = this.nextToken(cSSLexer);
        if (this.currentToken == null || this.currentToken.getType() != 31) {
            int n3 = this.currentToken != null ? this.currentToken.getLine() : -1;
            int n4 = this.currentToken != null ? this.currentToken.getOffset() : -1;
            String string2 = MessageFormat.format("Expected COLON at [{0,number,#},{1,number,#}]", n3, n4);
            CssError cssError = this.createError(string2);
            if (LOGGER.isLoggable(900)) {
                LOGGER.warning(cssError.toString());
            }
            this.reportError(cssError);
            return null;
        }
        this.currentToken = this.nextToken(cSSLexer);
        Term term = this.expr(cSSLexer);
        ParsedValue parsedValue = null;
        try {
            parsedValue = term != null ? this.valueFor(string, term) : null;
        }
        catch (ParseException parseException) {
            Token token = parseException.tok;
            int n5 = token != null ? token.getLine() : -1;
            int n6 = token != null ? token.getOffset() : -1;
            String string3 = MessageFormat.format("{2} while parsing ''{3}'' at [{0,number,#},{1,number,#}]", n5, n6, parseException.getMessage(), string);
            CssError cssError = this.createError(string3);
            if (LOGGER.isLoggable(900)) {
                LOGGER.warning(cssError.toString());
            }
            this.reportError(cssError);
            return null;
        }
        boolean bl2 = bl = this.currentToken.getType() == 39;
        if (bl) {
            this.currentToken = this.nextToken(cSSLexer);
        }
        Declaration declaration = parsedValue != null ? new Declaration(string, parsedValue, bl) : null;
        return declaration;
    }

    private Term expr(CSSLexer cSSLexer) {
        Term term;
        Term term2 = term = this.term(cSSLexer);
        while (true) {
            int n;
            int n2 = n = this.currentToken != null ? this.currentToken.getType() : 0;
            if (n == 0) {
                this.skipExpr(cSSLexer);
                return null;
            }
            if (n == 30 || n == 39 || n == 29 || n == -1) {
                return term;
            }
            if (n == 36) {
                this.currentToken = this.nextToken(cSSLexer);
                term2 = term2.nextLayer = this.term(cSSLexer);
                continue;
            }
            term2 = term2.nextInSeries = this.term(cSSLexer);
        }
    }

    private void skipExpr(CSSLexer cSSLexer) {
        int n;
        do {
            this.currentToken = this.nextToken(cSSLexer);
            int n2 = n = this.currentToken != null ? this.currentToken.getType() : 0;
        } while (n != 30 && n != 29 && n != -1);
    }

    private Term term(CSSLexer cSSLexer) {
        int n = this.currentToken != null ? this.currentToken.getType() : 0;
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 37: {
                break;
            }
            case 12: 
            case 34: {
                Term term;
                Term term2 = new Term(this.currentToken);
                this.currentToken = this.nextToken(cSSLexer);
                term2.firstArg = term = this.term(cSSLexer);
                while (true) {
                    int n2;
                    int n3 = n2 = this.currentToken != null ? this.currentToken.getType() : 0;
                    if (n2 == 35) {
                        this.currentToken = this.nextToken(cSSLexer);
                        return term2;
                    }
                    if (n2 == 36) {
                        this.currentToken = this.nextToken(cSSLexer);
                        term = term.nextArg = this.term(cSSLexer);
                        continue;
                    }
                    term = term.nextInSeries = this.term(cSSLexer);
                }
            }
            default: {
                int n4 = this.currentToken != null ? this.currentToken.getLine() : -1;
                int n5 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                String string = this.currentToken != null ? this.currentToken.getText() : "";
                String string2 = MessageFormat.format("Unexpected token {0}{1}{0} at [{2,number,#},{3,number,#}]", "'", string, n4, n5);
                CssError cssError = this.createError(string2);
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning(cssError.toString());
                }
                this.reportError(cssError);
                return null;
            }
        }
        Term term = new Term(this.currentToken);
        this.currentToken = this.nextToken(cSSLexer);
        return term;
    }

    static {
        int n = LOGGER.getLevel();
        if (LOGGER.getLevel() > 900 && LOGGER.getLevel() != Integer.MAX_VALUE) {
            LOGGER.setLevel(900);
        }
        ZERO_PERCENT = new ParsedValue(new Size(0.0, SizeUnits.PERCENT), null);
        FIFTY_PERCENT = new ParsedValue(new Size(50.0, SizeUnits.PERCENT), null);
        ONE_HUNDRED_PERCENT = new ParsedValue(new Size(100.0, SizeUnits.PERCENT), null);
        DASHED = new ParsedValue<ParsedValue<?, Size>[], Double[]>(new ParsedValue[]{new ParsedValue(new Size(5.0, SizeUnits.PX), null), new ParsedValue(new Size(3.0, SizeUnits.PX), null)}, SizeConverter.SequenceConverter.getInstance());
        DOTTED = new ParsedValue<ParsedValue<?, Size>[], Double[]>(new ParsedValue[]{new ParsedValue(new Size(1.0, SizeUnits.PX), null), new ParsedValue(new Size(3.0, SizeUnits.PX), null)}, SizeConverter.SequenceConverter.getInstance());
        SOLID = new ParsedValue<ParsedValue<?, Size>[], Double[]>(new ParsedValue[0], SizeConverter.SequenceConverter.getInstance());
        NONE = new ParsedValue<ParsedValue<?, Size>[], Double[]>(null, SizeConverter.SequenceConverter.getInstance());
    }

    static class Term {
        final Token token;
        Term nextInSeries;
        Term nextLayer;
        Term firstArg;
        Term nextArg;

        Term(Token token) {
            this.token = token;
            this.nextLayer = null;
            this.nextInSeries = null;
            this.firstArg = null;
            this.nextArg = null;
        }

        Term() {
            this(null);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.token != null) {
                stringBuilder.append(String.valueOf(this.token.getText()));
            }
            if (this.nextInSeries != null) {
                stringBuilder.append("<nextInSeries>");
                stringBuilder.append(this.nextInSeries.toString());
                stringBuilder.append("</nextInSeries>\n");
            }
            if (this.nextLayer != null) {
                stringBuilder.append("<nextLayer>");
                stringBuilder.append(this.nextLayer.toString());
                stringBuilder.append("</nextLayer>\n");
            }
            if (this.firstArg != null) {
                stringBuilder.append("<args>");
                stringBuilder.append(this.firstArg.toString());
                if (this.nextArg != null) {
                    stringBuilder.append(this.nextArg.toString());
                }
                stringBuilder.append("</args>");
            }
            return stringBuilder.toString();
        }
    }

    private static final class ParseException
    extends Exception {
        private final Token tok;
        private final String source;

        ParseException(String string) {
            this(string, null, null);
        }

        ParseException(String string, Token token, CSSParser cSSParser) {
            super(string);
            this.tok = token;
            this.source = cSSParser.sourceOfStylesheet != null ? cSSParser.sourceOfStylesheet.toExternalForm() : (cSSParser.sourceOfInlineStyle != null ? cSSParser.sourceOfInlineStyle.toString() : (cSSParser.stylesheetAsText != null ? cSSParser.stylesheetAsText : "?"));
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(super.getMessage());
            stringBuilder.append(this.source);
            if (this.tok != null) {
                stringBuilder.append(": ").append(this.tok.toString());
            }
            return stringBuilder.toString();
        }
    }

    private static class InstanceHolder {
        static final CSSParser INSTANCE = new CSSParser();

        private InstanceHolder() {
        }
    }
}

