/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import sun.net.ResourceManager;

class TwoStacksPlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    private FileDescriptor fd1;
    private InetAddress anyLocalBoundAddr = null;
    private int fduse = -1;
    private int lastfd = -1;

    TwoStacksPlainDatagramSocketImpl() {
    }

    @Override
    protected synchronized void create() throws SocketException {
        this.fd1 = new FileDescriptor();
        try {
            super.create();
        }
        catch (SocketException socketException) {
            this.fd1 = null;
            throw socketException;
        }
    }

    @Override
    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        super.bind(n, inetAddress);
        if (inetAddress.isAnyLocalAddress()) {
            this.anyLocalBoundAddr = inetAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        try {
            this.receive0(datagramPacket);
        }
        finally {
            this.fduse = -1;
        }
    }

    @Override
    public Object getOption(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        if (n == 15) {
            if (this.fd != null && this.fd1 != null) {
                return this.anyLocalBoundAddr;
            }
            return this.socketGetOption(n);
        }
        return super.getOption(n);
    }

    @Override
    protected boolean isClosed() {
        return this.fd == null && this.fd1 == null;
    }

    @Override
    protected void close() {
        if (this.fd != null || this.fd1 != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
            this.fd1 = null;
        }
    }

    @Override
    protected synchronized native void bind0(int var1, InetAddress var2) throws SocketException;

    @Override
    protected native void send(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native int peek(InetAddress var1) throws IOException;

    @Override
    protected synchronized native int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected native void setTimeToLive(int var1) throws IOException;

    @Override
    protected native int getTimeToLive() throws IOException;

    @Override
    protected native void setTTL(byte var1) throws IOException;

    @Override
    protected native byte getTTL() throws IOException;

    @Override
    protected native void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void datagramSocketCreate() throws SocketException;

    @Override
    protected native void datagramSocketClose();

    @Override
    protected native void socketSetOption(int var1, Object var2) throws SocketException;

    @Override
    protected native Object socketGetOption(int var1) throws SocketException;

    @Override
    protected native void connect0(InetAddress var1, int var2) throws SocketException;

    @Override
    protected native void disconnect0(int var1);

    private static native void init();

    static {
        TwoStacksPlainDatagramSocketImpl.init();
    }
}

