#include "StdAfx.h"
#include "Common.h"
#include "soundbuffer.h"

//*************************************************************************************************************
//Konstruktor
//*************************************************************************************************************
CSoundBuffer::CSoundBuffer(void)
{
	m_DSSoundBuffer = NULL;			//neplatny ukazatel na rozhrani, neni jeste vytvoreno
	m_dwBufferSize = 0;				//vychozi hodnoty promennych
	m_dwCreationFlags = 0;
}
//*************************************************************************************************************
//Destruktor
//*************************************************************************************************************
CSoundBuffer::~CSoundBuffer(void)
{
	SAFE_RELEASE(m_DSSoundBuffer);	//uvolneni rozhrani z pameti	
}

//*************************************************************************************************************
//Fce pro vytvoreni rozhrani pro zvukovy buffer
//*************************************************************************************************************
HRESULT CSoundBuffer::Create(LPDIRECTSOUND lpDSound,DSBUFFERDESC* dsBufferDesc)
{
	HRESULT hRet = DS_OK;

	if (FAILED(hRet = lpDSound->CreateSoundBuffer(dsBufferDesc,&m_DSSoundBuffer,NULL)))	//pokud vytvareni rozhrani selze
		return hRet;																	//vratime chybu dal

	m_dwBufferSize = dsBufferDesc->dwBufferBytes;	//ulozeni velikosti bufferu
	m_dwCreationFlags = dsBufferDesc->dwFlags;		//ulozeni pznak

	return hRet;			//vraceni vysledku, sem uz by se  melo dostat jen S_OK
}

//*************************************************************************************************************
//Fce pro obnoveni bufferu
//*************************************************************************************************************
HRESULT CSoundBuffer::RestoreBuffer(bool *bWasRestored)
{
	HRESULT hRet;

	if (!m_DSSoundBuffer)		//kontrola jestli je rozhrani vubec vytvorene
		return CO_E_NOTINITIALIZED;

	if (bWasRestored)			//kontrola ukazatele
		*bWasRestored = false;

	DWORD dwStatus;
	if (FAILED(hRet = m_DSSoundBuffer->GetStatus(&dwStatus)))	//pokud se nam nepodari ziskat stav bufferu
		return hRet;											//tak rovonou koncime vracenim chyby

	if (dwStatus & DSBSTATUS_BUFFERLOST)						//pokud byl buffer ztracen
	{
		do														//budeme se v cyklu snazit ho obnovit
		{														//dokud se to nepovede
			hRet = m_DSSoundBuffer->Restore();
			if (hRet == DSERR_BUFFERLOST)
				Sleep(10);
		}
		while ((hRet = m_DSSoundBuffer->Restore()) == DSERR_BUFFERLOST);

		if (bWasRestored)										//ulozime do uzivatelske promenne ze buffer
			*bWasRestored = true;								//byl obnoven

		return S_OK;
	}
	return S_FALSE;
}

//*************************************************************************************************************
//Fce spusti prehravani bufferu
//*************************************************************************************************************
HRESULT CSoundBuffer::Play(DWORD dwPriority,DWORD dwFlags)
{
	if (!m_DSSoundBuffer)					//kontrola platnosti ukazatele na rozhrani
		return CO_E_NOTINITIALIZED;

	return m_DSSoundBuffer->Play(0,dwPriority,dwFlags);
}

//*************************************************************************************************************
//Fce nastavi frekvenci
//*************************************************************************************************************
HRESULT CSoundBuffer::SetFrequency(long lFrequency)
{
	if (!m_DSSoundBuffer)
		return CO_E_NOTINITIALIZED;

	if (lFrequency != -1 && m_dwCreationFlags & DSBCAPS_CTRLFREQUENCY)
		return m_DSSoundBuffer->SetFrequency(lFrequency);

	return S_FALSE;
}

//*************************************************************************************************************
//Fce nastavi hlasitost
//*************************************************************************************************************
HRESULT CSoundBuffer::SetVolume(long lVolume)
{
	if (!m_DSSoundBuffer)
		return CO_E_NOTINITIALIZED;

	if (m_dwCreationFlags & DSBCAPS_CTRLVOLUME)
		return m_DSSoundBuffer->SetVolume(lVolume);

	return S_FALSE;
}
//*************************************************************************************************************
//
//*************************************************************************************************************
HRESULT CSoundBuffer::SetPan(long lPan)
{
	if (!m_DSSoundBuffer)
		return CO_E_NOTINITIALIZED;

	if (m_dwCreationFlags & DSBCAPS_CTRLPAN)
		return m_DSSoundBuffer->SetPan(lPan);

	return S_FALSE;
}
//*************************************************************************************************************
//Fce zastavi prehravani bufferu
//*************************************************************************************************************
HRESULT CSoundBuffer::Stop()
{
	if (!m_DSSoundBuffer)
		return CO_E_NOTINITIALIZED;

	return m_DSSoundBuffer->Stop();
}
//*************************************************************************************************************
//Fce nastavi pozici hraciho kurzoru v bufferu na nula
//*************************************************************************************************************
HRESULT CSoundBuffer::Reset()
{
	if (!m_DSSoundBuffer)
		return CO_E_NOTINITIALIZED;

	return m_DSSoundBuffer->SetCurrentPosition(0);
}

//*************************************************************************************************************
//Fce rekne jestli je buffer prehravan ci ne
//*************************************************************************************************************
bool CSoundBuffer::IsSoundPlaying()
{
	if (!m_DSSoundBuffer)
		return false;

	DWORD dwStatus;
	m_DSSoundBuffer->GetStatus(&dwStatus);
	
	return (dwStatus & DSBSTATUS_PLAYING) ? true : false;
}