#pragma once

class CSoundBuffer;


__interface IOggFile
{
public:
	HRESULT				Open(const char* cFileName,LPDIRECTSOUND8 lpDSound,DWORD dwNotifyCount,DWORD wBufferLength = 3) = 0;
	HRESULT				Close() = 0; 
	HRESULT				CheckIfNeedReFillBuffer() = 0;
	HRESULT				Play(DWORD dwPriority = 0) = 0;
	HRESULT				Stop() = 0;
	HRESULT				Pause() = 0;
    
	//ruzne vlastnosti ogg souboru
	double				GetOggFilePlayingTime() = 0;
	DWORD				GetOggFilePCMSize() = 0;
	int					GetOggFileVersion() = 0;
	char*				GetOggFileVendor() = 0;
	int					GetCountOfOggFileComments() = 0;
	char*				GetOggFileComment(int nComment) = 0;
	CSoundBuffer*		GetStreamedBuffer() = 0;
	int					GetRepeats() = 0;
	bool				SetRepeats(int iRepeatCount) = 0;
	BYTE				GetStatus() = 0;

	HRESULT				ConvertOggToWav(const char* cOggFileName,const char* cWavFileName) = 0;
	
	HRESULT				AddRef() = 0;
	HRESULT				Release() = 0;
};

__interface OGGCODEC_API ISoundManager
{
public:
	HRESULT			CreateDirectSoundSystem(HWND hWnd,DWORD dwCooperativeLevel = DSSCL_PRIORITY) = 0; //vytvoreni objektu DirectSound

	HRESULT			LoadOgg(DWORD dwId, const char* cFileName) = 0; //nacteni ogg souboru
	HRESULT			UnloadOgg(DWORD dwId) = 0; //uvolneni nacteneho ogg souboru
	HRESULT			PlayOgg(DWORD dwId, DWORD dwPriority = 0) = 0; //spusti prehravani ogg souboru
	HRESULT			StopOgg(DWORD dwId) = 0; //zastaveni prehravani ogg souboru
	HRESULT			PauseOgg(DWORD dwId) = 0; //pozastaveni prehravani ogg souboru
	HRESULT			StopAllOgg() = 0; //zastaveni prehravani vsech ogg souboru
	HRESULT			PauseAllOgg() = 0; //pozastaveni prehravani vsech ogg souboru
	HRESULT			CheckOggIfNeedReFillBuffer(DWORD dwId) = 0; //zjisteni zda ogg soubor potrebuje obnovit data bufferu
	HRESULT			CheckAllOggIfNeedReFillBuffer() = 0; //zjisteni zda nektery ze vsech ogg souboru potrebuje obnovit data v bufferu
	bool			SetRepetsOfOgg(DWORD dwId,int dwRepeats) = 0; //nastavi pocet opakovani urciteho ogg souboru

	void			HandleAppActiveStateChanges(bool bIsAppActive) = 0; //reakce na ztratu a ziskani fokusu ridici aplikace
		
	LPDIRECTSOUND8	GetDirectSound() = 0; //vraceni ukazatele na ukazatel na zarizeni DirectSound
	IOggFile*		GetOggFile(DWORD dwID);

	HRESULT			AddRef() = 0;
	HRESULT			Release() = 0;
};