#pragma once

int const IWAVEHEADERSIZE = 38;
int const IWAVEDATASIZE = 8;

int const IQUIET = 0;
int const IBITS = 16;

int const IENDBITS = 0;
int const ISIGNED = 1;

//nejake konstanty pro prehravani
#define   OGGPLAY_REPEATINFINITE -1				//opakovat prehravani do nekoncecna
#define   OGGSTATUS_PLAYING 1					//ogg soubor je prave prehravan
#define	  OGGSTATUS_STOPPED 2					//prehravani je zastaveno
#define   OGGSTATUS_PAUSED 3					//prehravani je pozastaveno

//******************************************************************************************
//Trida pro praci se soubory ogg
//******************************************************************************************
class COggFile : public IOggFile
{
private:
	CSoundBuffer*		m_StreamedBuffer;		//zvukovy buffer pro ulozeni zvukovych dat

	OggVorbis_File		m_OggVorbisFile;		//struktura ogg vorbis file
	FILE*				m_OggFilePointer;		//ukazatel na otevreny ogg soubor
    
	DWORD				m_dwPCMSize;			//velikost dekodovaneho ogg souboru v bajtech

	//promenne pro funkcnost streamovaneho bufferu
	DWORD				m_dwLastPlayPos;		//posledni pozice hraciho kurzoru v bufferu
	DWORD				m_dwNextWriteOffset;	//dalsi offset v bufferu odkud se bude zapisovat
	DWORD				m_dwNotifySize;			//po jak velkych usecich se ma zapisovat
	DWORD				m_dwPlayProgress;		//pocet prehranych bajtu souboru
	DWORD				m_dwWriteProgress;		//prubeh zapisu
	DWORD				m_dwBufferSize;			//celkova velikost bufferuv bajtech

	int					m_iRepeatCount;			//pocet opakovani
	BYTE				m_bStatus;				//stav tridy, prehravani, zastaveno, pozastaveno

	DWORD				m_dwRef;

	//fce pro vytvoreni bufferu a nahrani dat
	HRESULT				InitBufferAndLoadFirstData(LPDIRECTSOUND8 lpDSound,DWORD dwNotifyCount,DWORD wBufferLength);
	//fce pro nahravani dat  o velikosti dwBztesRead do bufferu na offset dwOffset
	bool				WriteDataToBuffer(DWORD dwOffset,DWORD dwBytes,DWORD* dwBytesRead);
public:
	virtual HRESULT				Open(const char* FileName,LPDIRECTSOUND8 lpDSound,DWORD dwNotifyCount,DWORD wBufferLength = 3); //otevre ogg z disku nebo z sgf souboru (SGFNum >= 0)
	virtual HRESULT				Close(); //zavreni ogg souboru
	virtual HRESULT				CheckIfNeedReFillBuffer(); //fce testuje jestli je cas naplnit cast bufferu novymi daty a pokud ano tak tak ucini
	virtual HRESULT				Play(DWORD dwPriority = 0); //prehravani ogg souboru s nastavenim priority
	virtual HRESULT				Stop();	//zastaveni prehravani, ukazatel v souboru bude presunut na zacatek a pri spusteni se bude hrat od zacatku
	virtual HRESULT				Pause(); //pozastaveni prehravani
    
	//ruzne vlastnosti ogg souboru
	virtual double				GetOggFilePlayingTime() {return ov_time_total(&m_OggVorbisFile,-1);} //celkovy cas souboru
	virtual DWORD				GetOggFilePCMSize() {return m_dwPCMSize;} //vrati velikost ogg souboru v bytech
	virtual int					GetOggFileVersion() {return m_OggVorbisFile.vi->version;}
	virtual char*				GetOggFileVendor() {return m_OggVorbisFile.vc->vendor;}
	virtual int					GetCountOfOggFileComments() {return m_OggVorbisFile.vc->comments;}
	virtual char*				GetOggFileComment(int nComment);
	virtual CSoundBuffer*		GetStreamedBuffer() {return m_StreamedBuffer;}
	virtual int					GetRepeats() {return m_iRepeatCount;}
	virtual bool				SetRepeats(int iRepeatCount);
	virtual BYTE				GetStatus() {return m_bStatus;}

	virtual HRESULT				ConvertOggToWav(const char* cOggFileName,const char* cWavFileName);

	virtual HRESULT				AddRef();
	virtual HRESULT				Release();

	COggFile(void);
	~COggFile(void);
};
