#include "StdAfx.h"
#include "Common.h"
#include "Interfaces.h"
#include "OggFile.h"
#include "SoundManager.h"
#include "Manager.h"

OGGCODEC_API HRESULT CreateOggCodecObject(OGGIID InterfaceID,void** ppv)
{
	static ISoundManager* g_SoundManager = NULL;

	switch (InterfaceID)
	{
	case OGGIID_ISoundManager:
		if (!g_SoundManager)
			*ppv = g_SoundManager = new CSoundManager;
		else
			*ppv = g_SoundManager;
		((ISoundManager*)(*ppv))->AddRef();
		break;
	case OGGIID_IOggFile:
		*ppv = new COggFile;
		((IOggFile*)(*ppv))->AddRef();
		break;
	default:
		return E_NOINTERFACE;
	}

	return S_OK;
}