#pragma once

struct OggData //struktura pro ulozeni dat o nactenem ogg souboru
{
	IOggFile*	oggFile;
	DWORD		dwID; //id pomoci nehoz se bude s ogg pracovat
	DWORD		dwPlayPriority; //priorita prehravani
};

//**************************************************************************************************************
//Manager zvuku, zatim predevsim ogg souboru
//**************************************************************************************************************
class CSoundManager: public ISoundManager
{
private:
	LPDIRECTSOUND8					m_DSound; //objekt DirectSound

	std::vector <OggData*>			m_arOggFiles; //pole pro ukladani ogg souboru

	DWORD							m_dwNotifyCount; //pocet overovacich pozic
	DWORD							m_dwBufferLength; //velikost, delka bufferu v sekundach
	void							FindPlaceForOgg();
	long							GetOggPositionInArray(DWORD dwID,DWORD dwLeft,DWORD dwRight);
	//OggData* GetOggData(DWORD dwId);
	DWORD							m_dwRef;
public:
	virtual HRESULT					CreateDirectSoundSystem(HWND hWnd,DWORD dwCooperativeLevel = DSSCL_PRIORITY); //vytvoreni objektu DirectSound

	virtual HRESULT					LoadOgg(DWORD dwId,const char* cFileName); //nacteni ogg souboru
	virtual HRESULT					UnloadOgg(DWORD dwId); //uvolneni nacteneho ogg souboru
	virtual HRESULT					PlayOgg(DWORD dwId, DWORD dwPriority = 0); //spusti prehravani ogg souboru
	virtual HRESULT					StopOgg(DWORD dwId); //zastaveni prehravani ogg souboru
	virtual HRESULT					PauseOgg(DWORD dwId); //pozastaveni prehravani ogg souboru
	virtual HRESULT					StopAllOgg(); //zastaveni prehravani vsech ogg souboru
	virtual HRESULT					PauseAllOgg(); //pozastaveni prehravani vsech ogg souboru
	virtual HRESULT					CheckOggIfNeedReFillBuffer(DWORD dwId); //zjisteni zda ogg soubor potrebuje obnovit data bufferu
	virtual HRESULT					CheckAllOggIfNeedReFillBuffer(); //zjisteni zda nektery ze vsech ogg souboru potrebuje obnovit data v bufferu
	virtual bool					SetRepetsOfOgg(DWORD dwId,int dwRepeats); //nastavi pocet opakovani urciteho ogg souboru

	virtual void					HandleAppActiveStateChanges(bool bIsAppActive); //reakce na ztratu a ziskani fokusu ridici aplikace
		
	virtual LPDIRECTSOUND8			GetDirectSound() {return m_DSound;} //vraceni ukazatele na ukazatel na zarizeni DirectSound
	virtual	IOggFile*				GetOggFile(DWORD dwID);

	virtual HRESULT					AddRef();
	virtual HRESULT					Release();

	CSoundManager(void);
	~CSoundManager(void);
};
