#include "StdAfx.h"
#include "Common.h"
#include "SoundBuffer.h"
#include "Interfaces.h"
#include "oggfile.h"

//******************************************************************************************************
//Implementace tridy pro praci s ogg soubory
//
//Trida umi otevrit soubor ogg z disku a prehrat ho bez toho aby se musel cely dekodovat do pameti
//fce: trida nejdriv otevre soubor ogg pomoci fce OggOpen, vytvori zvukovy buffer o zadane velikosti v sekundach
//a dekoduje do nej data y ogg souboru, cely ho yaplni, podle poctu zadanych testovacich pozic si vytvori pole s hodnotami 
//offsetu v bufferu.
//prehravani se spusti fci OggPlay a pak je nutne porad volat dotayovaci fci CheckIfNeedRefillBuffer, ktera zjistuje zda
//hraci kurzor prekrocil urcity offset v bufferu a pokud ano, tak stara data nahradi novymi, kdyz je buffer prehran cely, 
//pusti se automaticky znovu, ale na zacatku jsou uz nahrana nova data a prehravani pokracuje

//*******************************************************************************************************
//Konstruktor
//*******************************************************************************************************
COggFile::COggFile(void)
{
	m_dwLastPlayPos = 0;			//nulovani posledni pozice hraciho kurzoru
	m_dwPlayProgress = 0;			//nulovani prubehu prehravani
	m_dwNextWriteOffset = 0;		//nulovani pozice zapisovaciho kurzoru
	m_iRepeatCount = 0;				//nastaveni poctu opakovani na nula, zvuk se prehraje jen jednou
	m_bStatus = OGGSTATUS_STOPPED;	//stav nastavime na zastaveny
	m_StreamedBuffer = NULL;
	m_dwWriteProgress = 0;
}

//*******************************************************************************************************
//Destruktor
//*******************************************************************************************************
COggFile::~COggFile(void)
{
	Close(); //zavreni ogg souboru a uvolneni zdroju ktere k jeho otevreni a prehrani byly zabrany
}
//*******************************************************************************************************
//Fce zv poet instanc rozhan na tdu
//*******************************************************************************************************
HRESULT COggFile::AddRef()
{
	return m_dwRef++;
}
//*******************************************************************************************************
//Fce uvoln rozhran
//*******************************************************************************************************
HRESULT COggFile::Release()
{
	if (m_dwRef > 0)
		m_dwRef--;

	if (m_dwRef == 0)
	{
		delete this;
		return 0;
	}
	else
		return m_dwRef;
}
//*******************************************************************************************************
//OggOpen: Fce pro otevreni ogg soubor
//*******************************************************************************************************
HRESULT COggFile::Open(const char *FileName,LPDIRECTSOUND8 lpDSound,DWORD dwNotifyCount,DWORD wBufferLength)
{
	HRESULT hRet;

	if ((m_OggFilePointer = fopen(FileName,"rb")) == NULL) //otevreni zvukoveho souboru
	{
		return -1; //vraceni chyby
	}

	//volani modifikovane fce pro otevreni ogg souboru, inicializaci dekoderu ogg
	//posledni parametr je velikost souboru, -1 znamena ze fce si velikost souboru, respektive jeho konec zjisti tim ze se presune na jeho konec
	if ((hRet = ov_open(m_OggFilePointer,&m_OggVorbisFile,NULL,0)) < 0)
	{
		return -2;
	}

	//vypocet velikosti dekodovaneho ogg souboru v bajtech
	m_dwPCMSize = (DWORD)ceil(m_OggVorbisFile.vi->channels * m_OggVorbisFile.vi->rate * ov_time_total(&m_OggVorbisFile, -1) * IBITS / 8);

	//vypiseme do logu zakladni informace o ogg soubru ktery nacitame
	//ErrorMsg.Format("Opening Ogg Vorbis File: <b>%s</b>, Channels: <b>%d</b>, Rate: <b>%ldHz</b>, Samples: <b>%I64d</b>, Serial Number: <b>%ld</b>, Bitrate: <b>%ld</b>bits",cFileName->GetBuffer(),m_OggVorbisFile.vi->channels,m_OggVorbisFile.vi->rate,ov_pcm_total(&m_OggVorbisFile,-1),ov_serialnumber(&m_OggVorbisFile,-1),ov_bitrate(&m_OggVorbisFile,-1));
	//TRACE(ErrorMsg.GetBuffer());

	//vytvoreni zvukoveho bufferu a nahrani prvnich dat
	hRet = InitBufferAndLoadFirstData(lpDSound,dwNotifyCount,wBufferLength);

	//vraceni vysledku otevirani
	return hRet;
}

//*******************************************************************************************************
//Fce pro vytvoreni zvukoveho bufferu a nacteni prvnich dat do bufferu
//*******************************************************************************************************
HRESULT COggFile::InitBufferAndLoadFirstData(LPDIRECTSOUND8 lpDSound,DWORD dwNotifyCount,DWORD wBufferLength)
{
	HRESULT hRet;
	DWORD dwBufferSize, dwNotifySize;

	//vypocet velikosti bufferu pro uchovani wBufferLength sekund zvuku
	//dalsi je vypocet velikosti bloku dat po kterych se bude buffer obnovovat, po kolika bajtech budeme do buffer
	//nahravat nova data
	//posledni je prepocet velikosti bufferu, pokud bude zadan nesikovne pocet obnoveni bufferu, muze nam dojit pri deleni k zaokrouhleni
	//protoze se pracuje s celymi cisly
	dwBufferSize = (DWORD)ceil(float(m_OggVorbisFile.vi->channels * m_OggVorbisFile.vi->rate * wBufferLength * IBITS / 8));
	dwNotifySize = (DWORD)dwBufferSize / dwNotifyCount;
    m_dwBufferSize = dwBufferSize = dwNotifyCount * dwNotifySize;

	m_dwNotifySize = dwNotifySize;		//ulozeni poctu obnoveni bufferu za jedno jeho prehrani

	WAVEFORMATEX wfx;					//struktura pro definovani formatu zvuku
	ZeroMemory(&wfx,sizeof(wfx));		//nulovani pameti
	wfx.cbSize = sizeof(wfx);			//dulezite, nataveni velikosti struktury
	wfx.wFormatTag = WAVE_FORMAT_PCM;	//format dat - klasicke nekomprimovane data, PCM jako u wave
	wfx.nChannels = m_OggVorbisFile.vi->channels;	//pocet kanalu
	wfx.nSamplesPerSec = m_OggVorbisFile.vi->rate;	//pocet vzorku za sekundu
	wfx.nAvgBytesPerSec = m_OggVorbisFile.vi->channels * m_OggVorbisFile.vi->rate * IBITS / 8;
	wfx.nBlockAlign = m_OggVorbisFile.vi->channels * IBITS / 8;
	wfx.wBitsPerSample = IBITS;			//bitu na vzorek

	DSBUFFERDESC dsBufferDesc;			//struktura obsahujici popis zvukove bufferu - Buffer Description
	ZeroMemory(&dsBufferDesc,sizeof(dsBufferDesc));
	dsBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	dsBufferDesc.dwBufferBytes = dwBufferSize;		//velikost zvukoveho bufferu
	//v priznacich nastavime co vsechno chceme aby buffer umoznoval, umel
	//DSBCAPS_CTRLPAN - chci mit moznost ridit vyvazeni leveho a praveho kanalu
	//DSBCAPS_CTRLVOLUME - chci mit moznost ridit hlasitost
	//DSBCAPS_CTRLFREQUENCY - chci mit moznst zmenit frekvenci, kmitocet
	//DSBCAPS_GETCURENTPOSITION2 - chci mit moznost ptat se na pozici hraciho kurzoru, tato volba je nezbatne nutna pro
	//implementaci streamovaneho bufferu, bez tech predchozich se obejdeme
	dsBufferDesc.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_GETCURRENTPOSITION2;
	dsBufferDesc.lpwfxFormat = &wfx;			//format audio dat, viz struktura inicilizovana vyse

	m_StreamedBuffer = new CSoundBuffer;		//vytvoreni noveho objektu zvukoveho bufferu

	if (!m_StreamedBuffer)						//kontrolaukazatele aneb byl objekt vytvoren
	{
		//TRACE("Error: Cannot create Sound Buffer!");
		return -3;
	}

	//zavolani metody create tridy CSoundBuffer pro vytvoreni bufferu, vsechno co chce je vyse inicilizovana struktura
	//uchovavajici popis bufferu
	if(FAILED(hRet = m_StreamedBuffer->Create(lpDSound,&dsBufferDesc)))
		return hRet;
	
	//ted naplneni bufferu daty z ogg souboru
	//nejdriv se radsi presuneme na zacatek souboru, pro jistotu
	hRet = ov_raw_seek(&m_OggVorbisFile,1);

	//zapsani dat do bufferu
	WriteDataToBuffer(0,m_dwBufferSize,NULL);

	return S_OK;
}

//***************************************************************************************************************
//Fce pro zapsani dat do zvukoveho bufferu
//***************************************************************************************************************
bool COggFile::WriteDataToBuffer(DWORD dwOffset,DWORD dwBytes,DWORD* dwBytesRead)
{
	LPVOID lpvPtr1 = NULL;				//ukazatel na prvni cast pameti pro zapis do bufferu
	DWORD  DataSize1 = 0;				//velikost dat ktera se zapisi do prvni casti
	LPVOID lpvPtr2 = NULL;				//ukazatel na druhou cast pameti pro zapis do bufferu
	DWORD  DataSize2 = 0;				//velikost dat ktera se zapisi do druhe casti	
	long   lBytesRead = 0;				//pocet prectenzch bajtu souboru
	DWORD  lSize = 0;					
	int    iCurrStream = 0;
	HRESULT hRet;


	//nejdriv dekodujeme potrebnou cast ogg souboru
	char* DataBuffer = new char[dwBytes];

	while ((lBytesRead = ov_read(&m_OggVorbisFile,DataBuffer + lSize,dwBytes - lSize,IENDBITS,IBITS / 8,ISIGNED,&iCurrStream)) != 0)
	{
		if (lBytesRead < 0 && !IQUIET)
		{
			if ((lBytesRead != OV_HOLE) && (lBytesRead != OV_EBADLINK))
				break;
			continue;
		}

		lSize += lBytesRead;
	}

	if (dwBytesRead)
		*dwBytesRead = dwBytes - lSize;

	m_dwWriteProgress += lSize;
	
	//ted zapsani dat do sound bufferu
	hRet = m_StreamedBuffer->GetBuffer()->Lock(dwOffset,lSize,&lpvPtr1,&DataSize1,&lpvPtr2,&DataSize2,0L);

	//if (DataSize1 != dwBytes)
	//	WriteToDebugFile(__FILE__,__LINE__,"Cannot copy all data!",true);

	if (hRet == DSERR_BUFFERLOST)
	{
		m_StreamedBuffer->RestoreBuffer(NULL);
		hRet = m_StreamedBuffer->GetBuffer()->Lock(dwOffset,dwBytes,&lpvPtr1,&DataSize1,&lpvPtr2,&DataSize2,0L);
	}

	if (SUCCEEDED(hRet))
	{
		CopyMemory(lpvPtr1,DataBuffer,DataSize1);
		if (lpvPtr2 != NULL)
		{
			CopyMemory(lpvPtr2,DataBuffer + DataSize1,DataSize2);
		}

		hRet = m_StreamedBuffer->GetBuffer()->Unlock(lpvPtr1,DataSize1,lpvPtr2,DataSize2);

		if (SUCCEEDED(hRet))
		{
			SAFE_DELETE_ARRAY(DataBuffer);
			return true;
		}
	}

	SAFE_DELETE_ARRAY(DataBuffer);
	return false;
}

//**********************************************************************************************************
//Fce pro kontrolu nutnosti zapisu novych dat do bufferu
//**********************************************************************************************************
HRESULT COggFile::CheckIfNeedReFillBuffer()
{
	HRESULT hRet = S_FALSE;
	bool    bRet = false;
	DWORD dwCurrPlayPos = 0;
	DWORD dwDataDelta = 0;
	DWORD dwCursorsDistance = 0;

	if (m_StreamedBuffer->IsSoundPlaying() || m_bStatus == OGGSTATUS_PAUSED)
	{
		//ziskani aktualni pozice hraciho kurzoru
		if(FAILED(hRet = m_StreamedBuffer->GetBuffer()->GetCurrentPosition(&dwCurrPlayPos,NULL)))
			return hRet;

		if ((m_dwPlayProgress + dwCurrPlayPos) >= m_dwPCMSize) //tady to se zpracovava pokud dojde k prehrani celeho souboru
		{
			hRet = m_StreamedBuffer->Stop(); //pokud dojde k prehrani celeho souboru, zastavime prehravani bufferu
			hRet = m_StreamedBuffer->Reset(); //a resetujeme buffer a prislusne promenne
			m_dwNextWriteOffset = 0; //zapis bude zacinat opet na nule
			m_dwPlayProgress = 0; //stejne tak pocet prehranzch bytu je nula
			m_dwLastPlayPos = 0; //posledni pozice hraciho kurzoru taktez
			dwCursorsDistance = 0; //vzdalenost hraciho a zapisovaciho kurzoru taktez nulova
			dwCurrPlayPos = 0;
			m_dwWriteProgress = 0;
			ov_raw_seek(&m_OggVorbisFile,0); //presun na zacatek v ogg souboru
			WriteDataToBuffer(0,m_dwBufferSize,NULL); //naplneni bufferu daty z ogg souboru od zacatku, kdyby byla pozdeji spustena fce play 
											//tak at to tam je
			if (!m_iRepeatCount)		//pokud je pocet opakovani 0
			{
				//nastavime stav zastaveno
				m_bStatus = OGGSTATUS_STOPPED;
				return S_FALSE; //vratime false jako indikaci ze nedoslo k obnoveni dat v bufferu
			}

			if (m_iRepeatCount != OGGPLAY_REPEATINFINITE) //pokud pocet opakovani neni nula  a neni ani roven konstante pro
				m_iRepeatCount--;	//nekonecno opakovani, snizime pocet opakovani

			hRet = m_StreamedBuffer->Play(0,DSBPLAY_LOOPING); //zacneme znovu prehravat buffer, pac se este neprehral tolikrat jak je nastaveno
			return hRet;
		}

		//pokud je posledni ulozena pozice hraciho kurzoru vetsi nez pozice kurzoru aktualni, znamena to ze
		//buffer dosahl konce a preskocil zpet na zacatek, podle toho musime pocitat vzdalenost kurzoru rozdilne
		if (m_dwLastPlayPos > dwCurrPlayPos)
			//hraci kurzor presel zpet na zacatek, musime vypocitat kolik bytu zbylo na konci bufferu neaktualizovanzch od posledni aktualizace
			//a pricist k nim pocet bytu co uz byly prehrany znova od zacatku a tak ziskame vzdalenost kurzoru
			//vzdalenost mezi hracim a zapisovacim kurzorem
			dwCursorsDistance = (m_dwBufferSize - m_dwNextWriteOffset) + dwCurrPlayPos;
		else
			//hraci kurzor je pred koncem, zapisovaci za nim, vzdalenost je rozdil jejich pozic
			//abychom nepocitali i bajt na kterem hraci kurzor zrovna je
			dwCursorsDistance = dwCurrPlayPos - m_dwNextWriteOffset;
	
		//ted se mrknem jestli vzdalenost kurzoru presahla pocet bajtu po kterych se ma buffer obnovovat
		if (dwCursorsDistance >= m_dwNotifySize) //a pokud ano, zapiseme do bufferu tolik bytu jako je vzdalenost kurzoru
		{	
			if (m_dwWriteProgress < m_dwPCMSize)
			{		
				bRet = WriteDataToBuffer(m_dwNextWriteOffset,dwCursorsDistance - 1,&dwDataDelta); //hraciho kurzoru, tedy mela by, muze se stat
													//vzdalenost mezi kurzory bude licha a v tom pripade nam fce ov_read ktera dekoduje ogg soubor
				//m_StreamedBuffer->Play(0,DSBPLAY_LOOPING);
				m_dwNextWriteOffset += dwCursorsDistance - 1 - dwDataDelta; //vrati o nekolik bytu min, dekoduje totiz vzdy sudy pocet a ten pocet bajtu
														//musime snizit pozici dalsiho zapisovani, aby nevznikla jakasi dira, viz dwDataDelta
				if (m_dwNextWriteOffset >= m_dwBufferSize) //tady se hlida situace kdy je psaci kurzor skoro na konci a jeho aktualizaci o pocet zapanzch bajtu by doslo k prekroceni bufferu
					m_dwNextWriteOffset -= m_dwBufferSize; //odecteme proto velikost bufferu a psaci kurzor se dostane na spravnou pozici od zacatku bufferu
			}

			if (m_dwLastPlayPos > dwCurrPlayPos)
				m_dwPlayProgress += m_dwBufferSize;
			
			m_dwLastPlayPos = dwCurrPlayPos; //aktualizace posledni pozice hraciho kurzoru
		}
	}

	return hRet;
}

//**********************************************************************************************************
//Funkce pro zavreni ogg souboru
//**********************************************************************************************************
HRESULT COggFile::Close()
{
	ov_clear(&m_OggVorbisFile);

	return 0;
}

//**********************************************************************************************************
//Funkce pro prevod ogg-wav
//**********************************************************************************************************
HRESULT COggFile::ConvertOggToWav(const char* cOggFileName,const char* cWavFileName)
{
	char AudioData[4096]; //buffer pro nacitani dat, 4096 je maximalni pocet bytu kolik nacte fce ov_read pri jednom volani

	OggVorbis_File	OggVorbisFile; //struktura OggVorbisFiloe ktera obsahuje informace o ogg souboru
	FILE*			FilePointer;  //ukazatel na soubor
	FILE*			OutputFilePointer; //ukazatel na vystupni soubor

	if ((FilePointer = fopen(cOggFileName,"rb")) == NULL) //ogg soubor musime nejdriv otvrit pres normalni fopen a pak zavolat
		return -1;											//ov%open, ktera naplni strukturu OggVorbisFile

	if ((OutputFilePointer = fopen(cWavFileName,"wb")) == NULL) //otevreni vystupniho souboru
		return -2;

	if ((ov_open(FilePointer,&OggVorbisFile,NULL,0) < 0)) //naplneni struktury OggVorbisFile, precteni hlavicky ogg souboru
		return -3;

	//spocitani velikosti dekodovaneho zvuku, to musiem ulozit do wav hlavicky
	long iDataSize = (long)ceil(OggVorbisFile.vi->channels * OggVorbisFile.vi->rate * ov_time_total(&OggVorbisFile, -1) * IBITS/8);

	//velikost wav souboru,audio data + hlavicka
	int riffSize = iDataSize + IWAVEHEADERSIZE;
    int ckSize = sizeof(WAVEFORMATEX); //velikost struktury WAVEFORMATEX
	WAVEFORMATEX WaveFormat;
	WaveFormat.cbSize = ckSize; //nastaveni velikosti
	WaveFormat.wFormatTag = WAVE_FORMAT_PCM; //format nastavime na normalni nekomprimovany wav
	WaveFormat.nChannels = OggVorbisFile.vi->channels; //nastaveni poctu kanalu
	WaveFormat.nSamplesPerSec = OggVorbisFile.vi->rate; //pocet vzorku za sekundu
	WaveFormat.nAvgBytesPerSec = OggVorbisFile.vi->rate * OggVorbisFile.vi->channels * IBITS / 8; //prumerne bytu za sekundu
	WaveFormat.nBlockAlign = OggVorbisFile.vi->channels * IBITS / 8;
	WaveFormat.wBitsPerSample = IBITS; //pocet bitu na vzorek
	
	//ukladani dat z hlavicky do vystupniho souboru
	fprintf(OutputFilePointer,"RIFF"); 
	fwrite(&riffSize,1,sizeof(riffSize),OutputFilePointer);
	fprintf(OutputFilePointer,"WAVE");
	fprintf(OutputFilePointer,"fmt ");
	fwrite(&ckSize,1,sizeof(ckSize),OutputFilePointer);
	fwrite(&WaveFormat,1,sizeof(WaveFormat),OutputFilePointer);
	fprintf(OutputFilePointer,"data");
	fwrite(&iDataSize,1,sizeof(iDataSize),OutputFilePointer);

	long iBytesRead; //sem se bude ukladat kolik bytu bylo precteno z ogg souboru
	long iSize = 0; //pocet celkem nactenych bytu
	int iCurrSection; //aktualni cislo logickeho proudu v ogg souboru

	//cyklus pro nacitani a dekodovani ogg audio dat, o dekodovani se stara fce ov_read, cyklus pokracuje tak dlouho dokud fce vraci ze precetla vic jak 0 bytu
	while ((iBytesRead = ov_read(&OggVorbisFile, AudioData, iDataSize - iSize,IENDBITS,IBITS / 8,ISIGNED,&iCurrSection)) != 0)
	{
		if (iBytesRead < 0 && !IQUIET)
			continue;

		iSize += iBytesRead; //aktualizace poctu nactenych bytu

		//ulozeni dekodovanych dat z bufferu, pameti do souboru
		fwrite(AudioData,1,iBytesRead,OutputFilePointer);
	}

	//dekodovani je hotovo, zavreni ogg souboru
	fclose(FilePointer);
	//zavreni vystupniho wav souboru
	fclose(OutputFilePointer);
    
	//klizeni struktury OggVorbisFile
	ov_clear(&OggVorbisFile);

	//vraceni 0, dekodovani probehlo uspesne
	return 0;
}

//**********************************************************************************************************
//Vrati komentar z ogg souboru
//**********************************************************************************************************
char* COggFile::GetOggFileComment(int nComment)
{
	if (nComment > m_OggVorbisFile.vc->comments)
		return 0;

	return m_OggVorbisFile.vc->user_comments[nComment];
}
//**********************************************************************************************************
//Nastavi pocet opakovani prehravani
//**********************************************************************************************************
bool COggFile::SetRepeats(int iRepeatCount)
{
	if (iRepeatCount < OGGPLAY_REPEATINFINITE)
		return false;

	m_iRepeatCount = iRepeatCount;
	return true;
}
//**********************************************************************************************************
//Spusti prehravani
//**********************************************************************************************************
HRESULT COggFile::Play(DWORD dwPriority)
{
	m_bStatus = OGGSTATUS_PLAYING;
	return m_StreamedBuffer->Play(dwPriority,DSBPLAY_LOOPING);
}
//**********************************************************************************************************
//Zastavi prehravani
//**********************************************************************************************************
HRESULT COggFile::Stop()
{
	m_bStatus = OGGSTATUS_STOPPED;
	return m_StreamedBuffer->Stop();
}
//**********************************************************************************************************
//Pozastavi prehravani
//**********************************************************************************************************
HRESULT COggFile::Pause()
{
	m_bStatus = OGGSTATUS_PAUSED;
	return m_StreamedBuffer->Stop();
}