#include "StdAfx.h"
#include "Common.h"
#include "Interfaces.h"
#include "OggFile.h"
#include "Manager.h"
#include "soundmanager.h"

//*************************************************************************************************************
//Konstruktor
//*************************************************************************************************************
CSoundManager::CSoundManager(void)
{
	m_DSound = NULL;
	m_dwBufferLength = 3;
	m_dwNotifyCount = 16;
	m_dwRef = 0;
}

//*************************************************************************************************************
//Destruktor
//*************************************************************************************************************
CSoundManager::~CSoundManager(void)
{
	StopAllOgg();

	for (UINT i = 0; i < m_arOggFiles.size(); i++)
	{
		OggData* TmpPtr = (OggData*)m_arOggFiles[i];
		SAFE_RELEASE(TmpPtr->oggFile);
		SAFE_DELETE(TmpPtr);
	}

	m_arOggFiles.clear();

	SAFE_RELEASE(m_DSound);
}

//*************************************************************************************************************
//Nova instance
//*************************************************************************************************************
HRESULT CSoundManager::AddRef()
{
	return m_dwRef++;
}

//*************************************************************************************************************
//Uvolneni instance
//*************************************************************************************************************
HRESULT CSoundManager::Release()
{
	if (m_dwRef > 0)
		m_dwRef--;

	if (!m_dwRef)
	{
		delete this;
		return 0;
	}
	else
		return m_dwRef;
}

//*************************************************************************************************************
//Zprovozneni DirectSound
//*************************************************************************************************************
HRESULT CSoundManager::CreateDirectSoundSystem(HWND hWnd,DWORD dwCooperativeLevel)
{
	HRESULT hRet = DS_OK;

	if (FAILED(hRet = DirectSoundCreate8(NULL,&m_DSound,NULL)))
		return hRet;

	hRet = m_DSound->SetCooperativeLevel(hWnd,dwCooperativeLevel);

	return hRet;
}

//*************************************************************************************************************
//Nacteni ogg souboru
//*************************************************************************************************************
HRESULT CSoundManager::LoadOgg(DWORD dwId,const char* cFileName)
{
	HRESULT hRet = S_OK;
	//kontrola jestli uz ogg se stejnym id neni v seznamu
	if (GetOggPositionInArray(dwId,0,(DWORD)m_arOggFiles.size()-1) >= 0)
		return S_FALSE;

	OggData* TmpPtr = new OggData;
	if (!TmpPtr)
		return E_OUTOFMEMORY;

	CreateOggCodecObject(OGGIID_IOggFile,(void**)&(TmpPtr->oggFile));
	if (!TmpPtr->oggFile)
	{
		SAFE_DELETE(TmpPtr);
		return E_OUTOFMEMORY;
	}

	if(FAILED(hRet = TmpPtr->oggFile->Open(cFileName,m_DSound,m_dwNotifyCount,m_dwBufferLength)))
	{
		SAFE_DELETE(TmpPtr);
		return hRet;
	}

	TmpPtr->dwID = dwId;
	TmpPtr->dwPlayPriority = 0;

	m_arOggFiles.push_back(TmpPtr);

	FindPlaceForOgg(); //setrideni polozek

	return hRet;
}

//*************************************************************************************************************
//Zavreni ogg souboru a odstraneni zaznamu z pole
//*************************************************************************************************************
HRESULT CSoundManager::UnloadOgg(DWORD dwId)
{
	long i;
	UINT j;
	bool bWasFind = false;
	OggData* TmpPtr;

	if ((i = (UINT)GetOggPositionInArray(dwId,0,(DWORD)m_arOggFiles.size()-1)) >= 0)
		bWasFind = true;

	if (bWasFind)
	{
		TmpPtr = (OggData*)m_arOggFiles[i];

		for (j = i; j < m_arOggFiles.size() - 1; j++)
		{
			m_arOggFiles[j] = m_arOggFiles[j+1];
		}

		SAFE_RELEASE(TmpPtr->oggFile);
		SAFE_DELETE(TmpPtr);
		m_arOggFiles.pop_back();

		return 0;
	}

	return -1;
}
//*************************************************************************************************************
//Spusti prehravani
//*************************************************************************************************************
HRESULT CSoundManager::PlayOgg(DWORD dwId,DWORD dwPriority)
{
	OggData* tmpPtr;
	long	 index;

	index = GetOggPositionInArray(dwId,0,(DWORD)m_arOggFiles.size()-1);
	if (index >= 0)
	{
		tmpPtr = (OggData*)m_arOggFiles[index];
		return tmpPtr->oggFile->Play(dwPriority);
	}

	return -1;
}

HRESULT CSoundManager::StopOgg(DWORD dwId)
{
	OggData* tmpPtr;
	long	 index;

	index = GetOggPositionInArray(dwId,0,(DWORD)m_arOggFiles.size()-1);
	if (index >= 0)
	{
		tmpPtr = (OggData*)m_arOggFiles[index];
		return tmpPtr->oggFile->Stop();
	}

	return -1;
}

IOggFile* CSoundManager::GetOggFile(DWORD dwID)
{
	OggData*	tmpPtr;
	long		index;

	index = GetOggPositionInArray(dwID,0,(DWORD)m_arOggFiles.size() - 1);
	if (index >= 0)
	{
		tmpPtr = (OggData*)m_arOggFiles[index];
		return tmpPtr->oggFile;
	}

	return NULL;
}

HRESULT CSoundManager::PauseOgg(DWORD dwId)
{
	OggData* tmpPtr;
	long	 index;

	index = GetOggPositionInArray(dwId,0,(DWORD)m_arOggFiles.size()-1);
	if (index >= 0)
	{
		tmpPtr = (OggData*)m_arOggFiles[index];
		return tmpPtr->oggFile->Pause();
	}

	return -1;
}

HRESULT CSoundManager::StopAllOgg()
{
	HRESULT hRet;

	for (UINT i = 0; i < m_arOggFiles.size(); i++)
	{
		OggData* TmpPtr = (OggData*)m_arOggFiles[i];
		if (TmpPtr)			
			hRet &= TmpPtr->oggFile->Stop();
	}

	return hRet;
}

HRESULT CSoundManager::PauseAllOgg()
{
	HRESULT hRet;

	for (UINT i = 0; i < m_arOggFiles.size(); i++)
	{
		OggData* TmpPtr = (OggData*)m_arOggFiles[i];
		if (TmpPtr)
			hRet &= TmpPtr->oggFile->Pause();
	}

	return hRet;
}

HRESULT CSoundManager::CheckOggIfNeedReFillBuffer(DWORD dwId)
{
	for (UINT i = 0; i < m_arOggFiles.size(); i++)
	{
		OggData* TmpPtr = (OggData*)m_arOggFiles[i];
		if (TmpPtr)
			if (TmpPtr->dwID == dwId)
				return TmpPtr->oggFile->CheckIfNeedReFillBuffer();
	}

	return -1;
}

HRESULT CSoundManager::CheckAllOggIfNeedReFillBuffer()
{
	HRESULT hRet;

	for (UINT i = 0; i < m_arOggFiles.size(); i++)
	{
		OggData* TmpPtr = (OggData*)m_arOggFiles[i];
		if (TmpPtr)
			hRet &= TmpPtr->oggFile->CheckIfNeedReFillBuffer();
	}

	return hRet;
}

void CSoundManager::HandleAppActiveStateChanges(bool bIsAppActive)
{
	if (bIsAppActive) //ridici aplikace ma fokus
	{
		for (UINT i = 0; i < m_arOggFiles.size(); i++)
		{
			OggData* TmpPtr = (OggData*)m_arOggFiles[i];
			if (TmpPtr)
			{
				if (TmpPtr->oggFile->GetStatus() == OGGSTATUS_PAUSED)
					TmpPtr->oggFile->Play(TmpPtr->dwPlayPriority);
			}
		}
	}
	else //ridici aplikace nema fokus
	{
		for (UINT i = 0; i < m_arOggFiles.size(); i++)
		{
			OggData* TmpPtr = (OggData*)m_arOggFiles[i];
			if (TmpPtr)
			{
				if (TmpPtr->oggFile->GetStatus() == OGGSTATUS_PLAYING)
					TmpPtr->oggFile->Pause();
			}
		}
	}
}

bool CSoundManager::SetRepetsOfOgg(DWORD dwId,int iRepeats)
{
	OggData* tmpPtr;
	long	 index;

	index = GetOggPositionInArray(dwId,0,(DWORD)m_arOggFiles.size()-1);
	if (index >= 0)
	{
		tmpPtr = (OggData*)m_arOggFiles[index];
		return tmpPtr->oggFile->SetRepeats(iRepeats);
	}

	return false;
}

void CSoundManager::FindPlaceForOgg()
{
	OggData* ptrChange; //pro vymenu prvku

	if (m_arOggFiles.size() < 2)
		return;
	//staci prochazet pole od konce a hledat misto pro prvek
	for (UINT i = (UINT)m_arOggFiles.size() - 1; i > 0; i--)
	{
		OggData* ptrTmp = (OggData*)m_arOggFiles[i - 1];
		OggData* ptrTmp2 = (OggData*)m_arOggFiles[i];
		if (ptrTmp2->dwID < ptrTmp->dwID)
		{
			ptrChange = ptrTmp2;
			m_arOggFiles[i] = m_arOggFiles[i-1];
			m_arOggFiles[i-1] = ptrChange;
		}
	}
}

long CSoundManager::GetOggPositionInArray(DWORD dwID,DWORD dwLeft,DWORD dwRight)
{
	UINT Middle;
	OggData* ptrTmp;

	if (m_arOggFiles.size() < 1)
		return -1;

	Middle = (dwLeft + dwRight) / 2;

	ptrTmp = (OggData*)m_arOggFiles[Middle];

	if (dwLeft <= dwRight)
	{
		if (ptrTmp->dwID > dwID)
			return GetOggPositionInArray(dwID,dwLeft,Middle - 1);
		if (ptrTmp->dwID < dwID)
			return GetOggPositionInArray(dwID,Middle + 1,dwRight);

		return Middle;
	}
	
	return -1;
}
