/*
 * DHTSensors.cpp
 *
 *  Created on: Feb 20, 2025
 *      Author: Murdock
 */

#include "DHTSensors.h"

DHTSensors::DHTSensors(byte insideSensorPin, byte insideSensorType, byte outsideSensorPin, byte outsideSensorType , word insideMeasurementInterval, word outsideMeasurementInterval) :
	insideSensorPin(insideSensorPin), insideSensorType(insideSensorType), outsideSensorPin(outsideSensorPin), outsideSensorType(outsideSensorType), insideMeasurementInterval(insideMeasurementInterval),
	outsideMeasurementInterval(outsideMeasurementInterval), lastInsideMeasurementTime(0), lastOutsideMeasurementTime(0),
	insideTemperature(NAN), insideHumidity(NAN), outsideTemperature(NAN), outsideHumidity(NAN), insideSensor(insideSensorPin, insideSensorType), outsideSensor(outsideSensorPin, outsideSensorType) {
}

void DHTSensors::readInsideEnvironment() {
	unsigned long currTime = millis();
	if ((currTime - lastInsideMeasurementTime) > insideMeasurementInterval) {
		insideTemperature = insideSensor.readTemperature();
		insideHumidity = insideSensor.readHumidity();

		lastOutsideMeasurementTime = currTime;
	}
}

void DHTSensors::readOutsideEnvironment() {
	unsigned long currTime = millis();
	if ((currTime - lastOutsideMeasurementTime) > outsideMeasurementInterval) {
		outsideTemperature = outsideSensor.readTemperature();
		outsideHumidity = outsideSensor.readHumidity();

		lastOutsideMeasurementTime = millis();
	}
}

void DHTSensors::readEnvironments() {
	readInsideEnvironment();
	readOutsideEnvironment();
}
