#ifndef LCDHELPER_H
#define LCDHELPER_H

#include <Arduino.h>
#include <stdarg.h>

// Generic base class for LCD helper functionalities
class LCDHelper {
public:
	// Virtual destructor for proper cleanup
	virtual ~LCDHelper() {
	}

	// Pure virtual methods to be implemented by derived classes
	virtual void printTextToLCD(const char *text, byte row) = 0;
	virtual void printFormattedTextToLCD(byte row, const char* fmt, ...) = 0;
	virtual void displayFloatValue(const char *title, float value, const char *unit) = 0;
	virtual void displayFloatValue(const char *title, float value, const char *unit, byte precision, byte row) = 0;
	virtual void display2FloatValues(const char *title1, float value1, const char *unit1, byte precision1, const char *title2, float value2, const char *unit2, byte precision2, byte row) = 0;
	virtual void displayByteValue(const char *title, byte value, const char *unit) = 0;
	virtual void displayByteValue(const char *title, byte value, const char *unit, byte row) = 0;
	virtual void displayWordValue(const char *title, word value, const char *unit) = 0;
	virtual void displayWordValue(const char *title, word value, const char *unit, byte row) = 0;
	virtual void clear() = 0;
	virtual void clearRow(byte row) = 0;
};

#endif
