#ifndef DHT_SENSORS_H
#define DHT_SENSORS_H

#include <DHT.h>
#include "common.h"

constexpr word DEFAULT_MEASUREMENT_INTERVAL = 2000;

class DHTSensors {
private:
	DHT insideSensor;
	DHT outsideSensor;

    byte insideSensorPin;
    byte outsideSensorPin;
    byte insideSensorType;
    byte outsideSensorType;

    float insideTemperature;
    float insideHumidity;
    float outsideTemperature;
    float outsideHumidity;

    word insideMeasurementInterval;
    word outsideMeasurementInterval;
    unsigned long lastInsideMeasurementTime;
    unsigned long lastOutsideMeasurementTime;

public:
    // Constants for invalid sensor readings

	DHTSensors(byte insideSensorPin, byte insideSensorType, byte outsideSensorPin, byte outsideSensorType , word measurementInterval, word outsideMeasurementInterval);


    void readInsideEnvironment();
    void readOutsideEnvironment();
    void readEnvironments();

    float getInsideTemperature() const { return insideTemperature; }
    float getInsideHumidity() const { return insideHumidity; }
    float getOutsideTemperature() const { return outsideTemperature; }
    float getOutsideHumidity() const { return outsideHumidity; }

    bool isInsideValid() const { return isnan(insideTemperature) && isnan(insideHumidity); }
    bool isOutsideValid() const { return isnan(outsideTemperature) && isnan(outsideHumidity); }
    bool areValuesValid() const { return isInsideValid() && isOutsideValid(); }
};

#endif
