/*
 * DHTSensors.cpp
 *
 *  Created on: Feb 20, 2025
 *      Author: Murdock
 */

#include "DHTAsyncSensors.h"

DHTAsyncSensors::DHTAsyncSensors(byte insideSensorPin, byte insideSensorType, byte outsideSensorPin, byte outsideSensorType , word insideMeasurementInterval, word outsideMeasurementInterval) :
	insideSensorPin(insideSensorPin), insideSensorType(insideSensorType), outsideSensorPin(outsideSensorPin), outsideSensorType(outsideSensorType), insideMeasurementInterval(insideMeasurementInterval),
	outsideMeasurementInterval(outsideMeasurementInterval), lastInsideMeasurementTime(0), lastOutsideMeasurementTime(0),
	insideTemperature(NAN), insideHumidity(NAN), outsideTemperature(NAN), outsideHumidity(NAN),
	insideSensor(insideSensorPin, insideSensorType), outsideSensor(outsideSensorPin, outsideSensorType) {}


bool DHTAsyncSensors::measureInsideEnvironment() {
	//if it is time to update the values...
	unsigned long currTime = millis();

	if (currTime - lastInsideMeasurementTime > insideMeasurementInterval) {
		float temperature;
		float humidity;

		//this should be non-blocking function to read the sensor values
		bool insideUpdated = insideSensor.measure(&temperature, &humidity);

		if (insideUpdated) {
			lastInsideMeasurementTime = millis();
			insideTemperature = temperature;
			insideHumidity = humidity;
			return true;
		} else if (currTime - lastInsideMeasurementTime > READ_FAIL_TRESHOLD) {
			//looks like we failed to read data for prolonged period of time
			//this would print too often when failed to read sensor for any reason, we will find out by NaN
			//DEBUG_PRINTLN_F(F("Reading inside temperature/humidity sensor FAILED..."));
			insideTemperature = NAN;
			insideHumidity = NAN;
		}
	}
	return false;
}

bool DHTAsyncSensors::measureOutsideEnvironment() {
	unsigned long currTime = millis();

	if (currTime - lastOutsideMeasurementTime > outsideMeasurementInterval) {
		float temperature;
		float humidity;

		//this should be non-blocking function to read the sensor values
		bool outsideUpdated = outsideSensor.measure(&temperature, &humidity);

		/*#ifdef MK4SC_DEBUG
			// Debug output
			static unsigned long lastDebugTime = 0;

			if (DEBUG_TIME_ELAPSED(2000, lastDebugTime)) {
				char valueStr[10];
				dtostrf(temperature, 0, 2, valueStr);

				DEBUG_PRINT_F(F("OT res: %s, temp: %s"), outsideUpdated ? STR_YES : STR_NO, valueStr);

				dtostrf(humidity, 0, 2, valueStr);

				DEBUG_PRINTLN_F(F(", hum: %s"), valueStr);

				DEBUG_RESET_TIME(lastDebugTime);
			}

        #endif*/

		if (outsideUpdated) {
			lastOutsideMeasurementTime = currTime;
			outsideTemperature = temperature;
			outsideHumidity = humidity;
			return true;
		} /*else {
			//looks like we failed to read data for prolonged period of time
			//this would print too often when failed to read sensor for any reason, we will find out by NaN
			//DEBUG_PRINTLN_F(F("Reading outside temperature/humidity sensor FAILED..."));
			outsideTemperature = NAN;
			outsideHumidity = NAN;
		}*/
	}
	return false;
}

bool DHTAsyncSensors::measureEnvironments() {
	bool bRet = true;

	bRet &= measureInsideEnvironment();
	bRet &= measureOutsideEnvironment();

	return bRet;
}
