/*
 * InfoDisplay.h
 *
 *  Created on: Mar 3, 2025
 *      Author: Murdock
 */

#ifndef INFODISPLAY_H_
#define INFODISPLAY_H_

#include <Arduino.h>
#include <RotaryEncoder.h>
#include "common.h"
#include "DHTAsyncSensors.h"
#include "SettingsManager.h"
#include "MQ2GasSensorNonBlocking.h"
#include "LCDHelper.h"
#include "FireWatch.h"
#include "VentilationControl.h"
#include "Utils.h"

extern const char STR_IATH_TITLE[] PROGMEM;
extern const char STR_OATH_TITLE[] PROGMEM;
extern const char STR_GASSENS_TITLE[] PROGMEM;
extern const char STR_VENT1_TITLE[] PROGMEM;
extern const char STR_VENT2_TITLE[] PROGMEM;
extern const char STR_VENT3_TITLE[] PROGMEM;
extern const char STR_LIGHT_TITLE[] PROGMEM;
extern const char STR_POWERREL_TITLE[] PROGMEM;
extern const char STR_FIREDET_TITLE[] PROGMEM;
extern const char STR_ARDMEM_TITLE[] PROGMEM;
extern const char STR_AUTO_MODE_UNABLE_TSENS_E[] PROGMEM;

class InfoDisplay {
private:
	RotaryEncoder* encoder;
	DHTAsyncSensors* dhtSensors;
	SettingsManager* settingsManager;
	MQ2GasSensorNonBlocking* gasSensor;
	FireWatch* fireWatch;
	VentilationControl* ventControl;
	LCDHelper* lcdHelper;

	unsigned long infoPageDisplayTime;
	unsigned long lastInfoPageSwitchTime;

	byte currInfoPage;
	long lastEncoderPos;

	void displayInfoPage_IATH();
	void displayInfoPage_OATH();
	void displayInfoPage_GasSens();
	void displayInfoPage_Vent1();
	void displayInfoPage_Vent2();
	void displayInfoPage_Vent3();
	void displayInfoPage_Light();
	void displayInfoPage_PowerRelay();
	void displayInfoPage_Fire();
	void displayInfoPage_Memory();
public:
	static constexpr byte INFO_PAGE_IATH = 0;    //info page inside air temperature and humidity
	static constexpr byte INFO_PAGE_OATH = 1;    //info page outside air temperature and humidity
	static constexpr byte INFO_PAGE_GASSENS = 2;   //info page on smoke detection
	static constexpr byte INFO_PAGE_VENT1 = 3;    //info page on ventilation
	static constexpr byte INFO_PAGE_VENT2 = 4;    //info page on ventilation
	static constexpr byte INFO_PAGE_VENT3 = 5;    //info page on ventilation
	static constexpr byte INFO_PAGE_LIGHT = 6;   //info page on lighting
	static constexpr byte INFO_PAGE_POWER_RELAY = 7; //info about power relay
	static constexpr byte INFO_PAGE_FIRE = 8;	//info page about fire hazard
	static constexpr byte INFO_PAGE_MEM = 9; 	//info page about Arduino memory
	static constexpr byte INFO_PAGE_COUNT = 10;   //how many info pages do we have?
	static constexpr byte INFO_PAGE_UNDEFINED = BYTE_MAX_VALUE; //undefined info page

	InfoDisplay(VentilationControl* ventControl, FireWatch* fireWatch, LCDHelper* lcdHelper, RotaryEncoder* encoder, unsigned long infoPageDisplayTime);

	void init();
	void displayInfoPage();

	unsigned long getInfoPageDisplayTime() const;
	void setInfoPageDisplayTime(unsigned long displayTime);
};

#endif /* INFODISPLAY_H_ */
