#include <Arduino.h>
#include "common.h"


const char SM_STR_TEMP_CTRL_MODE[] PROGMEM = "=Temp Ctrl Mode=";
const char SM_STR_MAX_TEMP_INSIDE[] PROGMEM = "=Max Insid Temp=";
const char SM_STR_MAX_TEMP_DIFF[] PROGMEM = "=Max Temp Diffr=";
const char SM_STR_WARNING_TEMP[] PROGMEM = "=Warning Temper=";
const char SM_STR_SHUTDOWN_TEMP[] PROGMEM = "=Shutdown Tempr=";
const char SM_STR_ALERT_PPM[] PROGMEM = "=  Alert PPM   =";
const char SM_STR_SHUTDOWN_PPM[] PROGMEM = "= Shutdown PPM =";
const char SM_STR_FAN_DOOR_ANGLE[] PROGMEM = "=Fan door angle=";
const char SM_STR_FAN_DOOR_SPEED[] PROGMEM = "=Fan door speed=";
const char SM_STR_FAN_PWM_OUT[] PROGMEM = "=Fan PWM Output=";
const char SM_STR_LED_ON[] PROGMEM = "=LED Light Outp=";
const char SM_STR_LED_PWM_OUT[] PROGMEM = "=LED Brightness=";
const char SM_STR_FIRE_ALERT_MODE[] PROGMEM = "=Fire Alrt Mode=";
const char SM_STR_GAS_SENSE_WARMUP_TIME[] PROGMEM = "=Gas sens WrmpT=";
const char SM_STR_ENABLE_WDT[] PROGMEM = "=  Enable WDT  =";
const char SM_STR_INFO_DISPLAY_SPEED[] PROGMEM = "=Info Displ Spd=";
const char SM_STR_PWR_RELAY_OVERRIDE[] PROGMEM = "=Pwr Relay Ovrd=";

const char SM_STR_FAM_NORMAL[] PROGMEM = "Normal";
const char SM_STR_FAM_WARNING[] PROGMEM = "Fire Warning";
const char SM_STR_FAM_HAZARD[] PROGMEM = "Fire Hazard";

const char SM_STR_INVALID[] PROGMEM = "INVALID";

const char SM_STR_INVALID_VAR_INDEX[] PROGMEM = "Invalid variable index: %d";


char* _loadFlashString(const __FlashStringHelper* flashStr) {
    static char buffer[LCD_STRING_MAX_LEN + 1] = {0};  // +1 for null terminator
    memset(buffer, 0, sizeof(buffer));  // Clear the buffer before copying, this is because left-over chars from previous calls, that would otherwise be there
    strncpy_P(buffer, (PGM_P)flashStr, LCD_STRING_MAX_LEN);
    buffer[LCD_STRING_MAX_LEN] = '\0';  // Ensure null termination
    return buffer;
}

#ifdef MK4SC_DEBUG

// Define global buffers (so only one copy exists in the whole program)
char debugBuffer[DEBUG_BUFFER_SIZE];
char debugFlashStrBuffer[DEBUG_BUFFER_SIZE];

void _loadDebugFlashString(const __FlashStringHelper* flashStr, char* buffer, size_t bufferSize) {
    memset(buffer, 0, bufferSize);  // Clear the buffer
    strncpy_P(buffer, (PGM_P)flashStr, bufferSize - 1);
    buffer[bufferSize - 1] = '\0';  // Ensure null termination
}


#endif
