#ifndef GLOBALCONSTANTS_H
#define GLOBALCONSTANTS_H

#define FAN_IDLE_DUTY 20   // Minimum duty cycle for idle fan speed
#define FAN_OFF_DUTY 0    // Duty cycle for the fan to stop spinning
#define FAN_MAX_DUTY 100  // Maximum duty cycle for the fan

#define DEFAULT_TEMP_MIN_DIFF 1.0
#define DEFAULT_TEMP_MAX_DIFF 10

#define DEFAULT_WARNING_TEMP 60
#define DEFAULT_SHUTDOWN_TEMP 80


#define SM_STR_YES "Yes"
#define SM_STR_NO "no"
#define SM_STR_AUTO "Auto"
#define SM_STR_MANUAL "Manual"
#define SM_STR_DEG " deg"
#define SM_STR_PERCENT " %"
#define SM_STR_ON "On"
#define SM_STR_OFF "Off"

#define STR_TEMP "T="
#define STR_HUM "H="
#define STR_CELSIUS " C"
#define STR_PERCENT " %"
#define STR_PPM " ppm"

#define LIGHT_LED_ON 1
#define LIGHT_LED_OFF 0

#define DEBUG  // Comment this line to disable debugging

#ifdef DEBUG
  #define DEBUG_INIT(baud) Serial.begin(baud); while (!Serial)
  #define DEBUG_PRINT(x) Serial.print(x)
  #define DEBUG_PRINTLN(x) Serial.println(x)
#else
  #define DEBUG_INIT(baud)
  #define DEBUG_PRINT(x)
  #define DEBUG_PRINTLN(x)
#endif

#endif
