#ifndef LCD1602HELPER_H
#define LCD1602HELPER_H

#include <Arduino.h>
#include <LiquidCrystal_I2C.h>
#include "LCDHelper.h"
#include "common.h"

constexpr byte LCD1602_WIDTH = 16;
constexpr byte LCD1602_ROWS = 2;

class LCD1602Helper : public LCDHelper {
private:
    LiquidCrystal_I2C* lcd; // I2C 1602 LCD display

    //last rows
    char lastRow1[LCD1602_WIDTH + 1] = {0};
    char lastRow2[LCD1602_WIDTH + 1] = {0};

    void printRows(byte row, const char* row1, const char* row2);
    void printRow(const char* text, byte row);

public:
    // Constructor
    LCD1602Helper(LiquidCrystal_I2C* lcd);

    // Overriding base class methods
    void printTextToLCD(const char* text, byte row) override;
    void printFormattedTextToLCD(byte row, const char* fmt, ...) override;
    void displayFloatValue(const char* title, float value, const char* unit) override;
    void displayFloatValue(const char* title, float value, const char* unit, byte precision, byte row) override;
    void display2FloatValues(const char* title1, float value1, const char* unit1, byte precision1,
                             const char* title2, float value2, const char* unit2, byte precision2, byte row) override;
    void displayByteValue(const char* title, byte value, const char* unit) override;
    void displayByteValue(const char* title, byte value, const char* unit, byte row) override;
    virtual void displayWordValue(const char *title, word value, const char *unit) override;
    virtual void displayWordValue(const char *title, word value, const char *unit, byte row) override;
    void clear() override;
    void clearRow(byte row);

    static void sanitizeLCDRow(char* row, size_t length);

    LiquidCrystal_I2C* getLCD();
};

#endif
