var LogbookFilter;
(function (LogbookFilter) {
    LogbookFilter[LogbookFilter["LOGBOOK_FILTERS_ALL"] = 0] = "LOGBOOK_FILTERS_ALL";
    LogbookFilter[LogbookFilter["LOGBOOK_FILTERS_PARTIAL_FLIGHTS"] = 1] = "LOGBOOK_FILTERS_PARTIAL_FLIGHTS";
    LogbookFilter[LogbookFilter["LOGBOOK_FILTERS_GROUND_TO_GROUND"] = 2] = "LOGBOOK_FILTERS_GROUND_TO_GROUND";
    LogbookFilter[LogbookFilter["LOGBOOK_FLIGHTS_ENDED"] = 3] = "LOGBOOK_FLIGHTS_ENDED";
    LogbookFilter[LogbookFilter["LOGBOOK_FLIGHTS_STARTED"] = 4] = "LOGBOOK_FLIGHTS_STARTED";
})(LogbookFilter || (LogbookFilter = {}));
class FlightEntry {
}
class LogBookTableEntryNoteElement extends TemplateElement {
    constructor() {
        super();
        this.setData = (_data) => {
            this.m_data = _data;
            if (!this.isConnected)
                return;
            this.m_input.value = "";
            Utils.RemoveAllChildren(this.m_list);
            this.m_refly_button.disable(!this.m_data.bAllowFlyAgain);
            this.m_list.classList.toggle('hide', !(this.m_data.daNotes && this.m_data.daNotes.length));
            this.classList.toggle('no-list', !(this.m_data.daNotes && this.m_data.daNotes.length));
            if (this.m_data.daNotes && this.m_data.daNotes.length) {
                /*for (var i = 0; i < this.m_data.daNotes.length; i++) {
                    let el = document.createElement('li');
                    
                    el.innerHTML = "<span>" + note;
                    el.innerHTML += "<new-push-button id=\"delete_flight_" + this.m_data.entryID + "_" + i + "\" ";
                    el.innerHTML += "</span>";
                    this.m_list.appendChild(el);
                }*/
                this.m_data.daNotes.forEach(note => {
                    let el = document.createElement('li');
                    el.innerHTML = "<span>" + note + "</span>";
                    this.m_list.appendChild(el);
                });
            }
        };
        this.onInput = () => {
        };
        this.onSendButtonClick = () => {
            this.dispatchEvent(new CustomEvent('create', { detail: { data: this.m_data, content: this.m_input.value } }));
        };
        this.onFavoriteButtonClick = () => {
            this.dispatchEvent(new Event('favorite'));
        };
        this.onReflyButtonClick = () => {
            this.dispatchEvent(new Event('refly'));
        };
    }
    get templateID() { return "LogBookTableEntryNoteTemplate"; }
    ;
    connectedCallback() {
        super.connectedCallback();
        this.m_input = this.querySelector('input');
        this.m_input.placeholder = Coherent.translate(this.m_input.placeholder);
        this.m_list = this.querySelector('ul');
        this.m_send_button = this.querySelector('new-push-button[name="send"]');
        this.m_favorite_button = this.querySelector('new-push-button[name="favorite"]');
        this.m_refly_button = this.querySelector('new-push-button[name="refly"]');
        this.m_input.addEventListener('input', this.onInput);
        this.m_send_button.addEventListener('OnValidate', this.onSendButtonClick);
        this.m_favorite_button.addEventListener('OnValidate', this.onFavoriteButtonClick);
        this.m_refly_button.addEventListener('OnValidate', this.onReflyButtonClick);
        if (this.m_data)
            this.setData(this.m_data);
    }
    get data() {
        return this.m_data;
    }
}
window.customElements.define("logbook-table-entry-note", LogBookTableEntryNoteElement);
class LogBookTableElement extends ButtonElement {
    constructor() {
        super();
        this.m_currentLineIndex = -1;
        this.onFlightEntryMouseDown = (e) => {
            this.selectFlightEntry(e.currentTarget);
        };
        this.onCreateNote = (e) => {
            let flightData = e.target.data;
            let content = e.detail.content;
            this.dispatchEvent(new CustomEvent('createNote', {
                detail: {
                    content: content,
                    entryID: flightData.entryID,
                }
            }));
        };
        this.onFavoriteEntry = (e) => {
            let flightData = e.target.data;
            this.dispatchEvent(new CustomEvent('favoriteEntry', {
                detail: {
                    entryID: flightData.entryID,
                }
            }));
        };
        this.onReflyEntry = (e) => {
            let flightData = e.target.data;
            this.dispatchEvent(new CustomEvent('reflyEntry', {
                detail: {
                    entryID: flightData.entryID,
                }
            }));
        };
    }
    get canBeSelected() {
        return this.hasFocusableLine();
    }
    get defaultSoundType() { return "listButton"; }
    get templateID() { return "LogBookTableTemplate"; }
    ;
    get selectedEntryId() { return this.getAttribute('selected-entry-id'); }
    set selectedEntryId(value) { this.setAttribute('selected-entry-id', value); }
    static get observedAttributes() { return super.observedAttributes.concat(['selected-entry-id']); }
    focusByKeys(keycode) {
        super.focusByKeys(keycode);
        let activeLine = this.m_itemsContainer.querySelector('.selected');
        if (activeLine) {
            this.m_currentLineIndex = this.m_itemElements.indexOf(activeLine);
        }
        if (keycode == KeyCode.KEY_UP) {
            if (!activeLine) {
                this.m_currentLineIndex = this.m_itemElements.length - 1;
            }
            this.selectPreviousLine();
        }
        else {
            if (!activeLine) {
                this.m_currentLineIndex = 0;
            }
            this.selectNextLine();
        }
        this.updateFocusedLine();
    }
    hasFocusableLine() {
        if (!this.m_itemElements)
            return false;
        return this.m_itemElements.findIndex(line => !line.classList.contains("hide")) >= 0;
    }
    selectNextLine() {
        let next;
        next = this.getSelectedLine();
        while (next != null) {
            if (next.classList.contains('hide')) {
                this.m_currentLineIndex++;
                next = this.getSelectedLine();
            }
            else if (this.m_currentLineIndex < this.m_itemElements.length) {
                this.updateFocusedLine();
                return true;
            }
            else {
                break;
            }
        }
        this.m_currentLineIndex = -1;
        this.updateFocusedLine();
        return false;
    }
    selectPreviousLine() {
        let next;
        next = this.getSelectedLine();
        while (next != null) {
            if (next.classList.contains('hide')) {
                this.m_currentLineIndex--;
                next = this.getSelectedLine();
            }
            else if (this.m_currentLineIndex >= 0) {
                if (next.classList.contains('selected')) {
                    if (UINavigation.KeysMode) {
                        let defaultChild = this.m_note.getDefaultChildButton();
                        if (defaultChild)
                            defaultChild.focusByKeys(-1);
                    }
                }
                this.updateFocusedLine();
                return true;
            }
            else {
                break;
            }
        }
        this.m_currentLineIndex = -1;
        this.updateFocusedLine();
        return false;
    }
    onKeyDown(keycode) {
        if (keycode == KeyCode.KEY_DOWN) {
            if (UINavigation.current != this)
                this.focusByKeys(-1);
            this.m_currentLineIndex++;
            if (this.selectNextLine()) {
                if (this.getSelectedLine().classList.contains('selected')) {
                    if (UINavigation.KeysMode) {
                        let defaultChild = this.m_note.getDefaultChildButton();
                        if (defaultChild)
                            defaultChild.focusByKeys(-1);
                    }
                }
                return true;
            }
        }
        else if (keycode == KeyCode.KEY_UP) {
            if (UINavigation.current != this)
                this.focusByKeys(-1);
            this.m_currentLineIndex--;
            if (this.selectPreviousLine()) {
                return true;
            }
        }
        return super.onKeyDown(keycode);
    }
    blur() {
        super.blur();
        this.m_currentLineIndex = -1;
        this.updateFocusedLine();
    }
    getSelectedLine() {
        if (this.m_currentLineIndex == -1) {
            return null;
        }
        else {
            return this.m_itemElements[this.m_currentLineIndex];
        }
    }
    onValidate() {
        if (this.m_currentLineIndex != -1) {
            this.selectFlightEntry(this.getSelectedLine());
        }
    }
    updateFocusedLine() {
        if (this.m_currentLineIndex == -1) {
            this.m_itemsContainer.querySelectorAll("tr.Focused").forEach(line => {
                line.classList.remove('Focused');
            });
        }
        else {
            this.m_itemsContainer.querySelectorAll("tr.Focused").forEach(line => {
                let lineIndex = this.m_itemElements.indexOf(line);
                if (lineIndex != this.m_currentLineIndex) {
                    line.classList.remove('Focused');
                }
            });
            let selectedLine = this.m_itemElements[this.m_currentLineIndex];
            if (selectedLine) {
                selectedLine.classList.add('Focused');
                this.m_listScroll.scrollEltIntoView(selectedLine);
            }
        }
    }
    connectedCallback() {
        super.connectedCallback();
        this.m_listScroll = this.querySelector('virtual-scroll');
        this.m_itemsContainer = this.querySelector('#Items');
    }
    attributeChangedCallback(name, oldValue, newValue) {
        super.attributeChangedCallback(name, oldValue, newValue);
        if (name == "selected-entry-id" && this.isConnected && this.m_note_wrapper && this.m_note) {
        }
    }
    setFilter(filter) {
        this.setData(this.m_data, false, filter);
    }
    setData(_data, onlyLast, filter) {
        this.m_data = _data;
        this.ClearLogbook();
        var totalFlightTime = 0;
        var totalOCTNight = 0;
        var totalOCTIFR = 0;
        if (this.m_itemsContainer) {
            var flightEntry = new FlightEntry();
            if (onlyLast) {
                let bRes = false;
                if (_data.length > 0) {
                    let lastFlight = _data[_data.length - 1];
                    bRes = this.AddFlight(lastFlight, lastFlight.daFlights[0], (_data.length - 1) + "_0", flightEntry, filter);
                }
                if (bRes) {
                    this.m_itemsContainer.appendChild(flightEntry.element);
                    flightEntry.element.addEventListener('mousedown', this.onFlightEntryMouseDown);
                    totalFlightTime += flightEntry.totalFlightTime;
                }
            }
            else {
                let _id = 0;
                for (var i = _data.length - 1; i >= 0; i--) {
                    for (var j = 0; j < _data[i].daFlights.length; j++) {
                        var bRes = this.AddFlight(_data[i], _data[i].daFlights[j], i + "_" + j, flightEntry, filter);
                        if (bRes) {
                            this.m_itemsContainer.appendChild(flightEntry.element);
                            flightEntry.element.addEventListener('mousedown', this.onFlightEntryMouseDown);
                            totalFlightTime += flightEntry.totalFlightTime;
                        }
                        _id++;
                    }
                }
            }
            this.m_note_wrapper = document.createElement('tr');
            let td = document.createElement('td');
            td.setAttribute('colspan', "13");
            this.m_note = new LogBookTableEntryNoteElement();
            this.m_note.addEventListener('create', this.onCreateNote);
            this.m_note.addEventListener('favorite', this.onFavoriteEntry);
            this.m_note.addEventListener('refly', this.onReflyEntry);
            td.appendChild(this.m_note);
            this.m_note_wrapper.appendChild(td);
            this.m_note_wrapper.id = "notesWrapper";
            this.m_note_wrapper.classList.toggle('hide', true);
            this.m_note_wrapper.classList.toggle('notes', true);
            this.m_itemsContainer.appendChild(this.m_note_wrapper);
            if (this.selectedEntryId) {
                let flight_ids = this.selectedEntryId.split('_');
                if (Number(flight_ids[0]) <= this.m_data.length) {
                    let logEntry = this.m_data[Number(flight_ids[0])];
                    if (Number(flight_ids[1]) <= logEntry.daFlights.length) {
                        let flightData = logEntry.daFlights[Number(flight_ids[1])];
                        if (flightData) {
                            let element = this.querySelector('[flight-id="' + this.selectedEntryId + '"]');
                            if (element) {
                                element.classList.toggle('selected', true);
                                var nodes = Array.prototype.slice.call(this.m_itemsContainer.children);
                                var index = nodes.indexOf(element);
                                this.m_itemsContainer.insertBefore(this.m_note_wrapper, nodes[index + 1]);
                                this.m_note_wrapper.classList.toggle('hide', false);
                                this.m_note.setData(flightData);
                            }
                        }
                    }
                }
            }
            setTimeout(() => {
                this.calcCellSizes();
            });
        }
    }
    calcCellSizes() {
        if (this.isVisible()) {
            let contentTable = this.querySelector('.contentTable');
            contentTable.querySelectorAll('col').forEach(col => col.remove());
            let thead = contentTable.querySelector('thead');
            thead.classList.remove('hide');
            this.offsetWidth;
            let exampleLine = this.m_itemsContainer.querySelector('tr');
            void this.m_itemsContainer.offsetWidth;
            let headTable = this.querySelector('.headTable');
            headTable.querySelectorAll('col').forEach(col => col.remove());
            let footerTable = this.querySelector('.footerTable');
            footerTable.querySelectorAll('col').forEach(col => col.remove());
            let footerContent = this.querySelector('tfoot');
            let emptyContent = this.querySelector('.emptyLogBookTable');
            let colFrag = document.createDocumentFragment();
            Array.from(exampleLine.children).forEach((cell) => {
                let col = document.createElement('col');
                col.setAttribute('width', cell.offsetWidth.toString());
                colFrag.appendChild(col);
            });
            footerTable.insertBefore(colFrag.cloneNode(true), footerContent);
            footerTable.classList.toggle("hide", this.m_data.length == 0);
            emptyContent.classList.toggle("hide", this.m_data.length != 0);
            Utils.RemoveAllChildren(headTable);
            headTable.appendChild(colFrag.cloneNode(true));
            headTable.appendChild(thead.cloneNode(true));
            thead.classList.add('hide');
            contentTable.insertBefore(colFrag.cloneNode(true), this.m_itemsContainer);
            this.querySelector('virtual-scroll').sendSizeUpdate();
            this.m_itemElements = Array.from(this.m_itemsContainer.querySelectorAll('tr:not(.notes)'));
        }
    }
    onVisibilityChange(value) {
        super.onVisibilityChange(value);
        setTimeout(() => {
            this.calcCellSizes();
        });
    }
    setTotal(total) {
        this.querySelector(".TotalRow").classList.remove("hide");
        this.querySelector(".TotalRow .TotalFlightTime").textContent = Utils.SecondsToDisplayDuration(total.fTotalHours * 3600, true, false);
        this.querySelector(".TotalRow .TotalTakeOffDay").textContent = total.iDayTakeOffCount.toString();
        this.querySelector(".TotalRow .TotalTakeOffNight").textContent = total.iNightTakeOffCount.toString();
        this.querySelector(".TotalRow .TotalLandingDay").textContent = total.iDayLandingCount.toString();
        this.querySelector(".TotalRow .TotalLandingNight").textContent = total.iNightLandingCount.toString();
        this.querySelector(".TotalRow .TotalNight").textContent = Utils.SecondsToDisplayDuration(total.fNightHours * 3600, true, false);
        this.querySelector(".TotalRow .TotalDay").textContent = Utils.SecondsToDisplayDuration(total.fDayHours * 3600, true, false);
        this.querySelector(".TotalRow .TotalIFR").textContent = Utils.SecondsToDisplayDuration(total.fIFRHours * 3600, true, false);
        this.querySelector(".TotalRow .TotalVFR").textContent = Utils.SecondsToDisplayDuration(total.fVFRHours * 3600, true, false);
        this.querySelector(".TotalRow .TotalDistanceFlown").textContent = total.distance.valueStr + " " + total.distance.unit;
    }
    ClearLogbook() {
        if (this.m_itemsContainer) {
            while (this.m_itemsContainer.firstChild) {
                this.m_itemsContainer.removeChild(this.m_itemsContainer.firstChild);
            }
        }
    }
    AddFlight(_data, flight, _flightId, _flightEntry, filter) {
        switch (filter) {
            case LogbookFilter.LOGBOOK_FILTERS_ALL: break;
            case LogbookFilter.LOGBOOK_FILTERS_PARTIAL_FLIGHTS:
                {
                    if (flight.bFullFlight)
                        return false;
                    break;
                }
            case LogbookFilter.LOGBOOK_FILTERS_GROUND_TO_GROUND:
                {
                    if (!flight.bFullFlight)
                        return false;
                    break;
                }
            case LogbookFilter.LOGBOOK_FLIGHTS_ENDED:   //flights that ended on airport, ... must match ICAO code - 2 - 4 character/numerical combination
                {
                    if (!flight.sEndingAirport.match(/^[\w\d]{2,4}$/)) {
                        return false;
                    }
                    break;
                }
            case LogbookFilter.LOGBOOK_FLIGHTS_STARTED: //flights that started on airport ... must match ICAO code - 2 - 4 character/numerical combination
                {
                    if (!flight.sStartingAirport.match(/^[\w\d]{2,4}$/)) {
                        return false;
                    }
                    break;
                }
        }
        var elem = window.document.createElement("tr");
        elem.id = "item" + _data.iDay + _data.iMonth + _data.iYear + "_" + _flightId;
        elem.setAttribute('flight-id', _flightId);
        elem.classList.add('searchable');
        //is favorite?
        //For now, the flight data does not contain information whether the flight is favorite or not
        elem.title = "";
        var info;
        info = window.document.createElement("td");
        info.innerText = _data.sDate;
        elem.appendChild(info);
        elem.title += " | " + _data.sDate;
        info = window.document.createElement("td");
        info.innerText = flight.sAircraftName;
        info.id = "Plane";
        elem.appendChild(info);
        elem.title += " | " + flight.sAircraftName.toLowerCase();
        var startTime = flight.iCreationTimeInSeconds;
        info = window.document.createElement("td");
        info.innerText = Utils.SecondsToDisplayTime(startTime, true, false);
        elem.appendChild(info);
        info = window.document.createElement("td");
        info.innerText = flight.sStartingAirport;
        elem.appendChild(info);
        if (flight.sStartingAirport !== "")
            elem.title += " | " + flight.sStartingAirport.toLowerCase();
        var endTime = flight.iCreationTimeInSeconds + flight.fTotalHours * 3600;
        info = window.document.createElement("td");
        info.innerText = Utils.SecondsToDisplayTime(endTime, true, false);
        elem.appendChild(info);
        info = window.document.createElement("td");
        info.innerText = flight.sEndingAirport;
        elem.appendChild(info);
        if (flight.sEndingAirport !== "")
            elem.title += " | " + flight.sEndingAirport.toLowerCase();
        var totalTime = endTime - startTime;
        info = window.document.createElement("td");
        info.innerText = Utils.SecondsToDisplayDuration(totalTime, true, false);
        elem.appendChild(info);
        //Modified block for displaying Night and IFR time in one td - START
		var NightSeconds = flight.fNightHours * 3600;
		var IFRSeconds = flight.fIFRHours * 3600;
        info = window.document.createElement("td");
		var spanElem = window.document.createElement("span");
		spanElem.classList.add("night-time");
		spanElem.innerHTML = Utils.SecondsToDisplayDuration(NightSeconds, true, false);
		info.appendChild(spanElem);
		var brElem = window.document.createElement("br");
		info.appendChild(brElem);
		spanElem = window.document.createElement("span");
		spanElem.classList.add("vfr-time");
		spanElem.innerHTML = Utils.SecondsToDisplayDuration(IFRSeconds, true, false);        
		info.appendChild(spanElem);
        elem.appendChild(info); 
		//Modified block for displaying Night and IFR time in one td - END
		//Modified block for displaying Day and VFR time in one td - START
        // corrected variable name from IFRSeconds to DaySeconds and adding IFR seconds
        var DaySeconds = flight.fDayHours * 3600;		
		var VFRSeconds = flight.fVFRHours * 3600;
        info = window.document.createElement("td");
		spanElem = window.document.createElement("span");
		spanElem.classList.add("day-time");
		spanElem.innerHTML = Utils.SecondsToDisplayDuration(DaySeconds, true, false);
		info.appendChild(spanElem);
		brElem = window.document.createElement("br");
		info.appendChild(brElem);
		spanElem = window.document.createElement("span");
		spanElem.classList.add("ifr-time");
		spanElem.innerHTML = Utils.SecondsToDisplayDuration(VFRSeconds, true, false);   
		info.appendChild(spanElem);
        elem.appendChild(info);                        		
		//Modified block for displaying Day and VFR time in one td - END        
		//Modified block for displaying Takeoffs in one cell - START    
        info = window.document.createElement("td");
		spanElem = window.document.createElement("span");
		spanElem.classList.add("day-takeoff");
		spanElem.innerHTML = flight.iDayTakeOffCount;
        info.appendChild(spanElem);
        elem.appendChild(info);
        brElem = window.document.createElement("br");
		info.appendChild(brElem);
		spanElem = window.document.createElement("span");
		spanElem.classList.add("night-takeoff");
		spanElem.innerHTML = flight.iNightTakeOffCount;
		info.appendChild(spanElem);
        elem.appendChild(info); 
		//Modified block for displaying Takeoffs in one cell - END
		//Modified block for displaying Landings in one cell - START
		info = window.document.createElement("td");
		spanElem = window.document.createElement("span");
		spanElem.classList.add("day-landings");
		spanElem.innerHTML = flight.iDayLandingCount; 
                info.appendChild(spanElem);
	    brElem = window.document.createElement("br");
		info.appendChild(brElem);
		spanElem = window.document.createElement("span");
		spanElem.classList.add("night-landings");
		spanElem.innerHTML = flight.iNightLandingCount;
		info.appendChild(spanElem);
        elem.appendChild(info);
		//Modified block for displaying Landings in one cell - END
        // distance flown
        info = window.document.createElement("td");
        info.innerText = flight.distance.valueStr + " " + flight.distance.unit;
        elem.appendChild(info);
        _flightEntry.element = elem;
        _flightEntry.totalFlightTime = totalTime;
        return true;
    }
    selectFlightEntry(line) {
        let flight_id = line.getAttribute('flight-id');
        this.selectedEntryId = flight_id;
        let flight_ids = flight_id.split('_');
        let logEntry = this.m_data[Number(flight_ids[0])];
        let flightData = logEntry.daFlights[Number(flight_ids[1])];
        if (!flightData)
            return;
        var previousEl = this.querySelector('tr.selected');
        if (previousEl) {
            previousEl.classList.remove('selected');
        }
        line.classList.add('selected');
        var nodes = Array.prototype.slice.call(this.m_itemsContainer.children);
        var index = nodes.indexOf(line);
        this.m_itemsContainer.insertBefore(this.m_note_wrapper, nodes[index + 1]);
        this.m_note_wrapper.classList.toggle('hide', false);
        this.m_note.setData(flightData);
        this.m_listScroll.sendSizeUpdate();
        if (UINavigation.KeysMode) {
            let defaultChild = this.m_note.getDefaultChildButton();
            if (defaultChild)
                defaultChild.focusByKeys(-1);
        }
    }
    hideNote() {
        var previousEl = this.querySelector('tr.selected');
        if (previousEl) {
            previousEl.classList.remove('selected');
        }
        this.m_note_wrapper.classList.toggle('hide', true);
    }
}
window.customElements.define("logbook-table", LogBookTableElement);
checkAutoload();
//# sourceMappingURL=LogBookTable.js.map