# Readme (last update: 28.3.2022)
Author: Radek Henys [admin@mouseviator.com](mailto:admin@mouseviator.com)

## Couple words for introduction

What is Mouseviator Enhanced Logbook for Microsoft Flight Simulator 2020 (MSFS)? Well, it is small add-on package that I developed while trying to find a way to access MSFS logbook data. I found a "way", sort of by accident but it ... works and is the way of least resistance. 

What can the add-on package do above the normal limited functionality of the default logbook? Well, I think it is true that MSFS logbook has not been touched since the release of MSFS, or just very little. There is a little bit more data in the logbook, that are not visible in the default logbook table (VFR flight time for example). It is probably because the table would than be worse readable, but one of the things this add-on does, is that it displays those hidden data. The second feature is that it allows you to **export** the flight data. I would like to repeat the word **EXPORT**, yes, only export. It is possible to export the logbook data out of MSFS, but <span style="color:red">**not to import them back**</span> (or otherwise modify them) into MSFS logbook!!! (That may never happen :( )

That is why I enclosed the word "way" in parentheses in the first paragraph. Even the export is not that staright-forward... MSFS user interface is based on the same technology as web-sites, and just like web browser cannot simply save a file to user computer, it is not possible (or I did not figure how...) to do so from MSFS user interface. But it was possible to walk-around this by **exporting** the data **via clipboard** in JSON or CSV format, or **over network**.

With the export via clipboard, you can than paste the data into the program of your wish - Notepad, Word, Excel.... but you have to process them by yourself. While actually, exporting using clipboard and CSV format, programs like Excel or Libre Office Calc should recognize the CSV format upon inserting, letting you to specify CSV import options, which should than result in you to have the respective information in respecive columns. Ie, resulting in table. So, than, it is quite simple actually. But I did not test this on any big amount of data. The problem here is, that all the data are copied in one step, possibility is, they will not fit... which in the worst case might end up crashing the simulator. But I think that would require really lot of logged flights...

The safer way is export via network. But for this, you either must program your own "server" to receive the data, or you can use [FS Logbook Editor](https://mouseviator.com/pc-creations/fs-logbook-editor/), which since version 1.8 supports both ways of importing MSFS logbook data (over network and via clipboard). Network export sends data in smaller batches, thus, the amount of data you have in logbook should not matter.

## Features and limitations?

The add-on package does:

* Display originally hidden data, like IFR and VFR flight time
* Adds two filters – **Flights started** – which will list only flights with valid starting airport (nothing with Vicinity or anything else…), which should be flights that started at the airport. **Flights ended** – which will list only flights with valid ending airport (nothing with Vicinity or anything else…), which should be flights that ende at the airport.
* Can **export** the logbook data via clipboard in JSON or CSV format, or using network (with [FS Logbook Editor](https://mouseviator.com/pc-creations/fs-logbook-editor/)).

Limitations are:

* **No IMPORT!!!** No way to modify MSGS logbook records whatsoever.
* I wanted to make available the Favorite button, which should makr the flight as favorite and is hidden in default logbook. Eve though the button is mapped to trigger an action within the flight simulator, the logbook data does not than contain any information whether the flight is favorite or not, so it is useless at this time.
* I wanted to make available the Add comment button, which should add note to the logged flight and is hidden by default. It actually works, but I found no way to work with comment further. It is possible to only add them, but not to remove them, so the button remains hidden.
* The add-on package is in English only!!! MSFS completly ignores the lockPack files in this case… so I had to hardcode all the messages :(

## License

Let’s try to make it simple:

<p style="color: green">You can reupload this file without asking me, but you must properly credit me and add link to my file.</p>

<p style="color: green">You can modify this file or use assets from this file, but I would like to be asked first – (I would to know about improvements you do…) You must properly credit me and add link to my file.</p>

<p style="color: red">Any usage of this file or derivate works ending up in commercial gain is forbidden, but can be discussed. I mean, you can’t just resell this file or derivate works. This add-on is meant to be FREE and remain FREE. But there might be use cases that I did not think of, which might classify as commercial, but might be acceptable.</p>

## Installation

### 1) Copy the mouseviator-enhanced-logbook folder to the right location.

The acrhive you download contains the mouseviator-enhanced-logbook folder. Just extract the archive and place the mentioned folder to the Community packages folder of your installation of Microsoft Flight Simulator

The Community folder is in the folder you instructed Flight Simulator to install packages to when you first installed the simulator. Probably, finding the Community folder might be the tricky part for you, maybe trickier than extracting archive and moving folders. Well, if you did not tell Flight Simulator to put the packages inside the folder you want (like I did), try to look in one of these default locations:

If you’re using the Windows Store version (or Game Pass for PC), then head here:

```
C:\Users\[YOUR USERNAME]\AppData\Local\Packages\Microsoft.FlightSimulator_[RANDOM LETTERS]\LocalCache\Packages\Community
```

Or if you’re using Steam version, try here:

```
C:\Users\[YOUR USERNAME]\AppData\Roaming\Microsoft Flight Simulator\Packages\Community
```

or

```
C:\Users\[YOUR USERNAME]\AppData\Local\Packages\Microsoft.FlightDashboard_[RANDOM LETTERS]\LocalCache\Packages\Community
```         

### 2) Start MSFS and go to Logbook page

That’s it. MSFS should now know about the add-on, so you should see some more information at the logbook page and those two new buttons for exporting logbook.

## Contact

If you want to contact me regarding anything (reasonable anything, no SPAM please), you can do so via email below.

Author: Radek Henys<br/>
Email: [admin@mouseviator.com](mailto:admin@mouseviator.com) 