/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc;

import java.security.InvalidParameterException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class FSUIPCWrapper {
    public static synchronized native int open(int var0);

    public static synchronized native void close();

    public static synchronized native int read(int var0, int var1, byte[] var2);

    public static synchronized native int readData(int var0, int var1, byte[] var2);

    public static synchronized native int write(int var0, int var1, byte[] var2);

    public static synchronized native int writeData(int var0, int var1, byte[] var2);

    public static synchronized native int process();

    public static synchronized native int getResult();

    public static synchronized native int getFSVersion();

    public static synchronized native int getVersion();

    public static synchronized native int getLibVersion();

    public static synchronized native void setupLogging(boolean var0, byte var1);

    public static synchronized native void setupLogging(boolean var0, String var1, byte var2);

    public static synchronized native void setupLogging(boolean var0, String var1, byte var2, int var3);

    private FSUIPCWrapper() {
    }

    public static enum LogSeverity {
        TRACE(0),
        DEBUG(1),
        INFO(2),
        WARNING(3),
        ERROR(4),
        FATAL(5);

        private final byte value;
        private static final Map<Byte, LogSeverity> lookupTable;

        private LogSeverity(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static LogSeverity get(byte value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("Log severity value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<Byte, LogSeverity>();
            for (LogSeverity severity : EnumSet.allOf(LogSeverity.class)) {
                lookupTable.put(severity.getValue(), severity);
            }
        }
    }

    public static enum FSUIPCResult {
        FSUIPC_ERR_OK(0),
        FSUIPC_ERR_OPEN(1),
        FSUIPC_ERR_NOFS(2),
        FSUIPC_ERR_REGMSG(3),
        FSUIPC_ERR_ATOM(4),
        FSUIPC_ERR_MAP(5),
        FSUIPC_ERR_VIEW(6),
        FSUIPC_ERR_VERSION(7),
        FSUIPC_ERR_WRONGFS(8),
        FSUIPC_ERR_NOTOPEN(9),
        FSUIPC_ERR_NODATA(10),
        FSUIPC_ERR_TIMEOUT(11),
        FSUIPC_ERR_SENDMSG(12),
        FSUIPC_ERR_DATA(13),
        FSUIPC_ERR_RUNNING(14),
        FSUIPC_ERR_SIZE(15);

        private final int value;
        private static final Map<Integer, FSUIPCResult> lookupTable;

        private FSUIPCResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FSUIPCResult get(int value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("FSUIPC Result value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<Integer, FSUIPCResult>();
            for (FSUIPCResult result : EnumSet.allOf(FSUIPCResult.class)) {
                lookupTable.put(result.getValue(), result);
            }
        }
    }

    public static enum FSUIPCSimVersion {
        SIM_ANY(0),
        SIM_FS98(1),
        SIM_FS2K(2),
        SIM_CFS2(3),
        SIM_CFS1(4),
        SIM_FLY(5),
        SIM_FS2K2(6),
        SIM_FS2K4(7),
        SIM_FSX(8),
        SIM_ESP(9),
        SIM_P3D(10),
        SIM_FSX64(11),
        SIM_P3D64(12),
        SIM_MSFS(13);

        private final int value;
        private static final Map<Integer, FSUIPCSimVersion> lookupTable;

        private FSUIPCSimVersion(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FSUIPCSimVersion get(int value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("FSUIPC Sim version value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<Integer, FSUIPCSimVersion>();
            for (FSUIPCSimVersion version : EnumSet.allOf(FSUIPCSimVersion.class)) {
                lookupTable.put(version.getValue(), version);
            }
        }
    }
}

