/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;

public class StringRequest
extends DataRequest
implements IDataRequest<String> {
    private Charset charset = Charset.defaultCharset();
    private ValueRetrieveMethod valueRetrieveMethod = ValueRetrieveMethod.WHOLE_BUFFER;

    public StringRequest(int offset, int size) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE || size <= 0) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.dataBuffer = new byte[size];
        this.offset = offset;
    }

    public StringRequest(int offset, String value) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.convertStringToByteArray(value, 0, this.charset);
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public StringRequest(int offset, int max_size, String value) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.convertStringToByteArray(value, max_size, this.charset);
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public StringRequest(int offset, String value, Charset charset) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.convertStringToByteArray(value, 0, charset);
        this.charset = charset;
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public StringRequest(int offset, int max_size, String value, Charset charset) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.convertStringToByteArray(value, max_size, charset);
        this.charset = charset;
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public void allocate(int size) {
        if (size > 0) {
            this.dataBuffer = new byte[size];
        }
    }

    @Override
    public String getValue() {
        return this.getValue(this.valueRetrieveMethod);
    }

    public String getValue(ValueRetrieveMethod valueRetrieveMethod) {
        if (valueRetrieveMethod == ValueRetrieveMethod.WHOLE_BUFFER) {
            return new String(this.dataBuffer, this.charset).trim();
        }
        return this.getZeroTerminatedString(this.charset);
    }

    @Override
    public void setValue(String value) {
        this.convertStringToByteArray(value, 0, this.charset);
    }

    public void setValue(String value, int max_size) {
        this.convertStringToByteArray(value, max_size, this.charset);
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ValueRetrieveMethod getValueRetrieveMethod() {
        return this.valueRetrieveMethod;
    }

    public void setValueRetrieveMethod(ValueRetrieveMethod valueRetrieveMethod) {
        this.valueRetrieveMethod = valueRetrieveMethod;
    }

    public static enum ValueRetrieveMethod {
        WHOLE_BUFFER,
        TO_FIRST_ZERO_BYTE;

    }
}

