/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;

public class FloatRequest
extends DataRequest
implements IDataRequest<Float> {
    public FloatRequest() {
        this.dataBuffer = new byte[4];
    }

    public FloatRequest(int offset) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public FloatRequest(int offset, float value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putFloat(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    public FloatRequest(int offset, Float value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putFloat(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.getFloat());
    }

    @Override
    public void setValue(Float value) {
        this.putFloat(value);
    }
}

