/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers.avionics;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IReadOnlyRequest;

public class GPSHelper {
    public IDataRequest<Double> getAltitude(boolean bFeet) {
        if (!bFeet) {
            class AltitudeRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                AltitudeRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24608;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new AltitudeRequest();
        }
        class AltitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            AltitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24608;
            }

            @Override
            public Double getValue() {
                double altitude = this.getDouble();
                return altitude * 3.2808;
            }
        }
        return new AltitudeRequest();
    }

    public IDataRequest<Double> getLongitude() {
        class LongitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LongitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24600;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new LongitudeRequest();
    }

    public IDataRequest<Double> getLatitude() {
        class LatitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LatitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24592;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new LatitudeRequest();
    }

    public IDataRequest<Double> getMagneticVariation(boolean bDegrees) {
        if (!bDegrees) {
            class MagVarRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                MagVarRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24616;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new MagVarRequest();
        }
        class MagVarRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            MagVarRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24616;
            }

            @Override
            public Double getValue() {
                double magVar = this.getDouble();
                return Math.toDegrees(magVar);
            }
        }
        return new MagVarRequest();
    }

    public IDataRequest<Double> getVerticalSpeed() {
        class VSRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            VSRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24696;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new VSRequest();
    }

    public IDataRequest<Double> getGroundSpeed(boolean bKnots) {
        if (!bKnots) {
            class GroundSpeedRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                GroundSpeedRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24624;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new GroundSpeedRequest();
        }
        class GroundSpeedRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            GroundSpeedRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24624;
            }

            @Override
            public Double getValue() {
                double gs = this.getDouble();
                return gs * 1.94384449;
            }
        }
        return new GroundSpeedRequest();
    }

    public IDataRequest<Double> getHeading(boolean bDegrees) {
        if (!bDegrees) {
            class HeadingRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                HeadingRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24632;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new HeadingRequest();
        }
        class HeadingRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            HeadingRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24632;
            }

            @Override
            public Double getValue() {
                double heading = this.getDouble();
                return Math.toDegrees(heading);
            }
        }
        return new HeadingRequest();
    }

    public IDataRequest<Double> getRequiredHeading(boolean bDegrees) {
        if (!bDegrees) {
            class RequiredHeadingRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                RequiredHeadingRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24672;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new RequiredHeadingRequest();
        }
        class RequiredHeadingRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            RequiredHeadingRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24672;
            }

            @Override
            public Double getValue() {
                double heading = this.getDouble();
                return Math.toDegrees(heading);
            }
        }
        return new RequiredHeadingRequest();
    }

    public IDataRequest<Double> getMagneticTrack(boolean bDegrees) {
        if (!bDegrees) {
            class MagneticTrackRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                MagneticTrackRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24640;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new MagneticTrackRequest();
        }
        class MagneticTrackRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            MagneticTrackRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24640;
            }

            @Override
            public Double getValue() {
                double mTrack = this.getDouble();
                return Math.toDegrees(mTrack);
            }
        }
        return new MagneticTrackRequest();
    }

    public IDataRequest<Double> getDistanceToNextWaypoint(boolean bNauticalMiles) {
        if (!bNauticalMiles) {
            class DistToNextWaypointRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                DistToNextWaypointRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24648;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new DistToNextWaypointRequest();
        }
        class DistToNextWaypointRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            DistToNextWaypointRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24648;
            }

            @Override
            public Double getValue() {
                double dist = this.getDouble();
                return dist * (double)5.3996E-4f;
            }
        }
        return new DistToNextWaypointRequest();
    }

    public IDataRequest<Double> getMagBearingToNextWaypoint(boolean bDegrees) {
        if (!bDegrees) {
            class MagBearingToNextWaypointRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                MagBearingToNextWaypointRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24656;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new MagBearingToNextWaypointRequest();
        }
        class MagBearingToNextWaypointRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            MagBearingToNextWaypointRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24656;
            }

            @Override
            public Double getValue() {
                double bearing = this.getDouble();
                return Math.toDegrees(bearing);
            }
        }
        return new MagBearingToNextWaypointRequest();
    }

    public IDataRequest<Double> getCrossTrackError(boolean bNauticalMiles) {
        if (!bNauticalMiles) {
            class CrossTrackErrorRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                CrossTrackErrorRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24664;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new CrossTrackErrorRequest();
        }
        class CrossTrackErrorRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            CrossTrackErrorRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24664;
            }

            @Override
            public Double getValue() {
                double dist = this.getDouble();
                return dist * (double)5.3996E-4f;
            }
        }
        return new CrossTrackErrorRequest();
    }

    public IDataRequest<Double> getTrackError(boolean bDegrees) {
        if (!bDegrees) {
            class TrackErrorRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                TrackErrorRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24680;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new TrackErrorRequest();
        }
        class TrackErrorRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            TrackErrorRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24680;
            }

            @Override
            public Double getValue() {
                double track_error = this.getDouble();
                return Math.toDegrees(track_error);
            }
        }
        return new TrackErrorRequest();
    }

    public IDataRequest<Byte> getPreviousWaypointValidFlag() {
        class PrevWaypointValidFlagRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            PrevWaypointValidFlagRequest() {
                this.dataBuffer = new byte[1];
                this.offset = 24704;
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new PrevWaypointValidFlagRequest();
    }

    public IDataRequest<String> getPreviousWaypointID() {
        class PrevWaypointIDRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            PrevWaypointIDRequest() {
                this.dataBuffer = new byte[6];
                this.offset = 24705;
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new PrevWaypointIDRequest();
    }

    public IDataRequest<Double> getPreviousWaypointLongitude() {
        class LongitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LongitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24724;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new LongitudeRequest();
    }

    public IDataRequest<Double> getPreviousWaypointLatitude() {
        class LatitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LatitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24716;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new LatitudeRequest();
    }

    public IDataRequest<Double> getPreviousWaypointAircraftAltitude(boolean bFeet) {
        if (!bFeet) {
            class AltitudeRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                AltitudeRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24732;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new AltitudeRequest();
        }
        class AltitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            AltitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24732;
            }

            @Override
            public Double getValue() {
                double altitude = this.getDouble();
                return altitude * 3.2808;
            }
        }
        return new AltitudeRequest();
    }

    public IDataRequest<String> getNextWaypointID() {
        class NextWaypointIDRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            NextWaypointIDRequest() {
                this.dataBuffer = new byte[6];
                this.offset = 24740;
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new NextWaypointIDRequest();
    }

    public IDataRequest<Double> getNextWaypointLongitude() {
        class LongitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LongitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24756;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new LongitudeRequest();
    }

    public IDataRequest<Double> getNextWaypointLatitude() {
        class LatitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LatitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24748;
            }

            @Override
            public Double getValue() {
                return this.getDouble();
            }
        }
        return new LatitudeRequest();
    }

    public IDataRequest<Double> getNextWaypointAircraftAltitude(boolean bFeet) {
        if (!bFeet) {
            class AltitudeRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                AltitudeRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24764;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new AltitudeRequest();
        }
        class AltitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            AltitudeRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24764;
            }

            @Override
            public Double getValue() {
                double altitude = this.getDouble();
                return altitude * 3.2808;
            }
        }
        return new AltitudeRequest();
    }

    public IDataRequest<Integer> getNextWaypointETE() {
        class NextWaypointETERequest
        extends DataRequest
        implements IReadOnlyRequest<Integer> {
            NextWaypointETERequest() {
                this.dataBuffer = new byte[4];
                this.offset = 24804;
            }

            @Override
            public Integer getValue() {
                return this.getInt();
            }
        }
        return new NextWaypointETERequest();
    }

    public IDataRequest<Integer> getNextWaypointETA() {
        class NextWaypointETARequest
        extends DataRequest
        implements IReadOnlyRequest<Integer> {
            NextWaypointETARequest() {
                this.dataBuffer = new byte[4];
                this.offset = 24808;
            }

            @Override
            public Integer getValue() {
                return this.getInt();
            }
        }
        return new NextWaypointETARequest();
    }

    public IDataRequest<Double> getCourseToSet(boolean bDegrees) {
        if (!bDegrees) {
            class CourseToSetRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                CourseToSetRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24844;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new CourseToSetRequest();
        }
        class CourseToSetRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            CourseToSetRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24844;
            }

            @Override
            public Double getValue() {
                double course = this.getDouble();
                return Math.toDegrees(course);
            }
        }
        return new CourseToSetRequest();
    }

    public IDataRequest<String> getDestinationAirportID() {
        class DestinationAirportIDRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            DestinationAirportIDRequest() {
                this.dataBuffer = new byte[5];
                this.offset = 24887;
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new DestinationAirportIDRequest();
    }

    public IDataRequest<Integer> getDestinationETE() {
        class DestinationETERequest
        extends DataRequest
        implements IReadOnlyRequest<Integer> {
            DestinationETERequest() {
                this.dataBuffer = new byte[4];
                this.offset = 24984;
            }

            @Override
            public Integer getValue() {
                return this.getInt();
            }
        }
        return new DestinationETERequest();
    }

    public IDataRequest<Integer> getDestinationETA() {
        class DestinationETARequest
        extends DataRequest
        implements IReadOnlyRequest<Integer> {
            DestinationETARequest() {
                this.dataBuffer = new byte[4];
                this.offset = 24988;
            }

            @Override
            public Integer getValue() {
                return this.getInt();
            }
        }
        return new DestinationETARequest();
    }

    public IDataRequest<Double> getRouteTotalDistance(boolean bNauticalMiles) {
        if (!bNauticalMiles) {
            class RouteTotalDistanceRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                RouteTotalDistanceRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 24992;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new RouteTotalDistanceRequest();
        }
        class RouteTotalDistanceRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            RouteTotalDistanceRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 24992;
            }

            @Override
            public Double getValue() {
                double dist = this.getDouble();
                return dist * (double)5.3996E-4f;
            }
        }
        return new RouteTotalDistanceRequest();
    }

    public IDataRequest<Double> getEstimatedFuelBurn(boolean bLitres) {
        if (!bLitres) {
            class EstimatedFuelBurnRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                EstimatedFuelBurnRequest() {
                    this.dataBuffer = new byte[8];
                    this.offset = 25000;
                }

                @Override
                public Double getValue() {
                    return this.getDouble();
                }
            }
            return new EstimatedFuelBurnRequest();
        }
        class EstimatedFuelBurnRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            EstimatedFuelBurnRequest() {
                this.dataBuffer = new byte[8];
                this.offset = 25000;
            }

            @Override
            public Double getValue() {
                double gallons = this.getDouble();
                return gallons * 3.78541178;
            }
        }
        return new EstimatedFuelBurnRequest();
    }
}

