/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers.aircraft;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IReadOnlyRequest;
import com.mouseviator.fsuipc.datarequest.primitives.DoubleRequest;
import com.mouseviator.fsuipc.datarequest.primitives.FloatRequest;
import com.mouseviator.fsuipc.datarequest.primitives.ShortRequest;

public class Engine1Helper {
    protected int throttleLeverOffset = 2188;
    protected int propLeverOffset = 2190;
    protected int mixtureLeverOffset = 2192;
    protected int fuelFlowOffset = 2328;
    protected int oilTempOffset = 2232;
    protected int oilPressureOffset = 2234;
    protected int oilQuantityOffset = 2256;
    protected int manifoldPressureOffset = 2240;
    protected int fuelUsedOffset = 2316;
    protected int elapsedTimeOffset = 2320;

    public ShortRequest getThrottleLever() {
        return new ShortRequest(this.throttleLeverOffset);
    }

    public ShortRequest getPropellerLever() {
        return new ShortRequest(this.propLeverOffset);
    }

    public ShortRequest getMixtureLever() {
        return new ShortRequest(this.mixtureLeverOffset);
    }

    public DoubleRequest getFuelFlow() {
        return new DoubleRequest(this.fuelFlowOffset);
    }

    public FloatRequest getOilTemperature() {
        return new FloatRequest(this.oilTempOffset){
            {
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short oilTemp = this.getShort();
                return Float.valueOf((float)oilTemp / 16384.0f * 140.0f);
            }

            @Override
            public void setValue(Float value) {
                short oilTemp = (short)(value.floatValue() / 140.0f * 16384.0f);
                this.putShort(oilTemp);
            }
        };
    }

    public FloatRequest getOilQuantity() {
        return new FloatRequest(this.oilQuantityOffset){

            @Override
            public Float getValue() {
                int quantity = this.getInt();
                return Float.valueOf((float)quantity / 16384.0f * 100.0f);
            }

            @Override
            public void setValue(Float value) {
                int quantity = (int)(value.floatValue() / 100.0f * 16384.0f);
                this.putInt(quantity);
            }
        };
    }

    public FloatRequest getOilPressure() {
        return new FloatRequest(this.oilPressureOffset){

            @Override
            public Float getValue() {
                short pressure = this.getShort();
                return Float.valueOf((float)pressure / 65535.0f * 220.0f);
            }

            @Override
            public void setValue(Float value) {
                short pressure = (short)(value.floatValue() * 220.0f / 65535.0f);
                this.putInt(pressure);
            }
        };
    }

    public FloatRequest getManifoldPressure() {
        return new FloatRequest(this.manifoldPressureOffset){
            {
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short manPressure = this.getShort();
                return Float.valueOf((float)manPressure / 1024.0f);
            }

            @Override
            public void setValue(Float value) {
                short manPressure = (short)(value.floatValue() * 1024.0f);
                this.putShort(manPressure);
            }
        };
    }

    public FloatRequest getFuelUsed() {
        return new FloatRequest(this.fuelUsedOffset);
    }

    public IDataRequest<Float> getElapsedTime() {
        class ElapsedTimeRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            ElapsedTimeRequest() {
                this.dataBuffer = new byte[4];
                this.offset = Engine1Helper.this.elapsedTimeOffset;
            }

            @Override
            public Float getValue() {
                return Float.valueOf(this.getFloat());
            }
        }
        return new ElapsedTimeRequest();
    }
}

