/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;

public class ShortRequest
extends DataRequest
implements IDataRequest<Short> {
    public ShortRequest() {
        this.dataBuffer = new byte[2];
    }

    public ShortRequest(int offset) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public ShortRequest(int offset, short value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putShort(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    public ShortRequest(int offset, Short value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putShort(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Short getValue() {
        return this.getShort();
    }

    @Override
    public void setValue(Short value) {
        this.putShort(value);
    }
}

