/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;

public class ByteRequest
extends DataRequest
implements IDataRequest<Byte> {
    public ByteRequest() {
        this.dataBuffer = new byte[1];
    }

    public ByteRequest(int offset) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public ByteRequest(int offset, byte value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.dataBuffer[0] = value;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public ByteRequest(int offset, Byte value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.dataBuffer[0] = value;
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Byte getValue() {
        return this.dataBuffer[0];
    }

    @Override
    public void setValue(Byte value) {
        this.dataBuffer[0] = value;
    }
}

