/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidParameterException;

public class ShortRequest
extends DataRequest
implements IDataRequest<Short> {
    public ShortRequest() {
        this.dataBuffer = new byte[2];
    }

    public ShortRequest(int offset) {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public ShortRequest(int offset, short value) {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(value);
        buf.get(this.dataBuffer);
        this.type = IDataRequest.RequestType.WRITE;
    }

    public ShortRequest(int offset, Short value) {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(value);
        buf.get(this.dataBuffer);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Short getValue() {
        return this.getShort();
    }

    @Override
    public void setValue(Short value) {
        this.putShort(value);
    }
}

