/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.example;

import com.mouseviator.fsuipc.FSUIPC;
import com.mouseviator.fsuipc.FSUIPCWrapper;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.primitives.DoubleRequest;
import com.mouseviator.fsuipc.datarequest.primitives.IntRequest;
import com.mouseviator.fsuipc.datarequest.primitives.StringRequest;
import com.mouseviator.fsuipc.helpers.LVarHelper;
import com.mouseviator.fsuipc.helpers.LuaHelper;
import com.mouseviator.fsuipc.helpers.MacroHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FSUIPCLVarLuaMacroTest {
    public static void main(String[] args) {
        FSUIPC fsuipc = FSUIPC.getInstance();
        byte result = FSUIPC.load();
        if (result != 0) {
            System.out.println("Failed to load native library. Quiting...");
            return;
        }
        FSUIPCWrapper.setupLogging(true, FSUIPCWrapper.LogSeverity.DEBUG.getValue());
        System.out.println("Running tests...");
        int ret = fsuipc.connect(FSUIPCWrapper.FSUIPCSimVersion.SIM_ANY);
        System.out.println("FSUIPC connect return value =" + ret);
        if (ret == 0) {
            System.out.println("Flight sim not found");
        } else {
            System.out.println("Flight Sim found!");
            System.out.println("FSUIPC Version: " + String.valueOf(FSUIPCWrapper.getVersion()));
            System.out.println("FSUIPC Version (string): " + fsuipc.getVersion());
            System.out.println("FSUIPC FS Version: " + String.valueOf(FSUIPCWrapper.getFSVersion()));
            System.out.println("FSUIPC FS Version (string): " + fsuipc.getFSVersion());
            System.out.println("FSUIPC Lib Version: " + String.valueOf(FSUIPCWrapper.getLibVersion()));
            System.out.println("FSUIPC Lib Version (string): " + fsuipc.getLibVersion());
            int LVAR_REQUEST_OFFSET = 3440;
            int LVAR_REQUEST_PARAM_OFFSET = 3436;
            int LVAR_RESULT_OFFSET = 26304;
            String lvar1 = "FSDT_GSX_DEBOARDING_STATE";
            String lvar2 = "FSDT_GSX_BOARDING_STATE";
            String lvar3 = "FSDT_GSX_NUMPASSENGERS";
            String customLvar = "MOUSEVIATOR_CUSTOM_LVAR";
            System.out.println("\n\n>>> LVar Tests...");
            System.out.println("Will read value for LVar : FSDT_GSX_DEBOARDING_STATE using standard approach and value for LVar: FSDT_GSX_BOARDING_STATE using helper functions...");
            IntRequest integer = new IntRequest(3436);
            integer.setValue(26304);
            integer.setType(IDataRequest.RequestType.WRITE);
            fsuipc.addOneTimeRequest(integer);
            StringRequest var = new StringRequest(3440, ":FSDT_GSX_DEBOARDING_STATE");
            fsuipc.addOneTimeRequest(var);
            DoubleRequest erg = new DoubleRequest(26304);
            fsuipc.addOneTimeRequest(erg);
            LVarHelper lvarHelper = new LVarHelper();
            LVarHelper.LVarResult lvarreq = lvarHelper.readLVar("FSDT_GSX_BOARDING_STATE", 26308, LVarHelper.LVarValueFormat.UNSIGNED_BYTE, fsuipc, false);
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("Read Okay");
                System.out.println("The value of lvar: FSDT_GSX_DEBOARDING_STATE is: " + erg.getValue());
                System.out.println("The value of lvar: FSDT_GSX_BOARDING_STATE is: " + lvarreq.getResultRequest().getValue());
            }
            System.out.println("Will write value to LVar: FSDT_GSX_NUMPASSENGERS and will create custom LVar: MOUSEVIATOR_CUSTOM_LVAR");
            lvarHelper.writeLVar("FSDT_GSX_NUMPASSENGERS", 26304, (short)124, LVarHelper.LVarValueFormat.UNSIGNED_SHORT, fsuipc, false);
            lvarHelper.createLVar("MOUSEVIATOR_CUSTOM_LVAR", 26306, 84, LVarHelper.LVarValueFormat.SIGNED_INTEGER, fsuipc);
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("Write/Create Okay");
            }
            System.out.println("Will read back the value od LVar: FSDT_GSX_NUMPASSENGERS and custom created LVar: MOUSEVIATOR_CUSTOM_LVAR");
            lvarreq = lvarHelper.readLVar("FSDT_GSX_NUMPASSENGERS", 26304, LVarHelper.LVarValueFormat.UNSIGNED_SHORT, fsuipc, false);
            LVarHelper.LVarResult lvarreq2 = lvarHelper.readLVar("MOUSEVIATOR_CUSTOM_LVAR", 26306, LVarHelper.LVarValueFormat.SIGNED_INTEGER, fsuipc, false);
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("Read Okay");
                System.out.println("The value of lvar: FSDT_GSX_NUMPASSENGERS is: " + lvarreq.getResultRequest().getValue());
                System.out.println("The value of lvar: MOUSEVIATOR_CUSTOM_LVAR is: " + lvarreq2.getResultRequest().getValue());
            }
            System.out.println("\n\n>>> Lua Tests...");
            LuaHelper luaHelper = new LuaHelper();
            System.out.println("Will try to run the \"hello world.lua\" and \"blocking script.lua\"");
            LuaHelper.LuaResult helloworldreq = luaHelper.lua("hello world");
            fsuipc.addOneTimeRequest(helloworldreq.getParamRequest());
            fsuipc.addOneTimeRequest(helloworldreq.getControlRequest());
            LuaHelper.LuaResult blockingscrreq = luaHelper.lua("blocking script", fsuipc);
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("The \"hello world.lua\" should have run.");
                System.out.println("The \"blocking script.lua\" should be running.");
            }
            System.out.println("Will sleep for 5 seconds now...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FSUIPCLVarLuaMacroTest.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("Will try to to kill the \"blocking script.lua\"");
            LuaHelper.LuaResult blockingkillreq = luaHelper.luaKill("blocking script");
            fsuipc.addOneTimeRequest(blockingkillreq.getParamRequest());
            fsuipc.addOneTimeRequest(blockingkillreq.getControlRequest());
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("The \"blocking script.lua\" script should have been terminated!");
            }
            System.out.println("Will try to run the \"flag_param.lua\" for testing the sending of param and setting the flags...");
            String LUA_FLAG_PARAM_PROGRAM = "flag_param";
            LuaHelper.LuaResult paramscrreq = luaHelper.lua("flag_param", 25);
            fsuipc.addOneTimeRequest(paramscrreq.getParamRequest());
            fsuipc.addOneTimeRequest(paramscrreq.getControlRequest());
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("The \"flag_param.lua\" should be running...");
                int flag = 10;
                System.out.println("Will try to set flag: " + flag + " for program: flag_param");
                LuaHelper.LuaResult flagreq = luaHelper.luaSet("flag_param", flag);
                fsuipc.addOneTimeRequest(flagreq.getParamRequest());
                fsuipc.addOneTimeRequest(flagreq.getControlRequest());
                if (fsuipc.processRequestsOnce() == 500) {
                    System.out.println("Flag " + flag + " should be set for program: flag_param");
                }
                System.out.println("Will try to clear flag: " + flag + " for program: flag_param");
                flagreq = luaHelper.luaClear("flag_param", flag);
                fsuipc.addOneTimeRequest(flagreq.getParamRequest());
                fsuipc.addOneTimeRequest(flagreq.getControlRequest());
                if (fsuipc.processRequestsOnce() == 500) {
                    System.out.println("Flag " + flag + " should be cleared for program: flag_param");
                }
                System.out.println("Will try to toggle flag: " + flag + " for program: flag_param");
                flagreq = luaHelper.luaToggle("flag_param", flag, fsuipc);
                if (fsuipc.processRequestsOnce() == 500) {
                    System.out.println("Flag " + flag + " should be toggled for program: flag_param");
                }
                System.out.println("Will try to send param of value: 40 to the program: flag_param");
                LuaHelper.LuaResult paramreq = luaHelper.luaValue("flag_param", 40);
                fsuipc.addOneTimeRequest(paramreq.getParamRequest());
                fsuipc.addOneTimeRequest(paramreq.getControlRequest());
                if (fsuipc.processRequestsOnce() == 500) {
                    System.out.println("Parameter should be 40 for program: flag_param");
                }
            }
            IDataRequest killallreq = luaHelper.luaKillAll();
            fsuipc.addOneTimeRequest(killallreq);
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("All scripts should be terminated!");
            }
            System.out.println("\n\n>>> Macro Tests....");
            MacroHelper macroHelper = new MacroHelper();
            System.out.println("Trying to execute macro: \"fsuipctest:PauseToggle\" which should toggle the pause in the sim.");
            MacroHelper.MacroResult macroreq = macroHelper.executeMacro("fsuipctest", "PauseToggle");
            fsuipc.addOneTimeRequest(macroreq.getParamRequest());
            fsuipc.addOneTimeRequest(macroreq.getMacroExecuteRequest());
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("The macro: \"fsuipctest:PauseToggle\" should have execute. The sim pause should toggle.");
            }
            System.out.println("Trying to execute macro: \"fsuipctest:ParkBrake\" with param 0, which should unset parking brake.");
            macroreq = macroHelper.executeMacro("fsuipctest:ParkBrake", 0, fsuipc, false);
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("The macro: \"fsuipctest:ParkBrake\" should have execute. The parking brake should be unset.");
            }
            System.out.println("Trying to execute macro: \"fsuipctest:ParkBrake\" with param 1, which should set parking brake.");
            macroreq = macroHelper.executeMacro("fsuipctest:ParkBrake", 1);
            fsuipc.addOneTimeRequest(macroreq.getParamRequest());
            fsuipc.addOneTimeRequest(macroreq.getMacroExecuteRequest());
            if (fsuipc.processRequestsOnce() == 500) {
                System.out.println("The macro: \"fsuipctest:ParkBrake\" should have execute. The parking brake should be set.");
            }
            fsuipc.disconnect();
            System.out.println("FSUIPC disconnected. Good bye.");
        }
    }
}

