/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.InvalidParameterException;

public class StringRequest
extends DataRequest
implements IDataRequest<String> {
    private Charset charset = Charset.defaultCharset();

    public StringRequest(int offset, int size) {
        if (offset < 0 || offset > Integer.MAX_VALUE || size <= 0) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.dataBuffer = new byte[size];
        this.offset = offset;
    }

    public StringRequest(int offset, String value) {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.dataBuffer = value.getBytes(this.charset);
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public StringRequest(int offset, int max_size, String value) {
        ByteBuffer byteBuffer;
        if (offset >= 0 && offset <= Integer.MAX_VALUE) {
            CharsetEncoder enc = this.charset.newEncoder();
            byteBuffer = ByteBuffer.allocate(max_size);
            enc.encode(CharBuffer.wrap(value), byteBuffer, true);
            if (!byteBuffer.hasRemaining()) {
                byteBuffer.position(byteBuffer.position() - 1);
            }
        } else {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        byteBuffer.put((byte)0);
        this.dataBuffer = new byte[byteBuffer.position()];
        byteBuffer.get(this.dataBuffer, 0, byteBuffer.position());
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public StringRequest(int offset, String value, Charset charset) {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.dataBuffer = value.getBytes(charset);
        this.charset = charset;
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public StringRequest(int offset, int max_size, String value, Charset charset) {
        ByteBuffer byteBuffer;
        if (offset >= 0 && offset <= Integer.MAX_VALUE) {
            CharsetEncoder enc = charset.newEncoder();
            byteBuffer = ByteBuffer.allocate(max_size);
            enc.encode(CharBuffer.wrap(value), byteBuffer, true);
            if (!byteBuffer.hasRemaining()) {
                byteBuffer.position(byteBuffer.position() - 1);
            }
        } else {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        byteBuffer.put((byte)0);
        this.dataBuffer = new byte[byteBuffer.position()];
        byteBuffer.get(this.dataBuffer, 0, byteBuffer.position());
        this.charset = charset;
        this.offset = offset;
        this.type = IDataRequest.RequestType.WRITE;
    }

    public void allocate(int size) {
        if (size > 0) {
            this.dataBuffer = new byte[size];
        }
    }

    @Override
    public String getValue() {
        return new String(this.dataBuffer, this.charset).trim();
    }

    @Override
    public void setValue(String value) {
        this.dataBuffer = value.getBytes(this.charset);
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }
}

