/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.example;

import com.mouseviator.fsuipc.FSUIPC;
import com.mouseviator.fsuipc.FSUIPCWrapper;
import com.mouseviator.fsuipc.IFSUIPCListener;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.advanced.FSControlRequest;
import com.mouseviator.fsuipc.datarequest.primitives.DoubleRequest;
import com.mouseviator.fsuipc.datarequest.primitives.FloatRequest;
import com.mouseviator.fsuipc.datarequest.primitives.IntRequest;
import com.mouseviator.fsuipc.datarequest.primitives.ShortRequest;
import com.mouseviator.fsuipc.helpers.SimHelper;
import com.mouseviator.fsuipc.helpers.aircraft.AircraftHelper;
import com.mouseviator.fsuipc.helpers.aircraft.Engine1Helper;
import com.mouseviator.fsuipc.helpers.aircraft.Engine2Helper;
import com.mouseviator.fsuipc.helpers.avionics.GPSHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalTime;
import java.util.AbstractQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;

public class FSUIPCSimMonitor
extends JFrame {
    private final byte DEFAULT_ZOOM = (byte)7;
    public static final GeoPosition DEFAULT_LOCATION = new GeoPosition(48.652032, -122.585922);
    private final JXMapKit jXMapKit = new JXMapKit();
    private final FSUIPC fsuipc = FSUIPC.getInstance();
    private IFSUIPCListener fsuipcListener;
    private static final Logger logger = Logger.getLogger(FSUIPCSimMonitor.class.getName());
    private final AircraftHelper aircraftHelper = new AircraftHelper();
    private final SimHelper simHelper = new SimHelper();
    private final GPSHelper gpsHelper = new GPSHelper();
    private final Engine1Helper engine1Helper = new Engine1Helper();
    private final Engine2Helper engine2Helper = new Engine2Helper();
    private FloatRequest aircraftHeading;
    private IDataRequest<Float> aircraftMagVar;
    private FloatRequest aircraftBank;
    private FloatRequest aircraftPitch;
    private IDataRequest<Double> gpsAltitude;
    private DoubleRequest aircraftLatitude;
    private DoubleRequest aircraftLongitude;
    private FloatRequest aircraftIAS;
    private FloatRequest aircraftTAS;
    private FloatRequest aircraftVS;
    private IDataRequest<Short> pauseIndicator;
    private IntRequest simLocalTime;
    private ShortRequest eng1ThrLever;
    private ShortRequest eng1MixLever;
    private ShortRequest eng1PropLever;
    private FloatRequest eng1OilTemp;
    private FloatRequest eng1OilQuantity;
    private FloatRequest eng1OilPressure;
    private DoubleRequest eng1FuelFlow;
    private ShortRequest eng2ThrLever;
    private ShortRequest eng2MixLever;
    private ShortRequest eng2PropLever;
    private FloatRequest eng2OilTemp;
    private FloatRequest eng2OilQuantity;
    private FloatRequest eng2OilPressure;
    private DoubleRequest eng2FuelFlow;
    private IDataRequest<Float> simFrameRate;
    private ShortRequest slewMode;
    private FSControlRequest slewControl = new FSControlRequest(65557);
    private final DecimalFormat decimalFormat1 = new DecimalFormat("#.#");
    private final DecimalFormat decimalFormat3 = new DecimalFormat("#.###");
    private boolean libFileLoggingEnabled = true;
    private JButton cmdPause;
    private JToggleButton cmdSlewToggle;
    private JButton cmdToggleLibFileLogging;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblAltitude;
    private JLabel lblAltitudeCap;
    private JLabel lblBank;
    private JLabel lblBankCap;
    private JLabel lblEng1FF;
    private JLabel lblEng1FFCap;
    private JLabel lblEng1MixCap;
    private JLabel lblEng1OilPress;
    private JLabel lblEng1OilPressCap;
    private JLabel lblEng1OilQuantity;
    private JLabel lblEng1OilQuantityCap;
    private JLabel lblEng1OilTemp;
    private JLabel lblEng1OilTempCap;
    private JLabel lblEng1PropCap;
    private JLabel lblEng1ThrCap;
    private JLabel lblEng2FF;
    private JLabel lblEng2FFCap;
    private JLabel lblEng2MixCap;
    private JLabel lblEng2OilPress;
    private JLabel lblEng2OilPressCap;
    private JLabel lblEng2OilQuantity;
    private JLabel lblEng2OilQuantityCap;
    private JLabel lblEng2OilTemp;
    private JLabel lblEng2OilTempCap;
    private JLabel lblEng2PropCap;
    private JLabel lblEng2ThrCap;
    private JLabel lblEngine1;
    private JLabel lblEngine2;
    private JLabel lblFSUIPCLibVersion;
    private JLabel lblFSUIPCLibVersionCap;
    private JLabel lblFSUIPCVersion;
    private JLabel lblFSUIPCVersionCap;
    private JLabel lblFSVersion;
    private JLabel lblFSVersionCap;
    private JLabel lblFrameRate;
    private JLabel lblFrameRateCap;
    private JLabel lblHeading;
    private JLabel lblHeadingCap;
    private JLabel lblIAS;
    private JLabel lblIASCap;
    private JLabel lblInfo;
    private JLabel lblLatitude;
    private JLabel lblLatitudeCap;
    private JLabel lblLongitude;
    private JLabel lblLongitudeCap;
    private JLabel lblPitch;
    private JLabel lblPitchCap;
    private JLabel lblSimLocalTime;
    private JLabel lblSimLocalTimeCap;
    private JLabel lblSituationFile;
    private JLabel lblSituationFileCap;
    private JLabel lblStatus1;
    private JLabel lblStatus2;
    private JLabel lblStatusCap;
    private JLabel lblTAS;
    private JLabel lblTASCap;
    private JLabel lblVS;
    private JLabel lblVSCap;
    private JProgressBar pbEngine1Mix;
    private JProgressBar pbEngine1Prop;
    private JProgressBar pbEngine1Thr;
    private JProgressBar pbEngine2Mix;
    private JProgressBar pbEngine2Prop;
    private JProgressBar pbEngine2Thr;
    private JPanel pnlEngineInfo;
    private JPanel pnlMapViewer;

    public FSUIPCSimMonitor() {
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
        dfs.setDecimalSeparator('.');
        this.decimalFormat1.setDecimalFormatSymbols(dfs);
        this.decimalFormat3.setDecimalFormatSymbols(dfs);
        Logger logger = Logger.getLogger("com.mouseviator");
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINER);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.FINER);
        this.initComponents();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                FSUIPCSimMonitor.this.fsuipc.disconnect();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.initMapViewer();
        this.fsuipcStatusChanged(false);
        this.setTitle(false);
        this.startFSUIPC();
    }

    private void initComponents() {
        this.pnlMapViewer = new JPanel();
        this.lblSituationFileCap = new JLabel();
        this.lblSituationFile = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblPitchCap = new JLabel();
        this.lblPitch = new JLabel();
        this.lblBank = new JLabel();
        this.lblBankCap = new JLabel();
        this.lblHeadingCap = new JLabel();
        this.lblHeading = new JLabel();
        this.lblLatitudeCap = new JLabel();
        this.lblLatitude = new JLabel();
        this.lblLongitudeCap = new JLabel();
        this.lblLongitude = new JLabel();
        this.lblAltitudeCap = new JLabel();
        this.lblAltitude = new JLabel();
        this.lblVSCap = new JLabel();
        this.lblVS = new JLabel();
        this.lblIASCap = new JLabel();
        this.lblIAS = new JLabel();
        this.lblTASCap = new JLabel();
        this.lblTAS = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblStatusCap = new JLabel();
        this.lblFSVersionCap = new JLabel();
        this.lblFSVersion = new JLabel();
        this.lblFSUIPCVersionCap = new JLabel();
        this.lblFSUIPCVersion = new JLabel();
        this.lblFSUIPCLibVersionCap = new JLabel();
        this.lblFSUIPCLibVersion = new JLabel();
        this.lblStatus2 = new JLabel();
        this.lblStatus1 = new JLabel();
        this.lblSimLocalTimeCap = new JLabel();
        this.lblSimLocalTime = new JLabel();
        this.cmdPause = new JButton();
        this.lblFrameRateCap = new JLabel();
        this.lblFrameRate = new JLabel();
        this.lblInfo = new JLabel();
        this.pnlEngineInfo = new JPanel();
        this.lblEng1ThrCap = new JLabel();
        this.lblEng2ThrCap = new JLabel();
        this.lblEng1MixCap = new JLabel();
        this.lblEng2MixCap = new JLabel();
        this.pbEngine1Thr = new JProgressBar();
        this.pbEngine2Thr = new JProgressBar();
        this.pbEngine1Mix = new JProgressBar();
        this.pbEngine2Mix = new JProgressBar();
        this.lblEng2PropCap = new JLabel();
        this.lblEng1PropCap = new JLabel();
        this.pbEngine1Prop = new JProgressBar();
        this.pbEngine2Prop = new JProgressBar();
        this.lblEng1OilQuantityCap = new JLabel();
        this.lblEngine1 = new JLabel();
        this.lblEng1OilQuantity = new JLabel();
        this.lblEng1OilTemp = new JLabel();
        this.lblEng1OilTempCap = new JLabel();
        this.lblEng1OilPress = new JLabel();
        this.lblEng1OilPressCap = new JLabel();
        this.lblEngine2 = new JLabel();
        this.lblEng2OilQuantityCap = new JLabel();
        this.lblEng2OilQuantity = new JLabel();
        this.lblEng2OilTempCap = new JLabel();
        this.lblEng2OilPressCap = new JLabel();
        this.lblEng2OilTemp = new JLabel();
        this.lblEng2OilPress = new JLabel();
        this.lblEng2FFCap = new JLabel();
        this.lblEng2FF = new JLabel();
        this.lblEng1FFCap = new JLabel();
        this.lblEng1FF = new JLabel();
        this.cmdToggleLibFileLogging = new JButton();
        this.cmdSlewToggle = new JToggleButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("FSUIPC Aircraft Monitor");
        this.pnlMapViewer.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnlMapViewer.setLayout(new BorderLayout());
        this.lblSituationFileCap.setText("Situation file:");
        this.lblSituationFile.setFont(new Font("Tahoma", 3, 11));
        this.lblSituationFile.setText("N/A");
        this.lblSituationFile.setVerticalAlignment(1);
        this.lblSituationFile.setVerticalTextPosition(1);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Aircraft Info:"));
        this.lblPitchCap.setText("Pitch:");
        this.lblPitch.setFont(new Font("Tahoma", 1, 11));
        this.lblBank.setFont(new Font("Tahoma", 1, 11));
        this.lblBankCap.setText("Bank:");
        this.lblHeadingCap.setText("Heading:");
        this.lblHeading.setFont(new Font("Tahoma", 1, 11));
        this.lblLatitudeCap.setText("Latitude:");
        this.lblLatitude.setFont(new Font("Tahoma", 1, 11));
        this.lblLongitudeCap.setText("Longitude:");
        this.lblLongitude.setFont(new Font("Tahoma", 1, 11));
        this.lblAltitudeCap.setText("Altitude:");
        this.lblAltitude.setFont(new Font("Tahoma", 1, 11));
        this.lblVSCap.setText("Vertical speed:");
        this.lblVS.setFont(new Font("Tahoma", 1, 11));
        this.lblIASCap.setText("IAS:");
        this.lblIAS.setFont(new Font("Tahoma", 1, 11));
        this.lblTASCap.setText("TAS:");
        this.lblTAS.setFont(new Font("Tahoma", 1, 11));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVSCap, -2, 108, -2).addComponent(this.lblAltitudeCap, -2, 108, -2).addComponent(this.lblPitchCap, -2, 84, -2).addComponent(this.lblBankCap, -2, 84, -2).addComponent(this.lblHeadingCap, -2, 84, -2).addComponent(this.lblLongitudeCap, -2, 108, -2).addComponent(this.lblLatitudeCap, -2, 108, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblVS, -1, 208, Short.MAX_VALUE).addComponent(this.lblLatitude, -1, -1, Short.MAX_VALUE).addComponent(this.lblLongitude, -1, -1, Short.MAX_VALUE).addComponent(this.lblAltitude, -1, -1, Short.MAX_VALUE).addComponent(this.lblHeading, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPitch, -2, 208, -2).addComponent(this.lblBank, -2, 208, -2))))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblIASCap, -2, 108, -2).addComponent(this.lblTASCap, -2, 108, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblIAS, -1, 208, Short.MAX_VALUE).addComponent(this.lblTAS, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.lblAltitudeCap, this.lblBankCap, this.lblHeadingCap, this.lblIASCap, this.lblLatitudeCap, this.lblLongitudeCap, this.lblPitchCap, this.lblTASCap, this.lblVSCap);
        jPanel1Layout.linkSize(0, this.lblAltitude, this.lblBank, this.lblHeading, this.lblIAS, this.lblLatitude, this.lblLongitude, this.lblPitch, this.lblTAS, this.lblVS);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPitchCap).addComponent(this.lblPitch, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBankCap).addComponent(this.lblBank, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblHeadingCap).addComponent(this.lblHeading, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLatitudeCap).addComponent(this.lblLatitude, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLongitudeCap).addComponent(this.lblLongitude, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAltitudeCap).addComponent(this.lblAltitude, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVSCap).addComponent(this.lblVS, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblIASCap).addComponent(this.lblIAS, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTASCap).addComponent(this.lblTAS, -2, 14, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Sim info:"));
        this.lblStatusCap.setText("Status:");
        this.lblStatusCap.setToolTipText("");
        this.lblFSVersionCap.setText("FS Version:");
        this.lblFSVersionCap.setToolTipText("");
        this.lblFSVersion.setFont(new Font("Tahoma", 1, 11));
        this.lblFSUIPCVersionCap.setText("FSUIPC version:");
        this.lblFSUIPCVersionCap.setToolTipText("");
        this.lblFSUIPCVersion.setFont(new Font("Tahoma", 1, 11));
        this.lblFSUIPCLibVersionCap.setText("FSUIPC Lib version:");
        this.lblFSUIPCLibVersionCap.setToolTipText("");
        this.lblFSUIPCLibVersion.setFont(new Font("Tahoma", 1, 11));
        this.lblStatus2.setLabelFor(this.lblStatusCap);
        this.lblStatus1.setLabelFor(this.lblStatusCap);
        this.lblSimLocalTimeCap.setText("Local time:");
        this.lblSimLocalTimeCap.setToolTipText("");
        this.lblSimLocalTime.setFont(new Font("Tahoma", 1, 11));
        this.cmdPause.setText("Pause");
        this.cmdPause.setEnabled(false);
        this.cmdPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FSUIPCSimMonitor.this.cmdPauseActionPerformed(evt);
            }
        });
        this.lblFrameRateCap.setText("Frame rate:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatusCap, -2, 108, -2).addComponent(this.lblFSUIPCLibVersionCap, -2, 108, -2).addComponent(this.lblFSUIPCVersionCap, -2, 84, -2).addComponent(this.lblFSVersionCap, -2, 84, -2)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblFSVersion, -1, -1, Short.MAX_VALUE).addComponent(this.lblFSUIPCVersion, -1, -1, Short.MAX_VALUE).addComponent(this.lblFSUIPCLibVersion, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus1, -1, -1, Short.MAX_VALUE).addComponent(this.lblStatus2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdPause)))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblFrameRateCap, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblSimLocalTimeCap, GroupLayout.Alignment.LEADING, -1, 108, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSimLocalTime, -1, -1, Short.MAX_VALUE).addComponent(this.lblFrameRate, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.lblFSUIPCLibVersionCap, this.lblFSUIPCVersionCap, this.lblFSVersionCap, this.lblStatusCap);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblStatusCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblStatus1, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus2, -2, 14, -2)).addComponent(this.cmdPause)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFSVersionCap).addComponent(this.lblFSVersion, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFSUIPCVersionCap).addComponent(this.lblFSUIPCVersion, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFSUIPCLibVersionCap).addComponent(this.lblFSUIPCLibVersion, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSimLocalTimeCap).addComponent(this.lblSimLocalTime, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFrameRateCap).addComponent(this.lblFrameRate)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlEngineInfo.setBorder(BorderFactory.createTitledBorder("Engine Info:"));
        this.pnlEngineInfo.setPreferredSize(new Dimension(215, 100));
        this.lblEng1ThrCap.setText("Throttle Lever:");
        this.lblEng2ThrCap.setText("Engine 2 Throttle:");
        this.lblEng1MixCap.setText("Mixture Lever:");
        this.lblEng2MixCap.setText("Engine 2 Mixture:");
        this.pbEngine1Thr.setMaximum(16384);
        this.pbEngine1Thr.setMinimum(-4096);
        this.pbEngine1Thr.setString("0");
        this.pbEngine1Thr.setStringPainted(true);
        this.pbEngine2Thr.setMaximum(16384);
        this.pbEngine2Thr.setMinimum(-4096);
        this.pbEngine2Thr.setString("0");
        this.pbEngine2Thr.setStringPainted(true);
        this.pbEngine1Mix.setMaximum(16384);
        this.pbEngine1Mix.setString("0");
        this.pbEngine1Mix.setStringPainted(true);
        this.pbEngine2Mix.setMaximum(16384);
        this.pbEngine2Mix.setString("0");
        this.pbEngine2Mix.setStringPainted(true);
        this.lblEng2PropCap.setText("Engine 2 Propeller:");
        this.lblEng1PropCap.setText("Propeller Lever:");
        this.pbEngine1Prop.setMaximum(16384);
        this.pbEngine1Prop.setMinimum(-4096);
        this.pbEngine1Prop.setString("0");
        this.pbEngine1Prop.setStringPainted(true);
        this.pbEngine2Prop.setMaximum(16384);
        this.pbEngine2Prop.setMinimum(-4096);
        this.pbEngine2Prop.setString("0");
        this.pbEngine2Prop.setStringPainted(true);
        this.lblEng1OilQuantityCap.setText("Oil Quantity:");
        this.lblEngine1.setBackground(new Color(204, 204, 204));
        this.lblEngine1.setHorizontalAlignment(0);
        this.lblEngine1.setText("Engine 1");
        this.lblEngine1.setOpaque(true);
        this.lblEng1OilTempCap.setText("Oil Temperature:");
        this.lblEng1OilPressCap.setText("Oil Pressure:");
        this.lblEngine2.setBackground(new Color(204, 204, 204));
        this.lblEngine2.setHorizontalAlignment(0);
        this.lblEngine2.setText("Engine 2");
        this.lblEngine2.setOpaque(true);
        this.lblEng2OilQuantityCap.setText("Oil Quantity:");
        this.lblEng2OilTempCap.setText("Oil Temperature:");
        this.lblEng2OilPressCap.setText("Oil Pressure:");
        this.lblEng2FFCap.setText("Fuel flow:");
        this.lblEng1FFCap.setText("Fuel flow:");
        GroupLayout pnlEngineInfoLayout = new GroupLayout(this.pnlEngineInfo);
        this.pnlEngineInfo.setLayout(pnlEngineInfoLayout);
        pnlEngineInfoLayout.setHorizontalGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEngineInfoLayout.createSequentialGroup().addContainerGap().addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEngineInfoLayout.createSequentialGroup().addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblEng2ThrCap, -2, 109, -2).addComponent(this.lblEng2MixCap, -2, 107, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pbEngine2Mix, -1, 192, Short.MAX_VALUE).addComponent(this.pbEngine2Thr, -1, -1, Short.MAX_VALUE))).addGroup(pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng2PropCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pbEngine2Prop, -2, 192, -2)).addGroup(pnlEngineInfoLayout.createSequentialGroup().addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblEng1ThrCap, -2, 107, -2).addComponent(this.lblEng1MixCap, -2, 109, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pbEngine1Mix, -1, -1, Short.MAX_VALUE).addComponent(this.pbEngine1Thr, -1, -1, Short.MAX_VALUE))).addGroup(pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng1PropCap, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pbEngine1Prop, -2, 192, -2)).addGroup(pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng1OilQuantityCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng1OilQuantity, -1, -1, Short.MAX_VALUE)).addComponent(this.lblEngine1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng1OilTempCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng1OilTemp, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng1OilPressCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng1OilPress, -1, -1, Short.MAX_VALUE)).addComponent(this.lblEngine2, -1, -1, Short.MAX_VALUE).addGroup(pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng2OilQuantityCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng2OilQuantity, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng2OilTempCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng2OilTemp, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng2OilPressCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng2OilPress, -1, -1, Short.MAX_VALUE)).addGroup(pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng2FFCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng2FF, -1, -1, Short.MAX_VALUE)).addGroup(pnlEngineInfoLayout.createSequentialGroup().addComponent(this.lblEng1FFCap, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEng1FF, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        pnlEngineInfoLayout.linkSize(0, this.lblEng1MixCap, this.lblEng1ThrCap, this.lblEng2MixCap, this.lblEng2ThrCap);
        pnlEngineInfoLayout.linkSize(0, this.pbEngine1Mix, this.pbEngine1Thr, this.pbEngine2Mix, this.pbEngine2Thr);
        pnlEngineInfoLayout.setVerticalGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEngineInfoLayout.createSequentialGroup().addContainerGap().addComponent(this.lblEngine1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblEng1ThrCap).addComponent(this.pbEngine1Thr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblEng1MixCap).addComponent(this.pbEngine1Mix, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblEng1PropCap).addComponent(this.pbEngine1Prop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng1OilQuantityCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng1OilQuantity, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng1OilTempCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng1OilTemp, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng1OilPressCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng1OilPress, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng1FFCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng1FF, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblEngine2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblEng2ThrCap).addComponent(this.pbEngine2Thr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblEng2MixCap).addComponent(this.pbEngine2Mix, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblEng2PropCap).addComponent(this.pbEngine2Prop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng2OilQuantityCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng2OilQuantity, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng2OilTempCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng2OilTemp, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng2OilPressCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng2OilPress, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEngineInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblEng2FFCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblEng2FF, -2, 14, -2)).addContainerGap()));
        this.cmdToggleLibFileLogging.setText("Enable Lib File Log");
        this.cmdToggleLibFileLogging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FSUIPCSimMonitor.this.cmdToggleLibFileLoggingActionPerformed(evt);
            }
        });
        this.cmdSlewToggle.setText("Slew");
        this.cmdSlewToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FSUIPCSimMonitor.this.cmdSlewToggleActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMapViewer, -2, 431, -2).addComponent(this.cmdSlewToggle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlEngineInfo, -2, 337, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblSituationFileCap, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSituationFile, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblInfo, -2, 1013, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdToggleLibFileLogging, -1, -1, Short.MAX_VALUE))).addGap(14, 14, 14)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.pnlEngineInfo, -1, 416, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.pnlMapViewer, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdSlewToggle))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblSituationFileCap, -1, -1, Short.MAX_VALUE).addComponent(this.lblSituationFile, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblInfo, -2, 21, -2).addComponent(this.cmdToggleLibFileLogging)).addContainerGap()));
        this.pack();
    }

    private void cmdPauseActionPerformed(ActionEvent evt) {
        IDataRequest writePauseRequest = this.cmdPause.getText().equals("Pause") ? this.simHelper.setPause(true) : this.simHelper.setPause(false);
        this.fsuipc.addOneTimeRequest(writePauseRequest);
    }

    private void cmdToggleLibFileLoggingActionPerformed(ActionEvent evt) {
        this.toggleLibFileLogging();
    }

    private void cmdSlewToggleActionPerformed(ActionEvent evt) {
        this.fsuipc.addOneTimeRequest((IDataRequest)this.slewControl);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FSUIPCSimMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FSUIPCSimMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FSUIPCSimMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FSUIPCSimMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FSUIPCSimMonitor().setVisible(true);
            }
        });
    }

    private void initMapViewer() {
        this.pnlMapViewer.add(this.jXMapKit);
        this.jXMapKit.setTileFactory(new DefaultTileFactory(new OSMTileFactoryInfo()));
        this.jXMapKit.setAddressLocationShown(true);
        this.jXMapKit.setAddressLocation(DEFAULT_LOCATION);
        this.jXMapKit.setZoom(7);
    }

    private void startFSUIPC() {
        byte result = FSUIPC.load();
        if (result != 0) {
            this.lblInfo.setText("<html><p style=\"background-color: red; color: white; font-weight: bold\">Failed to load native library. NO JOY! This is all folks!!!</p></html>");
            return;
        }
        this.toggleLibFileLogging();
        this.fsuipcListener = new IFSUIPCListener(){

            public void onConnected() {
                logger.info("FSUIPC connected!");
                final IDataRequest situationFile = FSUIPCSimMonitor.this.fsuipc.addOneTimeRequest(FSUIPCSimMonitor.this.simHelper.getSituationFile());
                final IDataRequest fsxp3dVersion = FSUIPCSimMonitor.this.fsuipc.addOneTimeRequest(FSUIPCSimMonitor.this.simHelper.getFSXP3DVersion());
                FSUIPCSimMonitor.this.fsuipc.processRequestsOnce();
                FSUIPCSimMonitor.this.fsuipc.clearContinualRequests();
                FSUIPCSimMonitor.this.aircraftHeading = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getHeading());
                FSUIPCSimMonitor.this.aircraftMagVar = FSUIPCSimMonitor.this.fsuipc.addContinualRequest(FSUIPCSimMonitor.this.aircraftHelper.getMagneticVariation());
                FSUIPCSimMonitor.this.aircraftBank = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getBank());
                FSUIPCSimMonitor.this.aircraftPitch = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getPitch());
                FSUIPCSimMonitor.this.gpsAltitude = FSUIPCSimMonitor.this.fsuipc.addContinualRequest(FSUIPCSimMonitor.this.gpsHelper.getAltitude(true));
                FSUIPCSimMonitor.this.aircraftLatitude = (DoubleRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getLatitude());
                FSUIPCSimMonitor.this.aircraftLongitude = (DoubleRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getLongitude());
                FSUIPCSimMonitor.this.aircraftVS = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getVerticalSpeed(true));
                FSUIPCSimMonitor.this.aircraftIAS = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getIAS());
                FSUIPCSimMonitor.this.aircraftTAS = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.aircraftHelper.getTAS());
                FSUIPCSimMonitor.this.pauseIndicator = FSUIPCSimMonitor.this.fsuipc.addContinualRequest(FSUIPCSimMonitor.this.simHelper.getPauseIndicator());
                FSUIPCSimMonitor.this.simLocalTime = (IntRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.simHelper.getLocalTime());
                FSUIPCSimMonitor.this.simFrameRate = FSUIPCSimMonitor.this.fsuipc.addContinualRequest(FSUIPCSimMonitor.this.simHelper.getFrameRate());
                FSUIPCSimMonitor.this.eng1ThrLever = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine1Helper.getThrottleLever());
                FSUIPCSimMonitor.this.eng1MixLever = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine1Helper.getMixtureLever());
                FSUIPCSimMonitor.this.eng1PropLever = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine1Helper.getPropellerLever());
                FSUIPCSimMonitor.this.eng1OilQuantity = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine1Helper.getOilQuantity());
                FSUIPCSimMonitor.this.eng1OilTemp = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine1Helper.getOilTemperature());
                FSUIPCSimMonitor.this.eng1OilPressure = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine1Helper.getOilPressure());
                FSUIPCSimMonitor.this.eng1FuelFlow = (DoubleRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getFuelFlow());
                FSUIPCSimMonitor.this.eng2ThrLever = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getThrottleLever());
                FSUIPCSimMonitor.this.eng2MixLever = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getMixtureLever());
                FSUIPCSimMonitor.this.eng2PropLever = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getPropellerLever());
                FSUIPCSimMonitor.this.eng2OilQuantity = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getOilQuantity());
                FSUIPCSimMonitor.this.eng2OilTemp = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getOilTemperature());
                FSUIPCSimMonitor.this.eng2OilPressure = (FloatRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getOilPressure());
                FSUIPCSimMonitor.this.eng2FuelFlow = (DoubleRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)FSUIPCSimMonitor.this.engine2Helper.getFuelFlow());
                FSUIPCSimMonitor.this.slewMode = (ShortRequest)FSUIPCSimMonitor.this.fsuipc.addContinualRequest((IDataRequest)new ShortRequest(1500));
                FSUIPCSimMonitor.this.fsuipc.processRequests(250, true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FSUIPCSimMonitor.this.fsuipcStatusChanged(true);
                        FSUIPCSimMonitor.this.lblSituationFile.setText(((String)situationFile.getValue()).trim());
                        FSUIPCSimMonitor.this.lblFSVersion.setText(FSUIPCSimMonitor.this.fsuipc.getFSVersion() + " (" + (String)fsxp3dVersion.getValue() + ")");
                        FSUIPCSimMonitor.this.cmdPause.setEnabled(true);
                        FSUIPCSimMonitor.this.setTitle(true);
                    }
                });
            }

            public void onDisconnected() {
                logger.info("FSUIPC disconnected!");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FSUIPCSimMonitor.this.fsuipcStatusChanged(false);
                        FSUIPCSimMonitor.this.lblStatus2.setText("N/A");
                        FSUIPCSimMonitor.this.lblSimLocalTime.setText("N/A");
                        FSUIPCSimMonitor.this.lblFrameRate.setText("N/A");
                        FSUIPCSimMonitor.this.lblHeading.setText("N/A");
                        FSUIPCSimMonitor.this.lblPitch.setText("N/A");
                        FSUIPCSimMonitor.this.lblBank.setText("N/A");
                        FSUIPCSimMonitor.this.lblLatitude.setText("N/A");
                        FSUIPCSimMonitor.this.lblLongitude.setText("N/A");
                        FSUIPCSimMonitor.this.lblAltitude.setText("N/A");
                        FSUIPCSimMonitor.this.lblVS.setText("N/A");
                        FSUIPCSimMonitor.this.lblIAS.setText("N/A");
                        FSUIPCSimMonitor.this.lblTAS.setText("N/A");
                        FSUIPCSimMonitor.this.lblSituationFile.setText("N/A");
                        FSUIPCSimMonitor.this.cmdPause.setEnabled(false);
                        FSUIPCSimMonitor.this.pbEngine1Thr.setValue(0);
                        FSUIPCSimMonitor.this.pbEngine1Mix.setValue(0);
                        FSUIPCSimMonitor.this.pbEngine1Prop.setValue(0);
                        FSUIPCSimMonitor.this.lblEng1FF.setText("N/A");
                        FSUIPCSimMonitor.this.lblEng1OilPress.setText("N/A");
                        FSUIPCSimMonitor.this.lblEng1OilQuantity.setText("N/A");
                        FSUIPCSimMonitor.this.lblEng1OilTemp.setText("N/A");
                        FSUIPCSimMonitor.this.pbEngine2Thr.setValue(0);
                        FSUIPCSimMonitor.this.pbEngine2Mix.setValue(0);
                        FSUIPCSimMonitor.this.pbEngine2Prop.setValue(0);
                        FSUIPCSimMonitor.this.lblEng2FF.setText("N/A");
                        FSUIPCSimMonitor.this.lblEng2OilPress.setText("N/A");
                        FSUIPCSimMonitor.this.lblEng2OilQuantity.setText("N/A");
                        FSUIPCSimMonitor.this.lblEng2OilTemp.setText("N/A");
                        FSUIPCSimMonitor.this.setTitle(false);
                    }
                });
            }

            public void onProcess(AbstractQueue<IDataRequest> arRequests) {
                logger.fine("FSUIPC continual request processing callback!");
                FSUIPCSimMonitor.this.jXMapKit.setAddressLocation(new GeoPosition(FSUIPCSimMonitor.this.aircraftLatitude.getValue(), FSUIPCSimMonitor.this.aircraftLongitude.getValue()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FSUIPCSimMonitor.this.lblHeading.setText(String.format("%d Mag (%d TRUE)", Math.round(FSUIPCSimMonitor.this.aircraftHeading.getValue().floatValue() - ((Float)FSUIPCSimMonitor.this.aircraftMagVar.getValue()).floatValue()), Math.round(FSUIPCSimMonitor.this.aircraftHeading.getValue().floatValue())));
                        float fValue = FSUIPCSimMonitor.this.aircraftPitch.getValue().floatValue();
                        Object label = FSUIPCSimMonitor.this.decimalFormat1.format(Math.abs(fValue));
                        label = fValue == 0.0f ? "LEVEL" : (fValue < 0.0f ? (String)label + " \u00b0 Up" : (String)label + " \u00b0 Down");
                        FSUIPCSimMonitor.this.lblPitch.setText((String)label);
                        fValue = FSUIPCSimMonitor.this.aircraftBank.getValue().floatValue();
                        label = FSUIPCSimMonitor.this.decimalFormat1.format(Math.abs(fValue));
                        label = fValue == 0.0f ? "LEVEL" : (fValue < 0.0f ? (String)label + " \u00b0 Right" : (String)label + " \u00b0 Left");
                        FSUIPCSimMonitor.this.lblBank.setText((String)label);
                        FSUIPCSimMonitor.this.lblLatitude.setText(FSUIPCSimMonitor.this.decimalFormat3.format(FSUIPCSimMonitor.this.aircraftLatitude.getValue()));
                        FSUIPCSimMonitor.this.lblLongitude.setText(FSUIPCSimMonitor.this.decimalFormat3.format(FSUIPCSimMonitor.this.aircraftLongitude.getValue()));
                        FSUIPCSimMonitor.this.lblAltitude.setText(String.format("%d feet", (int)Math.ceil((Double)FSUIPCSimMonitor.this.gpsAltitude.getValue())));
                        FSUIPCSimMonitor.this.lblVS.setText(String.format("%d fpm", (int)Math.ceil(FSUIPCSimMonitor.this.aircraftVS.getValue().floatValue())));
                        FSUIPCSimMonitor.this.lblIAS.setText(String.format("%d Kts", (int)Math.ceil(FSUIPCSimMonitor.this.aircraftIAS.getValue().floatValue())));
                        FSUIPCSimMonitor.this.lblTAS.setText(String.format("%d Kts", (int)Math.ceil(FSUIPCSimMonitor.this.aircraftTAS.getValue().floatValue())));
                        if ((Short)FSUIPCSimMonitor.this.pauseIndicator.getValue() == 0) {
                            FSUIPCSimMonitor.this.cmdPause.setText("Pause");
                            FSUIPCSimMonitor.this.lblStatus2.setText("<html><p style=\"background-color: green; color: white; font-weight: bold\">RUNNING</p></html>");
                        } else {
                            FSUIPCSimMonitor.this.cmdPause.setText("Unpause");
                            FSUIPCSimMonitor.this.lblStatus2.setText("<html><p style=\"background-color: red; color: white; font-weight: bold\">PAUSED</p></html>");
                        }
                        LocalTime localTime = LocalTime.ofSecondOfDay(FSUIPCSimMonitor.this.simLocalTime.getValue().intValue());
                        FSUIPCSimMonitor.this.lblSimLocalTime.setText(localTime.toString());
                        FSUIPCSimMonitor.this.lblFrameRate.setText(FSUIPCSimMonitor.this.decimalFormat3.format(FSUIPCSimMonitor.this.simFrameRate.getValue()));
                        FSUIPCSimMonitor.this.pbEngine1Thr.setValue(FSUIPCSimMonitor.this.eng1ThrLever.getValue().shortValue());
                        FSUIPCSimMonitor.this.pbEngine1Mix.setValue(FSUIPCSimMonitor.this.eng1MixLever.getValue().shortValue());
                        FSUIPCSimMonitor.this.pbEngine1Prop.setValue(FSUIPCSimMonitor.this.eng1PropLever.getValue().shortValue());
                        FSUIPCSimMonitor.this.lblEng1OilQuantity.setText(String.format("%s %%", FSUIPCSimMonitor.this.decimalFormat1.format(FSUIPCSimMonitor.this.eng1OilQuantity.getValue())));
                        FSUIPCSimMonitor.this.lblEng1OilTemp.setText(String.format("%s \u00b0C", FSUIPCSimMonitor.this.decimalFormat1.format(FSUIPCSimMonitor.this.eng1OilTemp.getValue())));
                        FSUIPCSimMonitor.this.lblEng1OilPress.setText(String.format("%s psi", FSUIPCSimMonitor.this.decimalFormat1.format(FSUIPCSimMonitor.this.eng1OilPressure.getValue())));
                        FSUIPCSimMonitor.this.lblEng1FF.setText(String.format("%s pph", FSUIPCSimMonitor.this.decimalFormat3.format(FSUIPCSimMonitor.this.eng1FuelFlow.getValue())));
                        FSUIPCSimMonitor.this.pbEngine1Thr.setString(FSUIPCSimMonitor.this.eng1ThrLever.getValue().toString());
                        FSUIPCSimMonitor.this.pbEngine1Mix.setString(FSUIPCSimMonitor.this.eng1MixLever.getValue().toString());
                        FSUIPCSimMonitor.this.pbEngine1Prop.setString(FSUIPCSimMonitor.this.eng1PropLever.getValue().toString());
                        FSUIPCSimMonitor.this.pbEngine2Thr.setValue(FSUIPCSimMonitor.this.eng2ThrLever.getValue().shortValue());
                        FSUIPCSimMonitor.this.pbEngine2Mix.setValue(FSUIPCSimMonitor.this.eng2MixLever.getValue().shortValue());
                        FSUIPCSimMonitor.this.pbEngine2Prop.setValue(FSUIPCSimMonitor.this.eng2PropLever.getValue().shortValue());
                        FSUIPCSimMonitor.this.lblEng2OilQuantity.setText(String.format("%s %%", FSUIPCSimMonitor.this.decimalFormat1.format(FSUIPCSimMonitor.this.eng2OilQuantity.getValue())));
                        FSUIPCSimMonitor.this.lblEng2OilTemp.setText(String.format("%s \u00b0C", FSUIPCSimMonitor.this.decimalFormat1.format(FSUIPCSimMonitor.this.eng2OilTemp.getValue())));
                        FSUIPCSimMonitor.this.lblEng2OilPress.setText(String.format("%s psi", FSUIPCSimMonitor.this.decimalFormat1.format(FSUIPCSimMonitor.this.eng2OilPressure.getValue())));
                        FSUIPCSimMonitor.this.lblEng2FF.setText(String.format("%s pph", FSUIPCSimMonitor.this.decimalFormat3.format(FSUIPCSimMonitor.this.eng2FuelFlow.getValue())));
                        FSUIPCSimMonitor.this.pbEngine2Thr.setString(FSUIPCSimMonitor.this.eng2ThrLever.getValue().toString());
                        FSUIPCSimMonitor.this.pbEngine2Mix.setString(FSUIPCSimMonitor.this.eng2MixLever.getValue().toString());
                        FSUIPCSimMonitor.this.pbEngine2Prop.setString(FSUIPCSimMonitor.this.eng2PropLever.getValue().toString());
                        if (FSUIPCSimMonitor.this.slewMode.getValue() == 0) {
                            FSUIPCSimMonitor.this.cmdSlewToggle.setText("<html><p style=\"background-color: red; color: white; font-weight: bold\">SLEW OFF</p></html>");
                            FSUIPCSimMonitor.this.cmdSlewToggle.setSelected(false);
                        } else {
                            FSUIPCSimMonitor.this.cmdSlewToggle.setText("<html><p style=\"background-color: green; color: white; font-weight: bold\">SLEW ON</p></html>");
                            FSUIPCSimMonitor.this.cmdSlewToggle.setSelected(true);
                        }
                        FSUIPCSimMonitor.this.lblInfo.setText(String.format("Last processing time: %d ms", FSUIPCSimMonitor.this.fsuipc.getLastProcessingTime() / 1000000L));
                    }
                });
            }

            public void onFail(int lastResult) {
                logger.log(Level.INFO, "Last FSUIPC function call ended with error code: {0}, message: {1}", new Object[]{lastResult, FSUIPC.FSUIPC_ERROR_MESSAGES.get(FSUIPCWrapper.FSUIPCResult.get((int)lastResult))});
            }
        };
        this.fsuipc.addListener(this.fsuipcListener);
        this.fsuipc.waitForConnection(FSUIPCWrapper.FSUIPCSimVersion.SIM_ANY, 5);
    }

    private void toggleLibFileLogging() {
        if (this.libFileLoggingEnabled) {
            FSUIPCWrapper.setupLogging((boolean)true, (String)"fsuipc_java.log", (byte)FSUIPCWrapper.LogSeverity.DEBUG.getValue(), (int)0x1400000);
            this.cmdToggleLibFileLogging.setText("Disable Lib File Log");
            this.libFileLoggingEnabled = false;
        } else {
            FSUIPCWrapper.setupLogging((boolean)false, (String)"fsuipc_java.log", (byte)FSUIPCWrapper.LogSeverity.DEBUG.getValue(), (int)0x1400000);
            this.cmdToggleLibFileLogging.setText("Enable Lib File Log");
            this.libFileLoggingEnabled = true;
        }
    }

    private void setTitle(boolean connected) {
        Object title = "FSUIPC Aircraft Monitor";
        try {
            String arch = System.getProperty("sun.arch.data.model");
            title = arch.equals("32") ? (String)title + " (32 bit) " : (arch.equals("64") ? (String)title + " (64 bit) " : (String)title + " (Unknown architecture) ");
        }
        catch (Exception ex) {
            logger.severe("Failed to determine system architecture!");
        }
        if (connected) {
            title = (String)title + " - Sim CONNECTED!";
        }
        this.setTitle((String)title);
    }

    private void fsuipcStatusChanged(boolean connected) {
        if (connected) {
            this.lblStatus1.setText("<html><p style=\"background-color: green; color: white; font-weight: bold\">CONNECTED</p></html>");
            this.lblFSUIPCVersion.setText(this.fsuipc.getVersion());
            this.lblFSUIPCLibVersion.setText(this.fsuipc.getLibVersion());
        } else {
            this.lblStatus1.setText("<html><p style=\"background-color: red; color: white; font-weight: bold\">DISCONNECTED</p></html>");
            this.lblFSVersion.setText("N/A");
            this.lblFSUIPCVersion.setText("N/A");
            this.lblFSUIPCLibVersion.setText("N/A");
        }
    }
}

